/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.las.core.v_1_0;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.BitSet;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.hortonmachine.gears.io.las.core.ALasWriter;
import org.hortonmachine.gears.io.las.core.ILasHeader;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.utils.ByteUtilities;
import org.hortonmachine.gears.utils.CrsUtilities;
import org.hortonmachine.gears.utils.HMVersion;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LasWriterBuffered
extends ALasWriter {
    private static final String OPEN_METHOD_MSG = "This needs to be called before the open method.";
    private final int bufferCapacity = 0xA00000;
    private final ByteBuffer mainBuffer = ByteBuffer.allocate(0xA00000);
    private int runningBytesCount = 0;
    private File outFile;
    private CoordinateReferenceSystem crs;
    private FileOutputStream fos;
    private File prjFile;
    private double xScale = 0.01;
    private double yScale = 0.01;
    private double zScale = 0.001;
    private double xOffset = 0.0;
    private double yOffset = 0.0;
    private double zOffset = 0.0;
    private double xMin = 0.0;
    private double yMin = 0.0;
    private double zMin = 0.0;
    private double xMax = 0.0;
    private double yMax = 0.0;
    private double zMax = 0.0;
    private int recordsNum = 0;
    private short recordLength = (short)28;
    private FileChannel fileChannel;
    private int recordsNumPosition;
    private int pointFormatPosition;
    private boolean pointFormatHasBeenSet = true;
    private int pointFormat = 3;
    private boolean doWriteGroundElevation;
    private boolean openCalled;
    private int previousReturnNumber = -999;
    private int previousNumberOfReturns = -999;
    private byte[] previousReturnBytes = null;
    private long offsetToData = 227L;
    private int recordLengthPosition;
    private int gpsTimeType = 0;

    public LasWriterBuffered(File outFile, CoordinateReferenceSystem crs) {
        this.outFile = outFile;
        this.crs = crs;
        if (crs != null) {
            String nameWithoutExtention = FileUtilities.getNameWithoutExtention(outFile);
            this.prjFile = new File(outFile.getParent(), nameWithoutExtention + ".prj");
        }
        this.mainBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void setScales(double xScale, double yScale, double zScale) {
        if (this.openCalled) {
            throw new ModelsIllegalargumentException(OPEN_METHOD_MSG, this);
        }
        this.xScale = xScale;
        this.yScale = yScale;
        this.zScale = zScale;
    }

    @Override
    public void setOffset(double xOffset, double yOffset, double zOffset) {
        if (this.openCalled) {
            throw new ModelsIllegalargumentException(OPEN_METHOD_MSG, this);
        }
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
    }

    @Override
    public void setPointFormat(int pointFormat) {
        this.pointFormat = pointFormat;
        this.pointFormatHasBeenSet = true;
    }

    @Override
    public void setBounds(double xMin, double xMax, double yMin, double yMax, double zMin, double zMax) {
        if (this.openCalled) {
            throw new ModelsIllegalargumentException(OPEN_METHOD_MSG, this);
        }
        this.xMin = xMin;
        this.yMin = yMin;
        this.zMin = zMin;
        this.xMax = xMax;
        this.yMax = yMax;
        this.zMax = zMax;
    }

    @Override
    public void setBounds(ILasHeader header) {
        if (this.openCalled) {
            throw new ModelsIllegalargumentException(OPEN_METHOD_MSG, this.crs);
        }
        ReferencedEnvelope3D env = header.getDataEnvelope();
        this.xMin = env.getMinX();
        this.yMin = env.getMinY();
        this.zMin = env.getMinZ();
        this.xMax = env.getMaxX();
        this.yMax = env.getMaxY();
        this.zMax = env.getMaxZ();
        double[] xyzOffset = header.getXYZOffset();
        double[] xyzScale = header.getXYZScale();
        this.xOffset = xyzOffset[0];
        this.yOffset = xyzOffset[1];
        this.zOffset = xyzOffset[2];
        this.xScale = xyzScale[0];
        this.yScale = xyzScale[1];
        this.zScale = xyzScale[2];
        this.offsetToData = header.getOffset();
    }

    @Override
    public void open() throws Exception {
        this.openFile();
        this.writeHeader();
        this.openCalled = true;
    }

    private void writeHeader() throws IOException {
        int hLength = 0;
        byte[] signature = "LASF".getBytes("ISO-8859-1");
        this.mainBuffer.put(signature);
        hLength += 4;
        byte[] fileSourceId = new byte[2];
        this.mainBuffer.put(fileSourceId);
        hLength += 2;
        short globalEncoding = this.gpsTimeType == 1 ? (short)1 : 0;
        this.mainBuffer.putShort(globalEncoding);
        hLength += 2;
        byte[] guid1 = new byte[4];
        this.mainBuffer.put(guid1);
        hLength += 4;
        byte[] guid2 = new byte[2];
        this.mainBuffer.put(guid2);
        hLength += 2;
        byte[] guid3 = new byte[2];
        this.mainBuffer.put(guid3);
        hLength += 2;
        byte[] guid4 = new byte[8];
        this.mainBuffer.put(guid4);
        hLength += 8;
        this.mainBuffer.put((byte)1);
        this.mainBuffer.put((byte)2);
        hLength += 2;
        byte[] systemIdentifier = new byte[32];
        this.mainBuffer.put(systemIdentifier);
        hLength += 32;
        Object jgtVersion = "hortonmachine_" + HMVersion.CURRENT_VERSION.toString();
        if (((String)jgtVersion).length() > 32) {
            jgtVersion = ((String)jgtVersion).substring(0, 31);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append((String)jgtVersion);
            for (int i = ((String)jgtVersion).length(); i < 32; ++i) {
                sb.append(" ");
            }
            jgtVersion = sb.toString();
        }
        byte[] software = ((String)jgtVersion).getBytes();
        this.mainBuffer.put(software);
        hLength += 32;
        byte[] flightDateJulian = new byte[2];
        this.mainBuffer.put(flightDateJulian);
        hLength += 2;
        byte[] year = new byte[2];
        this.mainBuffer.put(year);
        hLength += 2;
        short headersize = 227;
        this.mainBuffer.putShort(headersize);
        hLength += 2;
        this.mainBuffer.putInt((int)this.offsetToData);
        hLength += 4;
        int numVarRecords = 0;
        this.mainBuffer.putInt(numVarRecords);
        hLength += 4;
        this.pointFormatPosition = hLength++;
        this.mainBuffer.put((byte)this.pointFormat);
        this.recordLengthPosition = hLength;
        this.mainBuffer.putShort(this.recordLength);
        this.recordsNumPosition = hLength += 2;
        this.mainBuffer.putInt(this.recordsNum);
        hLength += 4;
        this.mainBuffer.put(new byte[20]);
        hLength += 20;
        this.mainBuffer.putDouble(this.xScale);
        this.mainBuffer.putDouble(this.yScale);
        this.mainBuffer.putDouble(this.zScale);
        hLength += 24;
        this.mainBuffer.putDouble(this.xOffset);
        this.mainBuffer.putDouble(this.yOffset);
        this.mainBuffer.putDouble(this.zOffset);
        hLength += 24;
        this.mainBuffer.putDouble(this.xMax);
        this.mainBuffer.putDouble(this.xMin);
        this.mainBuffer.putDouble(this.yMax);
        this.mainBuffer.putDouble(this.yMin);
        this.mainBuffer.putDouble(this.zMax);
        this.mainBuffer.putDouble(this.zMin);
        this.writeMainBuffer(hLength += 48);
        this.fileChannel.position(this.offsetToData);
    }

    private void writeMainBuffer(int length) throws IOException {
        byte[] array = this.mainBuffer.array();
        this.fos.write(array, 0, length);
        this.mainBuffer.clear();
        this.mainBuffer.position(0);
    }

    @Override
    public synchronized void addPoint(LasRecord record) throws IOException {
        int length = 0;
        int x = (int)Math.round((record.x - this.xOffset) / this.xScale);
        int y = (int)Math.round((record.y - this.yOffset) / this.yScale);
        int z = !this.doWriteGroundElevation ? (int)Math.round((record.z - this.zOffset) / this.zScale) : (int)Math.round((record.groundElevation - this.zOffset) / this.zScale);
        this.mainBuffer.putInt(x);
        this.mainBuffer.putInt(y);
        this.mainBuffer.putInt(z);
        length += 12;
        this.mainBuffer.putShort(record.intensity);
        length += 2;
        short returnNumber = record.returnNumber;
        short numberOfReturns = record.numberOfReturns;
        if (returnNumber != this.previousReturnNumber || numberOfReturns != this.previousNumberOfReturns) {
            BitSet bitsetRN = ByteUtilities.bitsetFromByte((byte)returnNumber);
            BitSet bitsetNOR = ByteUtilities.bitsetFromByte((byte)numberOfReturns);
            BitSet b = new BitSet(7);
            b.set(0, bitsetRN.get(0));
            b.set(1, bitsetRN.get(1));
            b.set(2, bitsetRN.get(2));
            b.set(3, bitsetNOR.get(0));
            b.set(4, bitsetNOR.get(1));
            b.set(5, bitsetNOR.get(2));
            b.set(6, false);
            b.set(7, false);
            byte[] bb = ByteUtilities.bitSetToByteArray(b);
            this.mainBuffer.put(bb[0]);
            this.previousReturnBytes = bb;
            this.previousReturnNumber = returnNumber;
            this.previousNumberOfReturns = numberOfReturns;
        } else {
            this.mainBuffer.put(this.previousReturnBytes[0]);
        }
        ++length;
        byte c = record.classification;
        this.mainBuffer.put(c);
        ++length;
        this.mainBuffer.put((byte)1);
        ++length;
        this.mainBuffer.put((byte)0);
        ++length;
        this.mainBuffer.put(new byte[2]);
        length += 2;
        if (this.pointFormatHasBeenSet) {
            switch (this.pointFormat) {
                case 1: {
                    length += this.writeGpstime(record);
                    break;
                }
                case 2: {
                    length += this.writeRGB(record);
                    break;
                }
                case 3: {
                    length += this.writeGpstime(record);
                    length += this.writeRGB(record);
                }
            }
        } else if (record.gpsTime != -1.0) {
            this.pointFormat = 1;
            length += this.writeGpstime(record);
        }
        this.recordLength = (short)length;
        this.runningBytesCount += length;
        if (0xA00000 - this.runningBytesCount < this.recordLength) {
            this.writeMainBuffer(this.runningBytesCount);
            this.runningBytesCount = 0;
        }
        ++this.recordsNum;
    }

    private int writeGpstime(LasRecord record) throws IOException {
        this.mainBuffer.putDouble(record.gpsTime);
        return 8;
    }

    private int writeRGB(LasRecord record) throws IOException {
        this.mainBuffer.putShort(record.color[0]);
        this.mainBuffer.putShort(record.color[1]);
        this.mainBuffer.putShort(record.color[2]);
        return 6;
    }

    @Override
    public void close() throws Exception {
        if (this.runningBytesCount > 0) {
            this.writeMainBuffer(this.runningBytesCount);
            this.runningBytesCount = 0;
        }
        byte[] longDataArray = new byte[4];
        ByteBuffer longBb = ByteBuffer.wrap(longDataArray);
        longBb.order(ByteOrder.LITTLE_ENDIAN);
        byte[] shortDataArray = new byte[2];
        ByteBuffer shortBb = ByteBuffer.wrap(shortDataArray);
        shortBb.order(ByteOrder.LITTLE_ENDIAN);
        longBb.putInt(this.recordsNum);
        byte[] array = longBb.array();
        this.fileChannel.position(this.recordsNumPosition);
        this.fos.write(array);
        this.fileChannel.position(this.pointFormatPosition);
        this.fos.write(this.pointFormat);
        shortBb.putShort(this.recordLength);
        array = shortBb.array();
        this.fileChannel.position(this.recordLengthPosition);
        this.fos.write(array);
        this.closeFile();
        if (this.crs != null) {
            CrsUtilities.writeProjectionFile(this.prjFile.getAbsolutePath(), null, this.crs);
        }
    }

    private void openFile() throws Exception {
        this.fos = new FileOutputStream(this.outFile);
        this.fileChannel = this.fos.getChannel();
    }

    private void closeFile() throws Exception {
        if (this.fileChannel != null && this.fileChannel.isOpen()) {
            this.fileChannel.close();
        }
        if (this.fos != null) {
            this.fos.close();
        }
    }

    @Override
    public void setWriteGroundElevation(boolean doWriteGroundElevation) {
        this.doWriteGroundElevation = doWriteGroundElevation;
    }

    @Override
    public void setGpsTimeType(int timeType) {
        this.gpsTimeType = timeType;
    }
}

