/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.las.databases;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.hortonmachine.dbs.compat.ASpatialDb;
import org.hortonmachine.dbs.compat.IGeometryParser;
import org.hortonmachine.dbs.compat.IHMConnection;
import org.hortonmachine.dbs.compat.IHMPreparedStatement;
import org.hortonmachine.dbs.compat.IHMResultSet;
import org.hortonmachine.dbs.compat.IHMStatement;
import org.hortonmachine.gears.io.las.databases.LasCell;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;

public class LasCellsTable {
    public static final String TABLENAME = "lascells";
    public static final String COLUMN_ID = "id";
    public static final String COLUMN_GEOM = "the_geom";
    public static final String COLUMN_SOURCE_ID = "sources_id";
    public static final String COLUMN_POINTS_COUNT = "pointscount";
    public static final String COLUMN_AVG_ELEV = "avgelev";
    public static final String COLUMN_MIN_ELEV = "minelev";
    public static final String COLUMN_MAX_ELEV = "maxelev";
    public static final String COLUMN_POSITION_BLOB = "position_blob";
    public static final String COLUMN_AVG_INTENSITY = "avgintensity";
    public static final String COLUMN_MIN_INTENSITY = "minintensity";
    public static final String COLUMN_MAX_INTENSITY = "maxintensity";
    public static final String COLUMN_INTENS_CLASS_BLOB = "intens_class_blob";
    public static final String COLUMN_RETURNS_BLOB = "returns_blob";
    public static final String COLUMN_MIN_GPSTIME = "mingpstime";
    public static final String COLUMN_MAX_GPSTIME = "maxgpstime";
    public static final String COLUMN_GPSTIME_BLOB = "gpstime_blob";
    public static final String COLUMN_COLORS_BLOB = "colors_blob";

    public static void createTable(ASpatialDb db, int srid, boolean avoidIndex) throws Exception {
        if (!db.hasTable(TABLENAME)) {
            String[] creates = new String[]{"id INTEGER PRIMARY KEY AUTO_INCREMENT", "sources_id INTEGER", "pointscount INTEGER", "avgelev REAL", "minelev REAL", "maxelev REAL", "position_blob BLOB", "avgintensity INTEGER", "minintensity INTEGER", "maxintensity INTEGER", "intens_class_blob BLOB", "returns_blob BLOB", "mingpstime REAL", "maxgpstime REAL", "gpstime_blob BLOB", "colors_blob BLOB"};
            db.createSpatialTable(TABLENAME, srid, "the_geom POLYGON", creates, null, avoidIndex);
            db.createIndex(TABLENAME, COLUMN_SOURCE_ID, false);
        }
    }

    public static void insertLasCell(ASpatialDb db, int srid, LasCell cell) throws Exception {
        String sql = "INSERT INTO lascells (the_geom,sources_id,pointscount,avgelev,minelev,maxelev,position_blob,avgintensity,minintensity,maxintensity,intens_class_blob,returns_blob,mingpstime,maxgpstime,gpstime_blob,colors_blob) VALUES (ST_GeomFromText(?, " + srid + "),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        db.execOnConnection(connection -> {
            try (IHMPreparedStatement pStmt = connection.prepareStatement(sql);){
                int i = 1;
                pStmt.setString(i++, cell.polygon.toText());
                pStmt.setLong(i++, cell.sourceId);
                pStmt.setInt(i++, cell.pointsCount);
                pStmt.setDouble(i++, cell.avgElev);
                pStmt.setDouble(i++, cell.minElev);
                pStmt.setDouble(i++, cell.maxElev);
                pStmt.setBytes(i++, cell.xyzs);
                pStmt.setShort(i++, cell.avgIntensity);
                pStmt.setShort(i++, cell.minIntensity);
                pStmt.setShort(i++, cell.maxIntensity);
                pStmt.setBytes(i++, cell.intensitiesClassifications);
                pStmt.setBytes(i++, cell.returns);
                pStmt.setDouble(i++, cell.minGpsTime);
                pStmt.setDouble(i++, cell.maxGpsTime);
                pStmt.setBytes(i++, cell.gpsTimes);
                pStmt.setBytes(i++, cell.colors);
                pStmt.executeUpdate();
            }
            return null;
        });
    }

    public static void insertLasCells(ASpatialDb db, int srid, List<LasCell> cells) throws Exception {
        String sql = "INSERT INTO lascells (the_geom,sources_id,pointscount,avgelev,minelev,maxelev,position_blob,avgintensity,minintensity,maxintensity,intens_class_blob,returns_blob,mingpstime,maxgpstime,gpstime_blob,colors_blob) VALUES (ST_GeomFromText(?, " + srid + "),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        db.execOnConnection(conn -> {
            boolean autoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (IHMPreparedStatement pStmt = conn.prepareStatement(sql);){
                for (LasCell cell : cells) {
                    int i = 1;
                    pStmt.setString(i++, cell.polygon.toText());
                    pStmt.setLong(i++, cell.sourceId);
                    pStmt.setInt(i++, cell.pointsCount);
                    pStmt.setDouble(i++, cell.avgElev);
                    pStmt.setDouble(i++, cell.minElev);
                    pStmt.setDouble(i++, cell.maxElev);
                    pStmt.setBytes(i++, cell.xyzs);
                    pStmt.setShort(i++, cell.avgIntensity);
                    pStmt.setShort(i++, cell.minIntensity);
                    pStmt.setShort(i++, cell.maxIntensity);
                    pStmt.setBytes(i++, cell.intensitiesClassifications);
                    pStmt.setBytes(i++, cell.returns);
                    pStmt.setDouble(i++, cell.minGpsTime);
                    pStmt.setDouble(i++, cell.maxGpsTime);
                    pStmt.setBytes(i++, cell.gpsTimes);
                    pStmt.setBytes(i++, cell.colors);
                    pStmt.addBatch();
                }
                pStmt.executeBatch();
                conn.commit();
                conn.setAutoCommit(autoCommit);
            }
            return null;
        });
    }

    public static List<LasCell> getLasCells(ASpatialDb db, Envelope envelope, Geometry exactGeometry, boolean doPosition, boolean doIntensity, boolean doReturns, boolean doTime, boolean doColor, int limitTo) throws Exception {
        ArrayList lasCells = new ArrayList();
        Object sql = "SELECT the_geom,id,sources_id,pointscount";
        if (doPosition) {
            sql = (String)sql + ",avgelev,minelev,maxelev,position_blob";
        }
        if (doIntensity) {
            sql = (String)sql + ",avgintensity,minintensity,maxintensity,intens_class_blob";
        }
        if (doReturns) {
            sql = (String)sql + ",returns_blob";
        }
        if (doTime) {
            sql = (String)sql + ",mingpstime,maxgpstime,gpstime_blob";
        }
        if (doColor) {
            sql = (String)sql + ",colors_blob";
        }
        sql = (String)sql + " FROM lascells";
        if (exactGeometry != null) {
            sql = (String)sql + " WHERE " + db.getSpatialindexGeometryWherePiece(TABLENAME, null, exactGeometry);
        } else if (envelope != null) {
            double x1 = envelope.getMinX();
            double y1 = envelope.getMinY();
            double x2 = envelope.getMaxX();
            double y2 = envelope.getMaxY();
            sql = (String)sql + " WHERE " + db.getSpatialindexBBoxWherePiece(TABLENAME, null, x1, y1, x2, y2);
        }
        if (limitTo > 0) {
            sql = (String)sql + " LIMIT " + limitTo;
        }
        Object _sql = sql;
        IGeometryParser gp = db.getType().getGeometryParser();
        return (List)db.execOnConnection(arg_0 -> LasCellsTable.lambda$getLasCells$2((String)_sql, db, gp, doPosition, doIntensity, doReturns, doTime, doColor, lasCells, arg_0));
    }

    public static List<LasCell> getLasCells(ASpatialDb db, Geometry geometry, boolean doPosition, boolean doIntensity, boolean doReturns, boolean doTime, boolean doColor) throws Exception {
        ArrayList lasCells = new ArrayList();
        Object sql = "SELECT the_geom,id,sources_id,pointscount";
        if (doPosition) {
            sql = (String)sql + ",avgelev,minelev,maxelev,position_blob";
        }
        if (doIntensity) {
            sql = (String)sql + ",avgintensity,minintensity,maxintensity,intens_class_blob";
        }
        if (doReturns) {
            sql = (String)sql + ",returns_blob";
        }
        if (doTime) {
            sql = (String)sql + ",mingpstime,maxgpstime,gpstime_blob";
        }
        if (doColor) {
            sql = (String)sql + ",colors_blob";
        }
        sql = (String)sql + " FROM lascells";
        if (geometry != null) {
            sql = (String)sql + " WHERE " + db.getSpatialindexGeometryWherePiece(TABLENAME, null, geometry);
        }
        Object _sql = sql;
        IGeometryParser gp = db.getType().getGeometryParser();
        return (List)db.execOnConnection(arg_0 -> LasCellsTable.lambda$getLasCells$3((String)_sql, db, gp, doPosition, doIntensity, doReturns, doTime, doColor, lasCells, arg_0));
    }

    public static List<LasCell> getLasCellsBySource(ASpatialDb db, long sourceId, boolean doPosition, boolean doIntensity, boolean doReturns, boolean doTime, boolean doColor) throws Exception {
        ArrayList lasCells = new ArrayList();
        Object sql = "SELECT the_geom,id,sources_id,pointscount";
        if (doPosition) {
            sql = (String)sql + ",avgelev,minelev,maxelev,position_blob";
        }
        if (doIntensity) {
            sql = (String)sql + ",avgintensity,minintensity,maxintensity,intens_class_blob";
        }
        if (doReturns) {
            sql = (String)sql + ",returns_blob";
        }
        if (doTime) {
            sql = (String)sql + ",mingpstime,maxgpstime,gpstime_blob";
        }
        if (doColor) {
            sql = (String)sql + ",colors_blob";
        }
        sql = (String)sql + " FROM lascells";
        Object _sql = sql = (String)sql + " WHERE sources_id=" + sourceId;
        IGeometryParser gp = db.getType().getGeometryParser();
        return (List)db.execOnConnection(arg_0 -> LasCellsTable.lambda$getLasCellsBySource$4((String)_sql, db, gp, doPosition, doIntensity, doReturns, doTime, doColor, lasCells, arg_0));
    }

    private static LasCell resultSetToCell(ASpatialDb db, IGeometryParser geometryParser, boolean doPosition, boolean doIntensity, boolean doReturns, boolean doTime, boolean doColor, IHMResultSet rs) throws Exception, ParseException {
        Geometry tmpGeometry;
        LasCell lasCell = new LasCell();
        int i = 1;
        if ((tmpGeometry = geometryParser.fromResultSet(rs, i++)) instanceof Polygon) {
            Polygon polygon;
            lasCell.polygon = polygon = (Polygon)tmpGeometry;
            lasCell.id = rs.getLong(i++);
            lasCell.sourceId = rs.getLong(i++);
            lasCell.pointsCount = rs.getInt(i++);
            if (doPosition) {
                lasCell.avgElev = rs.getDouble(i++);
                lasCell.minElev = rs.getDouble(i++);
                lasCell.maxElev = rs.getDouble(i++);
                lasCell.xyzs = rs.getBytes(i++);
            }
            if (doIntensity) {
                lasCell.avgIntensity = rs.getShort(i++);
                lasCell.minIntensity = rs.getShort(i++);
                lasCell.maxIntensity = rs.getShort(i++);
                lasCell.intensitiesClassifications = rs.getBytes(i++);
            }
            if (doReturns) {
                lasCell.returns = rs.getBytes(i++);
            }
            if (doTime) {
                lasCell.minGpsTime = rs.getDouble(i++);
                lasCell.maxGpsTime = rs.getDouble(i++);
                lasCell.gpsTimes = rs.getBytes(i++);
            }
            if (doColor) {
                lasCell.colors = rs.getBytes(i++);
            }
            return lasCell;
        }
        return null;
    }

    public static double[][] getCellPositions(LasCell cell) {
        int points = cell.pointsCount;
        if (points == 0) {
            return null;
        }
        double[][] xyzPoints = new double[points][3];
        ByteBuffer buffer = ByteBuffer.wrap(cell.xyzs);
        for (int i = 0; i < points; ++i) {
            xyzPoints[i][0] = buffer.getDouble();
            xyzPoints[i][1] = buffer.getDouble();
            xyzPoints[i][2] = buffer.getDouble();
        }
        return xyzPoints;
    }

    public static short[][] getCellIntensityClass(LasCell cell) {
        int points = cell.pointsCount;
        if (points == 0) {
            return null;
        }
        short[][] intensClassPoints = new short[points][2];
        ByteBuffer buffer = ByteBuffer.wrap(cell.intensitiesClassifications);
        for (int i = 0; i < points; ++i) {
            intensClassPoints[i][0] = buffer.getShort();
            intensClassPoints[i][1] = buffer.getShort();
        }
        return intensClassPoints;
    }

    public static short[][] getCellColors(LasCell cell) {
        int points = cell.pointsCount;
        if (points == 0) {
            return null;
        }
        short[][] colorPoints = new short[points][3];
        ByteBuffer buffer = ByteBuffer.wrap(cell.colors);
        for (int i = 0; i < points; ++i) {
            colorPoints[i][0] = buffer.getShort();
            colorPoints[i][1] = buffer.getShort();
            colorPoints[i][2] = buffer.getShort();
        }
        return colorPoints;
    }

    private static /* synthetic */ List lambda$getLasCellsBySource$4(String _sql, ASpatialDb db, IGeometryParser gp, boolean doPosition, boolean doIntensity, boolean doReturns, boolean doTime, boolean doColor, List lasCells, IHMConnection conn) throws Exception {
        try (IHMStatement stmt = conn.createStatement();){
            List list;
            block13: {
                IHMResultSet rs = stmt.executeQuery(_sql);
                try {
                    while (rs.next()) {
                        LasCell lasCell = LasCellsTable.resultSetToCell(db, gp, doPosition, doIntensity, doReturns, doTime, doColor, rs);
                        lasCells.add(lasCell);
                    }
                    list = lasCells;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list;
        }
    }

    private static /* synthetic */ List lambda$getLasCells$3(String _sql, ASpatialDb db, IGeometryParser gp, boolean doPosition, boolean doIntensity, boolean doReturns, boolean doTime, boolean doColor, List lasCells, IHMConnection conn) throws Exception {
        try (IHMStatement stmt = conn.createStatement();){
            List list;
            block13: {
                IHMResultSet rs = stmt.executeQuery(_sql);
                try {
                    while (rs.next()) {
                        LasCell lasCell = LasCellsTable.resultSetToCell(db, gp, doPosition, doIntensity, doReturns, doTime, doColor, rs);
                        lasCells.add(lasCell);
                    }
                    list = lasCells;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list;
        }
    }

    private static /* synthetic */ List lambda$getLasCells$2(String _sql, ASpatialDb db, IGeometryParser gp, boolean doPosition, boolean doIntensity, boolean doReturns, boolean doTime, boolean doColor, List lasCells, IHMConnection conn) throws Exception {
        try (IHMStatement stmt = conn.createStatement();){
            List list;
            block13: {
                IHMResultSet rs = stmt.executeQuery(_sql);
                try {
                    while (rs.next()) {
                        LasCell lasCell = LasCellsTable.resultSetToCell(db, gp, doPosition, doIntensity, doReturns, doTime, doColor, rs);
                        lasCells.add(lasCell);
                    }
                    list = lasCells;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list;
        }
    }
}

