/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.las.databases;

import java.util.ArrayList;
import java.util.List;
import org.hortonmachine.dbs.compat.ASpatialDb;
import org.hortonmachine.dbs.compat.IGeometryParser;
import org.hortonmachine.dbs.compat.IHMConnection;
import org.hortonmachine.dbs.compat.IHMPreparedStatement;
import org.hortonmachine.dbs.compat.IHMResultSet;
import org.hortonmachine.dbs.compat.IHMStatement;
import org.hortonmachine.gears.io.las.databases.LasLevel;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

public class LasLevelsTable {
    public static final String TABLENAME = "laslevels";
    public static final String COLUMN_ID = "id";
    public static final String COLUMN_GEOM = "the_geom";
    public static final String COLUMN_SOURCE_ID = "sources_id";
    public static final String COLUMN_AVG_ELEV = "avgelev";
    public static final String COLUMN_MIN_ELEV = "minelev";
    public static final String COLUMN_MAX_ELEV = "maxelev";
    public static final String COLUMN_AVG_INTENSITY = "avgintensity";
    public static final String COLUMN_MIN_INTENSITY = "minintensity";
    public static final String COLUMN_MAX_INTENSITY = "maxintensity";

    public static boolean hasLevel(ASpatialDb db, int levelNum) throws Exception {
        String tablename = TABLENAME + levelNum;
        return db.hasTable(tablename);
    }

    public static void createTable(ASpatialDb db, int srid, int levelNum, boolean avoidIndex) throws Exception {
        String tablename = TABLENAME + levelNum;
        if (!db.hasTable(tablename)) {
            String[] creates = new String[]{"id INTEGER PRIMARY KEY AUTO_INCREMENT", "sources_id INTEGER", "avgelev REAL", "minelev REAL", "maxelev REAL", "avgintensity INTEGER", "minintensity INTEGER", "maxintensity INTEGER"};
            db.createSpatialTable(tablename, srid, "the_geom POLYGON", creates, null, avoidIndex);
            db.createIndex(tablename, COLUMN_SOURCE_ID, false);
        }
    }

    public static void insertLasLevel(ASpatialDb db, int srid, LasLevel level) throws Exception {
        String sql = "INSERT INTO laslevels" + level.level + " (the_geom,sources_id,avgelev,minelev,maxelev,avgintensity,minintensity,maxintensity) VALUES (ST_GeomFromText(?, " + srid + "),?,?,?,?,?,?,?)";
        db.execOnConnection(conn -> {
            try (IHMPreparedStatement pStmt = conn.prepareStatement(sql);){
                int i = 1;
                pStmt.setString(i++, level.polygon.toText());
                pStmt.setLong(i++, level.sourceId);
                pStmt.setDouble(i++, level.avgElev);
                pStmt.setDouble(i++, level.minElev);
                pStmt.setDouble(i++, level.maxElev);
                pStmt.setShort(i++, level.avgIntensity);
                pStmt.setShort(i++, level.minIntensity);
                pStmt.setShort(i++, level.maxIntensity);
                pStmt.executeUpdate();
            }
            return null;
        });
    }

    public static void insertLasLevels(ASpatialDb db, int srid, List<LasLevel> levels) throws Exception {
        if (levels.size() == 0) {
            return;
        }
        String sql = "INSERT INTO laslevels" + levels.get((int)0).level + " (the_geom,sources_id,avgelev,minelev,maxelev,avgintensity,minintensity,maxintensity) VALUES (ST_GeomFromText(?, " + srid + "),?,?,?,?,?,?,?)";
        db.execOnConnection(conn -> {
            boolean autoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (IHMPreparedStatement pStmt = conn.prepareStatement(sql);){
                for (LasLevel level : levels) {
                    int i = 1;
                    pStmt.setString(i++, level.polygon.toText());
                    pStmt.setLong(i++, level.sourceId);
                    pStmt.setDouble(i++, level.avgElev);
                    pStmt.setDouble(i++, level.minElev);
                    pStmt.setDouble(i++, level.maxElev);
                    pStmt.setShort(i++, level.avgIntensity);
                    pStmt.setShort(i++, level.minIntensity);
                    pStmt.setShort(i++, level.maxIntensity);
                    pStmt.addBatch();
                }
                pStmt.executeBatch();
                conn.commit();
                conn.setAutoCommit(autoCommit);
            }
            return null;
        });
    }

    public static List<LasLevel> getLasLevels(ASpatialDb db, int levelNum, Envelope envelope) throws Exception {
        String tableName = TABLENAME + levelNum;
        ArrayList lasLevels = new ArrayList();
        Object sql = "SELECT the_geom,id,sources_id,avgelev,minelev,maxelev,avgintensity,minintensity,maxintensity";
        sql = (String)sql + " FROM " + tableName;
        if (envelope != null) {
            double x1 = envelope.getMinX();
            double y1 = envelope.getMinY();
            double x2 = envelope.getMaxX();
            double y2 = envelope.getMaxY();
            sql = (String)sql + " WHERE " + db.getSpatialindexBBoxWherePiece(tableName, null, x1, y1, x2, y2);
        }
        Object _sql = sql;
        IGeometryParser gp = db.getType().getGeometryParser();
        return (List)db.execOnConnection(arg_0 -> LasLevelsTable.lambda$getLasLevels$2((String)_sql, levelNum, gp, lasLevels, arg_0));
    }

    public static List<LasLevel> getLasLevels(ASpatialDb db, int levelNum, Geometry geometry) throws Exception {
        String tableName = TABLENAME + levelNum;
        ArrayList lasLevels = new ArrayList();
        Object sql = "SELECT the_geom,id,sources_id,avgelev,minelev,maxelev,avgintensity,minintensity,maxintensity";
        sql = (String)sql + " FROM " + tableName;
        if (geometry != null) {
            sql = (String)sql + " WHERE " + db.getSpatialindexGeometryWherePiece(tableName, null, geometry);
        }
        Object _sql = sql;
        IGeometryParser gp = db.getType().getGeometryParser();
        return (List)db.execOnConnection(arg_0 -> LasLevelsTable.lambda$getLasLevels$3((String)_sql, levelNum, gp, lasLevels, arg_0));
    }

    private static /* synthetic */ List lambda$getLasLevels$3(String _sql, int levelNum, IGeometryParser gp, List lasLevels, IHMConnection conn) throws Exception {
        try (IHMStatement stmt = conn.createStatement();){
            List list;
            block13: {
                IHMResultSet rs = stmt.executeQuery(_sql);
                try {
                    while (rs.next()) {
                        Polygon polygon;
                        Geometry tmpGeometry;
                        LasLevel lasLevel = new LasLevel();
                        lasLevel.level = levelNum;
                        int i = 1;
                        if (!((tmpGeometry = gp.fromResultSet(rs, i++)) instanceof Polygon)) continue;
                        lasLevel.polygon = polygon = (Polygon)tmpGeometry;
                        lasLevel.id = rs.getLong(i++);
                        lasLevel.sourceId = rs.getLong(i++);
                        lasLevel.avgElev = rs.getDouble(i++);
                        lasLevel.minElev = rs.getDouble(i++);
                        lasLevel.maxElev = rs.getDouble(i++);
                        lasLevel.avgIntensity = rs.getShort(i++);
                        lasLevel.minIntensity = rs.getShort(i++);
                        lasLevel.maxIntensity = rs.getShort(i++);
                        lasLevels.add(lasLevel);
                    }
                    list = lasLevels;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list;
        }
    }

    private static /* synthetic */ List lambda$getLasLevels$2(String _sql, int levelNum, IGeometryParser gp, List lasLevels, IHMConnection conn) throws Exception {
        try (IHMStatement stmt = conn.createStatement();){
            List list;
            block13: {
                IHMResultSet rs = stmt.executeQuery(_sql);
                try {
                    while (rs.next()) {
                        Polygon polygon;
                        Geometry geometry;
                        LasLevel lasLevel = new LasLevel();
                        lasLevel.level = levelNum;
                        int i = 1;
                        if (!((geometry = gp.fromResultSet(rs, i++)) instanceof Polygon)) continue;
                        lasLevel.polygon = polygon = (Polygon)geometry;
                        lasLevel.id = rs.getLong(i++);
                        lasLevel.sourceId = rs.getLong(i++);
                        lasLevel.avgElev = rs.getDouble(i++);
                        lasLevel.minElev = rs.getDouble(i++);
                        lasLevel.maxElev = rs.getDouble(i++);
                        lasLevel.avgIntensity = rs.getShort(i++);
                        lasLevel.minIntensity = rs.getShort(i++);
                        lasLevel.maxIntensity = rs.getShort(i++);
                        lasLevels.add(lasLevel);
                    }
                    list = lasLevels;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list;
        }
    }
}

