/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.las.databases;

import java.util.ArrayList;
import java.util.List;
import org.hortonmachine.dbs.compat.ASpatialDb;
import org.hortonmachine.dbs.compat.IGeometryParser;
import org.hortonmachine.dbs.compat.IHMPreparedStatement;
import org.hortonmachine.dbs.compat.IHMResultSet;
import org.hortonmachine.dbs.compat.IHMStatement;
import org.hortonmachine.gears.io.las.databases.LasSource;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

public class LasSourcesTable {
    public static final String TABLENAME = "lassources";
    public static final String COLUMN_ID = "id";
    public static final String COLUMN_GEOM = "the_geom";
    public static final String COLUMN_NAME = "name";
    public static final String COLUMN_RESOLUTION = "resolution";
    public static final String COLUMN_FACTOR = "factor";
    public static final String COLUMN_LEVELS = "levels";
    public static final String COLUMN_MINZ = "minelev";
    public static final String COLUMN_MAXZ = "maxelev";
    public static final String COLUMN_MININTENSITY = "minintens";
    public static final String COLUMN_MAXINTENSITY = "maxintens";

    public static void createTable(ASpatialDb db, int srid, boolean avoidIndex) throws Exception {
        if (!db.hasTable(TABLENAME)) {
            String[] creates = new String[]{"id INTEGER PRIMARY KEY AUTO_INCREMENT", "name TEXT", "resolution REAL", "factor REAL", "levels INTEGER", "minelev REAL", "maxelev REAL", "minintens REAL", "maxintens REAL"};
            db.createSpatialTable(TABLENAME, srid, "the_geom POLYGON", creates, null, avoidIndex);
        }
    }

    public static long insertLasSource(ASpatialDb db, int srid, int levels, double resolution, double factor, Polygon polygon, String name, double minElev, double maxElev, double minIntens, double maxIntens) throws Exception {
        String sql = "INSERT INTO lassources (the_geom,name,resolution,factor,levels,minelev,maxelev,minintens,maxintens) VALUES (ST_GeomFromText(?, " + srid + "),?,?,?,?,?,?,?,?)";
        return (Long)db.execOnConnection(connection -> {
            try (IHMPreparedStatement pStmt = connection.prepareStatement(sql, 1);){
                pStmt.setString(1, polygon.toText());
                pStmt.setString(2, name);
                pStmt.setDouble(3, resolution);
                pStmt.setDouble(4, factor);
                pStmt.setInt(5, levels);
                pStmt.setDouble(6, minElev);
                pStmt.setDouble(7, maxElev);
                pStmt.setDouble(8, minIntens);
                pStmt.setDouble(9, maxIntens);
                pStmt.executeUpdate();
                IHMResultSet rs = pStmt.getGeneratedKeys();
                rs.next();
                long generatedId = rs.getLong(1);
                Long l = generatedId;
                return l;
            }
        });
    }

    public static void updateMinMaxIntensity(ASpatialDb db, long sourceId, double minIntens, double maxIntens) throws Exception {
        String sql = "UPDATE lassources SET minintens=" + minIntens + ", maxintens=" + maxIntens + " WHERE id=" + sourceId;
        db.executeInsertUpdateDeleteSql(sql);
    }

    public static List<LasSource> getLasSources(ASpatialDb db) throws Exception {
        ArrayList sources = new ArrayList();
        String sql = "SELECT the_geom,id,name,resolution,factor,levels,minelev,maxelev,minintens,maxintens FROM lassources";
        return (List)db.execOnConnection(connection -> {
            IGeometryParser gp = db.getType().getGeometryParser();
            try (IHMStatement stmt = connection.createStatement();){
                List list;
                block13: {
                    IHMResultSet rs = stmt.executeQuery(sql);
                    try {
                        while (rs.next()) {
                            Polygon polygon;
                            Geometry geometry;
                            LasSource lasSource = new LasSource();
                            int i = 1;
                            if (!((geometry = gp.fromResultSet(rs, i++)) instanceof Polygon)) continue;
                            lasSource.polygon = polygon = (Polygon)geometry;
                            lasSource.id = rs.getLong(i++);
                            lasSource.name = rs.getString(i++);
                            lasSource.resolution = rs.getDouble(i++);
                            lasSource.levelFactor = rs.getDouble(i++);
                            lasSource.levels = rs.getInt(i++);
                            lasSource.minElev = rs.getDouble(i++);
                            lasSource.maxElev = rs.getDouble(i++);
                            lasSource.minIntens = rs.getDouble(i++);
                            lasSource.maxIntens = rs.getDouble(i++);
                            sources.add(lasSource);
                        }
                        list = sources;
                        if (rs == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return list;
            }
        });
    }

    public static boolean isLasDatabase(ASpatialDb db) throws Exception {
        return db.hasTable(TABLENAME) && db.hasTable("lascells");
    }
}

