/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.las.index.strtree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.hortonmachine.gears.io.las.index.strtree.BoundablePair;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.strtree.AbstractNode;
import org.locationtech.jts.index.strtree.AbstractSTRtree;
import org.locationtech.jts.index.strtree.Boundable;
import org.locationtech.jts.index.strtree.ItemBoundable;
import org.locationtech.jts.index.strtree.ItemDistance;
import org.locationtech.jts.util.Assert;
import org.locationtech.jts.util.PriorityQueue;

public class STRtreeJGT
extends AbstractSTRtree
implements SpatialIndex,
Serializable {
    private static final long serialVersionUID = 1621079558450867936L;
    private static Comparator xComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return STRtreeJGT.compareDoubles((double)STRtreeJGT.centreX((Envelope)((Boundable)o1).getBounds()), (double)STRtreeJGT.centreX((Envelope)((Boundable)o2).getBounds()));
        }
    };
    private static Comparator yComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return STRtreeJGT.compareDoubles((double)STRtreeJGT.centreY((Envelope)((Boundable)o1).getBounds()), (double)STRtreeJGT.centreY((Envelope)((Boundable)o2).getBounds()));
        }
    };
    private static AbstractSTRtree.IntersectsOp intersectsOp = new AbstractSTRtree.IntersectsOp(){

        public boolean intersects(Object aBounds, Object bBounds) {
            return ((Envelope)aBounds).intersects((Envelope)bBounds);
        }
    };
    private static final int DEFAULT_NODE_CAPACITY = 10;

    private static double centreX(Envelope e) {
        return STRtreeJGT.avg(e.getMinX(), e.getMaxX());
    }

    private static double centreY(Envelope e) {
        return STRtreeJGT.avg(e.getMinY(), e.getMaxY());
    }

    private static double avg(double a, double b) {
        return (a + b) / 2.0;
    }

    protected List createParentBoundables(List childBoundables, int newLevel) {
        Assert.isTrue((!childBoundables.isEmpty() ? 1 : 0) != 0);
        int minLeafCount = (int)Math.ceil((double)childBoundables.size() / (double)this.getNodeCapacity());
        ArrayList sortedChildBoundables = new ArrayList(childBoundables);
        Collections.sort(sortedChildBoundables, xComparator);
        List[] verticalSlices = this.verticalSlices(sortedChildBoundables, (int)Math.ceil(Math.sqrt(minLeafCount)));
        return this.createParentBoundablesFromVerticalSlices(verticalSlices, newLevel);
    }

    private List createParentBoundablesFromVerticalSlices(List[] verticalSlices, int newLevel) {
        Assert.isTrue((verticalSlices.length > 0 ? 1 : 0) != 0);
        ArrayList parentBoundables = new ArrayList();
        for (int i = 0; i < verticalSlices.length; ++i) {
            parentBoundables.addAll(this.createParentBoundablesFromVerticalSlice(verticalSlices[i], newLevel));
        }
        return parentBoundables;
    }

    protected List createParentBoundablesFromVerticalSlice(List childBoundables, int newLevel) {
        return super.createParentBoundables(childBoundables, newLevel);
    }

    protected List[] verticalSlices(List childBoundables, int sliceCount) {
        int sliceCapacity = (int)Math.ceil((double)childBoundables.size() / (double)sliceCount);
        List[] slices = new List[sliceCount];
        Iterator i = childBoundables.iterator();
        for (int j = 0; j < sliceCount; ++j) {
            slices[j] = new ArrayList();
            for (int boundablesAddedToSlice = 0; i.hasNext() && boundablesAddedToSlice < sliceCapacity; ++boundablesAddedToSlice) {
                Boundable childBoundable = (Boundable)i.next();
                slices[j].add(childBoundable);
            }
        }
        return slices;
    }

    public STRtreeJGT() {
        this(10);
    }

    public STRtreeJGT(int nodeCapacity) {
        super(nodeCapacity);
    }

    protected AbstractNode createNode(int level) {
        return new STRtreeNode(level);
    }

    protected AbstractSTRtree.IntersectsOp getIntersectsOp() {
        return intersectsOp;
    }

    public void insert(Envelope itemEnv, Object item) {
        if (itemEnv.isNull()) {
            return;
        }
        super.insert((Object)itemEnv, item);
    }

    public List query(Envelope searchEnv) {
        return super.query((Object)searchEnv);
    }

    public void query(Envelope searchEnv, ItemVisitor visitor) {
        super.query((Object)searchEnv, visitor);
    }

    public boolean remove(Envelope itemEnv, Object item) {
        return super.remove((Object)itemEnv, item);
    }

    public List queryBoundables(Object searchBounds) {
        this.build();
        ArrayList matches = new ArrayList();
        if (this.isEmpty()) {
            return matches;
        }
        if (this.getIntersectsOp().intersects(this.root.getBounds(), searchBounds)) {
            this.queryBoundables(searchBounds, this.root, matches);
        }
        return matches;
    }

    private void queryBoundables(Object searchBounds, AbstractNode node, List matches) {
        List childBoundables = node.getChildBoundables();
        for (int i = 0; i < childBoundables.size(); ++i) {
            Boundable childBoundable = (Boundable)childBoundables.get(i);
            if (!this.getIntersectsOp().intersects(childBoundable.getBounds(), searchBounds)) continue;
            if (childBoundable instanceof AbstractNode) {
                this.queryBoundables(searchBounds, (AbstractNode)childBoundable, matches);
                continue;
            }
            if (childBoundable instanceof ItemBoundable) {
                matches.add(childBoundable);
                continue;
            }
            Assert.shouldNeverReachHere();
        }
    }

    public int size() {
        return super.size();
    }

    public int depth() {
        return super.depth();
    }

    protected Comparator getComparator() {
        return yComparator;
    }

    public Object[] nearestNeighbour(ItemDistance itemDist) {
        BoundablePair bp = new BoundablePair((Boundable)this.getRoot(), (Boundable)this.getRoot(), itemDist);
        return this.nearestNeighbour(bp);
    }

    public Object nearestNeighbour(Envelope env, Object item, ItemDistance itemDist) {
        ItemBoundable bnd = new ItemBoundable((Object)env, item);
        BoundablePair bp = new BoundablePair((Boundable)this.getRoot(), (Boundable)bnd, itemDist);
        return this.nearestNeighbour(bp)[0];
    }

    public Object[] nearestNeighbour(STRtreeJGT tree, ItemDistance itemDist) {
        BoundablePair bp = new BoundablePair((Boundable)this.getRoot(), (Boundable)tree.getRoot(), itemDist);
        return this.nearestNeighbour(bp);
    }

    private Object[] nearestNeighbour(BoundablePair initBndPair) {
        return this.nearestNeighbour(initBndPair, Double.POSITIVE_INFINITY);
    }

    private Object[] nearestNeighbour(BoundablePair initBndPair, double maxDistance) {
        BoundablePair bndPair;
        double currentDistance;
        double distanceLowerBound = maxDistance;
        BoundablePair minPair = null;
        PriorityQueue priQ = new PriorityQueue();
        priQ.add((Comparable)initBndPair);
        while (!priQ.isEmpty() && distanceLowerBound > 0.0 && !((currentDistance = (bndPair = (BoundablePair)priQ.poll()).getDistance()) >= distanceLowerBound)) {
            if (bndPair.isLeaves()) {
                distanceLowerBound = currentDistance;
                minPair = bndPair;
                continue;
            }
            bndPair.expandToQueue(priQ, distanceLowerBound);
        }
        return new Object[]{((ItemBoundable)minPair.getBoundable(0)).getItem(), ((ItemBoundable)minPair.getBoundable(1)).getItem()};
    }

    private static final class STRtreeNode
    extends AbstractNode {
        private STRtreeNode(int level) {
            super(level);
        }

        protected Object computeBounds() {
            Envelope bounds = null;
            for (Boundable childBoundable : this.getChildBoundables()) {
                if (bounds == null) {
                    bounds = new Envelope((Envelope)childBoundable.getBounds());
                    continue;
                }
                bounds.expandToInclude((Envelope)childBoundable.getBounds());
            }
            return bounds;
        }
    }
}

