/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.las.utils;

public enum EGpsWeekDays {
    SUNDAY(0, 0L, 86400L),
    MONDAY(1, 86400L, 172800L),
    TUESDAY(2, 172800L, 259200L),
    WEDNESDAY(3, 259200L, 345600L),
    THURSDAY(4, 345600L, 432000L),
    FRIDAY(5, 432000L, 518400L),
    SATURDAY(6, 518400L, 604800L);

    private long fromSeconds;
    private long toSeconds;
    private int index;

    private EGpsWeekDays(int index, long fromSeconds, long toSeconds) {
        this.index = index;
        this.fromSeconds = fromSeconds;
        this.toSeconds = toSeconds;
    }

    public int getIndex() {
        return this.index;
    }

    public long getFromSeconds() {
        return this.fromSeconds;
    }

    public long getToSeconds() {
        return this.toSeconds;
    }

    public static EGpsWeekDays getDay4Seconds(double gpsSecondsofWeek) {
        int seconds = (int)gpsSecondsofWeek;
        if ((long)seconds > EGpsWeekDays.SATURDAY.toSeconds) {
            throw new IllegalArgumentException("GPS seconds of week has to be smaller than: " + EGpsWeekDays.SATURDAY.toSeconds + ". Got: " + gpsSecondsofWeek);
        }
        if ((long)seconds < EGpsWeekDays.SUNDAY.fromSeconds) {
            throw new IllegalArgumentException("GPS seconds of week has to be larger than: " + EGpsWeekDays.SUNDAY.fromSeconds + ". Got: " + gpsSecondsofWeek);
        }
        if ((long)seconds > EGpsWeekDays.SATURDAY.fromSeconds) {
            return SATURDAY;
        }
        if ((long)seconds > EGpsWeekDays.FRIDAY.fromSeconds) {
            return FRIDAY;
        }
        if ((long)seconds > EGpsWeekDays.THURSDAY.fromSeconds) {
            return THURSDAY;
        }
        if ((long)seconds > EGpsWeekDays.WEDNESDAY.fromSeconds) {
            return WEDNESDAY;
        }
        if ((long)seconds > EGpsWeekDays.TUESDAY.fromSeconds) {
            return TUESDAY;
        }
        if ((long)seconds > EGpsWeekDays.MONDAY.fromSeconds) {
            return MONDAY;
        }
        return SUNDAY;
    }
}

