/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.las.utils;

import org.hortonmachine.gears.io.las.utils.EGpsWeekDays;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class GpsTimeConverter {
    public static String ISO8601_pattern = "yyyy-MM-dd'T'HH:mm:ss";
    public static DateTimeFormatter ISO8601Formatter = DateTimeFormat.forPattern((String)ISO8601_pattern).withZone(DateTimeZone.UTC);

    private static double[] getleaps() {
        return new double[]{4.68288E7, 7.8364801E7, 1.09900802E8, 1.73059203E8, 2.52028804E8, 3.15187205E8, 3.46723206E8, 3.93984007E8, 4.25520008E8, 4.57056009E8, 5.0448961E8, 5.51750411E8, 5.99184012E8, 8.20108813E8, 9.14803214E8, 1.025136015E9, 1.119744016E9, 1.3411188E9, 1.167264017E9};
    }

    private static boolean isleap(double gpsTime) {
        boolean isLeap = false;
        double[] leaps = GpsTimeConverter.getleaps();
        for (int i = 0; i < leaps.length; ++i) {
            if (gpsTime != leaps[i]) continue;
            isLeap = true;
            break;
        }
        return isLeap;
    }

    private static int countleaps(double gpsTime, boolean accum_leaps) {
        double[] leaps = GpsTimeConverter.getleaps();
        int nleaps = 0;
        if (accum_leaps) {
            for (int i = 0; i < leaps.length; ++i) {
                if (!(gpsTime + (double)i >= leaps[i])) continue;
                ++nleaps;
            }
        } else {
            for (int i = 0; i < leaps.length; ++i) {
                if (!(gpsTime >= leaps[i])) continue;
                ++nleaps;
            }
        }
        return nleaps;
    }

    private static boolean isunixtimeleap(double unixTime) {
        double gpsTime = unixTime - 3.159648E8;
        gpsTime += (double)(GpsTimeConverter.countleaps(gpsTime, true) - 1);
        return GpsTimeConverter.isleap(gpsTime);
    }

    public static double dateTime2gps(double dateTimeMillis) {
        double ipart = Math.floor(dateTimeMillis /= 1000.0);
        double fpart = dateTimeMillis % 1.0;
        double gpsTime = ipart - 3.159648E8;
        if (GpsTimeConverter.isunixtimeleap(Math.ceil(dateTimeMillis))) {
            fpart *= 2.0;
        }
        return gpsTime + fpart + (double)GpsTimeConverter.countleaps(gpsTime, true);
    }

    public static DateTime gpsWeekTime2DateTime(double gpsWeekTime) {
        double fpart = gpsWeekTime % 1.0;
        double ipart = Math.floor(gpsWeekTime);
        double unixTime = ipart + 3.159648E8 - (double)GpsTimeConverter.countleaps(ipart, false);
        unixTime = GpsTimeConverter.isleap(ipart + 1.0) ? (unixTime += fpart / 2.0) : (GpsTimeConverter.isleap(ipart) ? (unixTime += (fpart + 1.0) / 2.0) : (unixTime += fpart));
        DateTime dt = new DateTime((long)unixTime * 1000L);
        return dt;
    }

    public static EGpsWeekDays gpsWeekTime2WeekDay(double gpsWeekTime) {
        int seconds = (int)gpsWeekTime;
        EGpsWeekDays day4Seconds = EGpsWeekDays.getDay4Seconds(seconds);
        return day4Seconds;
    }

    public static String gpsWeekTime2ISO8601(double gpsWeekTime) {
        DateTime gps2unix = GpsTimeConverter.gpsWeekTime2DateTime(gpsWeekTime);
        return gps2unix.toString(ISO8601Formatter);
    }
}

