/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.las.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.geotools.coverage.grid.GridCoverage2D;
import org.hortonmachine.gears.io.las.core.ALasReader;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.ui.progress.IProgressPrinter;
import org.hortonmachine.gears.ui.progress.ProgressUpdate;
import org.hortonmachine.gears.utils.colors.ColorInterpolator;
import org.hortonmachine.gears.utils.colors.EColorTables;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.math.NumericsUtilities;
import org.locationtech.jts.geom.Envelope;

public class LasConstraints {
    private Integer sampling = null;
    private int[] impulsesConstrains = null;
    private int[] classesConstrains = null;
    private Double minIntensityConstrain = null;
    private Double maxIntensityConstrain = null;
    private Double westConstrain = null;
    private Double eastConstrain = null;
    private Double southConstrain = null;
    private Double northConstrain = null;
    private Double minZConstrain = null;
    private Double maxZConstrain = null;
    private Double lowerThresConstrain = null;
    private Double upperThresConstrain = null;
    private double minInt = Double.POSITIVE_INFINITY;
    private double maxInt = Double.NEGATIVE_INFINITY;
    private double minClass = Double.POSITIVE_INFINITY;
    private double maxClass = Double.NEGATIVE_INFINITY;
    private double minImpulse = Double.POSITIVE_INFINITY;
    private double maxImpulse = Double.NEGATIVE_INFINITY;
    private double minElevation = Double.POSITIVE_INFINITY;
    private double maxElevation = Double.NEGATIVE_INFINITY;
    private double minGroundHeight = Double.POSITIVE_INFINITY;
    private double maxGroundHeight = Double.NEGATIVE_INFINITY;
    private Envelope filteredEnvelope;
    private GridCoverage2D dtm;
    private double minIntensityConstrainD;
    private double maxIntensityConstrainD;
    private double westConstrainD;
    private double eastConstrainD;
    private double southConstrainD;
    private double northConstrainD;
    private double minZConstrainD;
    private double maxZConstrainD;
    private double lowerThresConstrainD;
    private double upperThresConstrainD;
    private List<LasRecord> filteredPoints;
    private List<LasRecord> lastReadPoints;

    public List<LasRecord> getFilteredPoints() {
        return this.filteredPoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyConstraints(ALasReader lasReader, boolean doReread, IProgressPrinter progressPrinter) throws Exception {
        boolean doSampling = false;
        int samp = -1;
        if (this.sampling != null) {
            doSampling = true;
            samp = this.sampling;
        }
        int count = 0;
        this.minInt = Double.POSITIVE_INFINITY;
        this.maxInt = Double.NEGATIVE_INFINITY;
        this.minClass = Double.POSITIVE_INFINITY;
        this.maxClass = Double.NEGATIVE_INFINITY;
        this.minImpulse = Double.POSITIVE_INFINITY;
        this.maxImpulse = Double.NEGATIVE_INFINITY;
        this.minElevation = Double.POSITIVE_INFINITY;
        this.maxElevation = Double.NEGATIVE_INFINITY;
        this.maxGroundHeight = Double.NEGATIVE_INFINITY;
        this.minGroundHeight = Double.POSITIVE_INFINITY;
        this.minIntensityConstrainD = this.minIntensityConstrain != null ? this.minIntensityConstrain : 0.0;
        this.maxIntensityConstrainD = this.maxIntensityConstrain != null ? this.maxIntensityConstrain : 0.0;
        this.westConstrainD = this.westConstrain != null ? this.westConstrain : 0.0;
        this.eastConstrainD = this.eastConstrain != null ? this.eastConstrain : 0.0;
        this.southConstrainD = this.southConstrain != null ? this.southConstrain : 0.0;
        this.northConstrainD = this.northConstrain != null ? this.northConstrain : 0.0;
        this.minZConstrainD = this.minZConstrain != null ? this.minZConstrain : 0.0;
        this.maxZConstrainD = this.maxZConstrain != null ? this.maxZConstrain : 0.0;
        this.lowerThresConstrainD = this.lowerThresConstrain != null ? this.lowerThresConstrain : 0.0;
        this.upperThresConstrainD = this.upperThresConstrain != null ? this.upperThresConstrain : 0.0;
        this.filteredEnvelope = new Envelope();
        if (doReread || this.lastReadPoints == null) {
            this.lastReadPoints = new ArrayList<LasRecord>(1000000);
            try {
                int progress = 0;
                while (lasReader.hasNextPoint()) {
                    LasRecord lasDot;
                    boolean takeIt;
                    if (count % 1000 == 0 && progressPrinter != null) {
                        progressPrinter.publish(new ProgressUpdate("Reading dataset...", progress++));
                    }
                    if (!(takeIt = this.checkPoint(lasDot = lasReader.getNextPoint(), doSampling, samp, ++count))) continue;
                    this.lastReadPoints.add(lasDot);
                }
                this.filteredPoints = this.lastReadPoints;
                System.out.println(this.filteredPoints.size());
            }
            finally {
                try {
                    lasReader.rewind();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        ArrayList<LasRecord> newFilteredPoints = new ArrayList<LasRecord>(1000000);
        this.lastReadPoints.forEach(lr -> {
            boolean takeIt = this.checkPoint((LasRecord)lr, false, -1, -1);
            if (takeIt) {
                newFilteredPoints.add((LasRecord)lr);
            }
        });
        this.filteredPoints = newFilteredPoints;
        System.out.println(this.filteredPoints.size());
    }

    private boolean checkPoint(LasRecord lasDot, boolean doSampling, int samp, int count) {
        int n;
        int n2;
        int[] nArray;
        boolean takeIt = true;
        double x = lasDot.x;
        double y = lasDot.y;
        double z = lasDot.z;
        double intensity = lasDot.intensity;
        byte classification = lasDot.classification;
        double impulse = lasDot.returnNumber;
        if (doSampling && count % samp != 0) {
            takeIt = false;
        }
        if (takeIt && this.minIntensityConstrain != null) {
            takeIt = false;
            if (intensity >= this.minIntensityConstrainD && intensity <= this.maxIntensityConstrainD) {
                takeIt = true;
            }
        }
        if (takeIt && this.impulsesConstrains != null) {
            takeIt = false;
            nArray = this.impulsesConstrains;
            n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                double imp = nArray[n];
                if (!NumericsUtilities.dEq(impulse, imp)) continue;
                takeIt = true;
                break;
            }
        }
        if (takeIt && this.classesConstrains != null) {
            takeIt = false;
            nArray = this.classesConstrains;
            n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                double classs = nArray[n];
                if (classification != (int)classs) continue;
                takeIt = true;
                break;
            }
        }
        if (takeIt && this.westConstrain != null && this.eastConstrain != null && this.southConstrain != null && this.northConstrain != null) {
            takeIt = false;
            if (x >= this.westConstrainD && x <= this.eastConstrainD && y >= this.southConstrainD && y <= this.northConstrainD) {
                takeIt = true;
            }
        }
        if (takeIt && this.minZConstrain != null && this.maxZConstrain != null) {
            takeIt = false;
            if (z >= this.minZConstrainD && z <= this.maxZConstrainD) {
                takeIt = true;
            }
        }
        if (takeIt) {
            if (this.dtm != null) {
                double value = CoverageUtilities.getValue(this.dtm, lasDot.x, lasDot.y);
                if (!HMConstants.isNovalue(value)) {
                    double groundHeight = z - value;
                    if (groundHeight < 0.0) {
                        groundHeight = 0.0;
                    }
                    lasDot.groundElevation = groundHeight;
                    takeIt = true;
                } else {
                    takeIt = false;
                }
                if (this.lowerThresConstrain != null) {
                    boolean bl = takeIt = lasDot.groundElevation >= this.lowerThresConstrainD;
                }
                if (this.upperThresConstrain != null) {
                    takeIt = lasDot.groundElevation <= this.upperThresConstrainD;
                }
            } else {
                lasDot.groundElevation = Double.NaN;
            }
        }
        if (takeIt) {
            this.minImpulse = Math.min(this.minImpulse, impulse);
            this.maxImpulse = Math.max(this.maxImpulse, impulse);
            this.minInt = Math.min(this.minInt, intensity);
            this.maxInt = Math.max(this.maxInt, intensity);
            this.minClass = Math.min(this.minClass, (double)classification);
            this.maxClass = Math.max(this.maxClass, (double)classification);
            this.minElevation = Math.min(this.minElevation, z);
            this.maxElevation = Math.max(this.maxElevation, z);
            if (!Double.isNaN(lasDot.groundElevation)) {
                this.minGroundHeight = Math.min(this.minGroundHeight, lasDot.groundElevation);
                this.maxGroundHeight = Math.max(this.maxGroundHeight, lasDot.groundElevation);
            }
            this.filteredEnvelope.expandToInclude(x, y);
        }
        return takeIt;
    }

    public ColorInterpolator getElevationColorInterpolator() {
        if (Double.isInfinite(this.maxGroundHeight)) {
            return new ColorInterpolator(EColorTables.elev.name(), this.minElevation, this.maxElevation, null);
        }
        return new ColorInterpolator(EColorTables.elev.name(), this.minGroundHeight, this.maxGroundHeight, null);
    }

    public ColorInterpolator getIntensityColorInterpolator() {
        return new ColorInterpolator(EColorTables.rainbow.name(), this.minInt, this.maxInt, null);
    }

    public ColorInterpolator getImpulseColorInterpolator() {
        return new ColorInterpolator(EColorTables.rainbow.name(), this.minImpulse, this.maxImpulse, null);
    }

    public ColorInterpolator getClassificationColorInterpolator() {
        return new ColorInterpolator(EColorTables.rainbow.name(), this.minClass, this.maxClass, null);
    }

    public double[] getStats() {
        return new double[]{this.minElevation, this.maxElevation, this.minInt, this.maxInt, this.minClass, this.maxClass, this.minImpulse, this.maxImpulse, this.minGroundHeight, this.maxGroundHeight};
    }

    public Envelope getFilteredEnvelope() {
        return this.filteredEnvelope;
    }

    public void setSampling(Integer sampling) {
        this.sampling = sampling;
    }

    public void setClassifications(int[] classes) {
        this.classesConstrains = classes;
    }

    public void setImpulses(int[] impulses) {
        this.impulsesConstrains = impulses;
    }

    public void setMaxIntensity(Double maxInt) {
        this.maxIntensityConstrain = maxInt;
    }

    public void setMinIntensity(Double minInt) {
        this.minIntensityConstrain = minInt;
    }

    public void setWest(Double west) {
        this.westConstrain = west;
        this.checkBounds();
    }

    public void setEast(Double east) {
        this.eastConstrain = east;
        this.checkBounds();
    }

    public void setSouth(Double south) {
        this.southConstrain = south;
        this.checkBounds();
    }

    public void setNorth(Double north) {
        this.northConstrain = north;
        this.checkBounds();
    }

    public void setMinZ(Double minZ) {
        this.minZConstrain = minZ;
        this.checkBounds();
    }

    public void setMaxZ(Double maxZ) {
        this.maxZConstrain = maxZ;
        this.checkBounds();
    }

    public Double[] checkBounds() {
        if (this.westConstrain != null && this.eastConstrain != null) {
            double westConstrainTmp = Math.min(this.westConstrain, this.eastConstrain);
            this.eastConstrain = Math.max(this.westConstrain, this.eastConstrain);
            this.westConstrain = westConstrainTmp;
        }
        if (this.southConstrain != null && this.northConstrain != null) {
            double southConstrainTmp = Math.min(this.southConstrain, this.northConstrain);
            this.northConstrain = Math.max(this.southConstrain, this.northConstrain);
            this.southConstrain = southConstrainTmp;
        }
        if (this.minZConstrain != null && this.maxZConstrain != null) {
            double minZConstrainTmp = Math.min(this.minZConstrain, this.maxZConstrain);
            this.maxZConstrain = Math.max(this.minZConstrain, this.maxZConstrain);
            this.minZConstrain = minZConstrainTmp;
        }
        return new Double[]{this.westConstrain, this.eastConstrain, this.southConstrain, this.northConstrain, this.minZConstrain, this.maxZConstrain};
    }

    public void setDtm(GridCoverage2D dtm) {
        this.dtm = dtm;
    }

    public void setLowerThres(Double lowerThres) {
        this.lowerThresConstrain = lowerThres;
    }

    public void setUpperThres(Double upperThres) {
        this.upperThresConstrain = upperThres;
    }
}

