/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.las.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.hortonmachine.gears.io.las.core.ALasReader;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.io.las.core.v_1_0.LasReaderBuffered;
import org.hortonmachine.gears.io.vectorwriter.OmsVectorWriter;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;
import org.hortonmachine.gears.modules.utils.fileiterator.OmsFileIterator;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.hortonmachine.gears.utils.math.NumericsUtilities;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.triangulate.DelaunayTriangulationBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LasUtils {
    private static final GeometryFactory gf = GeometryUtilities.gf();
    public static final String THE_GEOM = "the_geom";
    public static final String ID = "rid";
    public static final String ELEVATION = "elev";
    public static final String INTENSITY = "intensity";
    public static final String CLASSIFICATION = "classificazione";
    public static final String IMPULSE = "impulse";
    public static final String NUM_OF_IMPULSES = "numimpulse";
    private static SimpleFeatureBuilder lasSimpleFeatureBuilder;
    public static String dateTimeFormatterYYYYMMDD_string;
    public static DateTimeFormatter dateTimeFormatterYYYYMMDD;
    private static DateTime gpsEpoch;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLasFileVersion(File lasFile) throws IOException {
        FileInputStream fis = null;
        AbstractInterruptibleChannel fc = null;
        try {
            String version;
            fis = new FileInputStream(lasFile);
            fc = fis.getChannel();
            fis.skip(24L);
            int versionMajor = fis.read();
            int versionMinor = fis.read();
            String string = version = versionMajor + "." + versionMinor;
            return string;
        }
        finally {
            fc.close();
            fis.close();
        }
    }

    public static SimpleFeatureBuilder getLasFeatureBuilder(CoordinateReferenceSystem crs) {
        if (lasSimpleFeatureBuilder == null) {
            SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
            b.setName("lasdata");
            b.setCRS(crs);
            b.add(THE_GEOM, Point.class);
            b.add(ID, Integer.class);
            b.add(ELEVATION, Double.class);
            b.add(INTENSITY, Double.class);
            b.add(CLASSIFICATION, Integer.class);
            b.add(IMPULSE, Double.class);
            b.add(NUM_OF_IMPULSES, Double.class);
            SimpleFeatureType featureType = b.buildFeatureType();
            lasSimpleFeatureBuilder = new SimpleFeatureBuilder(featureType);
        }
        return lasSimpleFeatureBuilder;
    }

    public static SimpleFeature tofeature(LasRecord r, Integer featureId, CoordinateReferenceSystem crs) {
        Point point = LasUtils.toGeometry(r);
        double elev = r.z;
        if (!Double.isNaN(r.groundElevation)) {
            elev = r.groundElevation;
        }
        if (featureId == null) {
            featureId = -1;
        }
        Object[] values = new Object[]{point, featureId, elev, r.intensity, r.classification, r.returnNumber, r.numberOfReturns};
        SimpleFeatureBuilder lasFeatureBuilder = LasUtils.getLasFeatureBuilder(crs);
        lasFeatureBuilder.addAll(values);
        SimpleFeature feature = lasFeatureBuilder.buildFeature(null);
        return feature;
    }

    public static Point toGeometry(LasRecord r) {
        return gf.createPoint(new Coordinate(r.x, r.y));
    }

    public static List<LasRecord> getLasRecordsFromFeatureCollection(SimpleFeatureCollection lasCollection, boolean elevIsGround) {
        List<SimpleFeature> featuresList = FeatureUtilities.featureCollectionToList(lasCollection);
        ArrayList<LasRecord> lasList = new ArrayList<LasRecord>();
        for (SimpleFeature lasFeature : featuresList) {
            short numOfImpulses;
            short impulse;
            byte classification;
            short intensity;
            double elevation;
            LasRecord r = new LasRecord();
            Coordinate coordinate = ((Geometry)lasFeature.getDefaultGeometry()).getCoordinate();
            r.x = coordinate.x;
            r.y = coordinate.y;
            r.z = elevation = ((Number)lasFeature.getAttribute(ELEVATION)).doubleValue();
            if (elevIsGround) {
                r.groundElevation = elevation;
            }
            r.intensity = intensity = ((Number)lasFeature.getAttribute(INTENSITY)).shortValue();
            r.classification = classification = ((Number)lasFeature.getAttribute(CLASSIFICATION)).byteValue();
            r.returnNumber = impulse = ((Number)lasFeature.getAttribute(IMPULSE)).shortValue();
            r.numberOfReturns = numOfImpulses = ((Number)lasFeature.getAttribute(NUM_OF_IMPULSES)).shortValue();
            lasList.add(r);
        }
        return lasList;
    }

    public static DateTime adjustedStandardGpsTime2DateTime(double adjustedStandardGpsTime) {
        double standardGpsTimeSeconds = adjustedStandardGpsTime + 1.0E9;
        double standardGpsTimeMillis = standardGpsTimeSeconds * 1000.0;
        DateTime dt1 = gpsEpoch.plus((long)standardGpsTimeMillis);
        return dt1;
    }

    public static double dateTimeToStandardGpsTime(DateTime dateTime) {
        long millis = dateTime.getMillis() - gpsEpoch.getMillis();
        return (double)millis / 1000.0;
    }

    public static void dumpLasFolderOverview(String folder, CoordinateReferenceSystem crs) throws Exception {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("overview");
        b.setCRS(crs);
        b.add(THE_GEOM, Polygon.class);
        b.add("name", String.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
        OmsFileIterator iter = new OmsFileIterator();
        iter.inFolder = folder;
        iter.fileFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".las");
            }
        };
        iter.process();
        List<File> filesList = iter.filesList;
        for (File file : filesList) {
            try (LasReaderBuffered r = new LasReaderBuffered(file, crs);){
                ((ALasReader)r).open();
                ReferencedEnvelope3D envelope = ((ALasReader)r).getHeader().getDataEnvelope();
                Polygon polygon = GeometryUtilities.createPolygonFromEnvelope((Envelope)envelope);
                Object[] objs = new Object[]{polygon, ((ALasReader)r).getLasFile().getName()};
                builder.addAll(objs);
                SimpleFeature feature = builder.buildFeature(null);
                newCollection.add(feature);
            }
        }
        File folderFile = new File(folder);
        File outFile = new File(folder, "overview_" + folderFile.getName() + ".shp");
        OmsVectorWriter.writeVector(outFile.getAbsolutePath(), (SimpleFeatureCollection)newCollection);
    }

    public static double distance(LasRecord r1, LasRecord r2) {
        double distance = NumericsUtilities.pythagoras(r1.x - r2.x, r1.y - r2.y);
        return distance;
    }

    public static double distance3D(LasRecord r1, LasRecord r2) {
        double deltaElev = Math.abs(r1.z - r2.z);
        double projectedDistance = NumericsUtilities.pythagoras(r1.x - r2.x, r1.y - r2.y);
        double distance = NumericsUtilities.pythagoras(projectedDistance, deltaElev);
        return distance;
    }

    public static String lasRecordToString(LasRecord dot) {
        String CR = "\n";
        String TAB = "\t";
        StringBuilder retValue = new StringBuilder();
        retValue.append("Dot ( \n").append("\t").append("x = ").append(dot.x).append("\n").append("\t").append("y = ").append(dot.y).append("\n").append("\t").append("z = ").append(dot.z).append("\n").append("\t").append("intensity = ").append(dot.intensity).append("\n").append("\t").append("impulse = ").append(dot.returnNumber).append("\n").append("\t").append("impulseNum = ").append(dot.numberOfReturns).append("\n").append("\t").append("classification = ").append(dot.classification).append("\n").append("\t").append("gpsTime = ").append(dot.gpsTime).append("\n").append(" )");
        return retValue.toString();
    }

    public static boolean lasRecordEqual(LasRecord dot1, LasRecord dot2) {
        double delta = 1.0E-6;
        boolean check = NumericsUtilities.dEq(dot1.x, dot2.x, delta);
        if (!check) {
            return false;
        }
        check = NumericsUtilities.dEq(dot1.y, dot2.y, delta);
        if (!check) {
            return false;
        }
        check = NumericsUtilities.dEq(dot1.z, dot2.z, delta);
        if (!check) {
            return false;
        }
        boolean bl = check = dot1.intensity == dot2.intensity;
        if (!check) {
            return false;
        }
        boolean bl2 = check = dot1.classification == dot2.classification;
        if (!check) {
            return false;
        }
        boolean bl3 = check = dot1.returnNumber == dot2.returnNumber;
        if (!check) {
            return false;
        }
        boolean bl4 = check = dot1.numberOfReturns == dot2.numberOfReturns;
        return check;
    }

    public static double avg(List<LasRecord> points, VALUETYPE valueType) {
        double sum = 0.0;
        int count = 0;
        for (LasRecord lasRecord : points) {
            sum += LasUtils.getValue(valueType, lasRecord);
            ++count;
        }
        double avg = sum / (double)count;
        return avg;
    }

    private static double getValue(VALUETYPE valueType, LasRecord lasRecord) {
        switch (valueType) {
            case ELEVATION: {
                return lasRecord.z;
            }
            case GROUNDELEVATION: {
                return lasRecord.groundElevation;
            }
            case CLASSIFICATION: {
                return lasRecord.classification;
            }
            case INTENSITY: {
                return lasRecord.intensity;
            }
            case IMPULSE: {
                return lasRecord.returnNumber;
            }
            case NUM_OF_IMPULSES: {
                return lasRecord.numberOfReturns;
            }
            case X: {
                return lasRecord.x;
            }
            case Y: {
                return lasRecord.y;
            }
        }
        return Double.NaN;
    }

    public static double[][] histogram(List<LasRecord> points, VALUETYPE valueType, int bins) {
        int i;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (LasRecord lasRecord : points) {
            double value = LasUtils.getValue(valueType, lasRecord);
            min = Math.min(min, value);
            max = Math.max(max, value);
        }
        double range = max - min;
        double step = range / (double)bins;
        double[][] histogram = new double[bins][3];
        for (int i2 = 0; i2 < histogram.length; ++i2) {
            histogram[i2][0] = min + step * (double)(i2 + 1);
        }
        block2: for (LasRecord lasRecord : points) {
            double value = LasUtils.getValue(valueType, lasRecord);
            for (int j = 0; j < histogram.length; ++j) {
                if (!(value <= histogram[j][0])) continue;
                histogram[j][1] = histogram[j][1] + 1.0;
                continue block2;
            }
        }
        double cumulatedMax = 0.0;
        for (i = 0; i < histogram.length; ++i) {
            histogram[i][2] = i == 0 ? histogram[i][1] : histogram[i - 1][2] + histogram[i][1];
            cumulatedMax = histogram[i][2];
        }
        for (i = 0; i < histogram.length; ++i) {
            histogram[i][2] = histogram[i][2] / cumulatedMax;
            histogram[i][0] = histogram[i][0] - step / 2.0;
        }
        return histogram;
    }

    public static List<Geometry> triangulate(List<LasRecord> lasPoints, Double elevThres, boolean useGround, IHMProgressMonitor pm) {
        pm.beginTask("Triangulation...", -1);
        ArrayList<Coordinate> lasCoordinates = new ArrayList<Coordinate>();
        for (LasRecord lasRecord : lasPoints) {
            lasCoordinates.add(new Coordinate(lasRecord.x, lasRecord.y, useGround ? lasRecord.groundElevation : lasRecord.z));
        }
        DelaunayTriangulationBuilder triangulationBuilder = new DelaunayTriangulationBuilder();
        triangulationBuilder.setSites(lasCoordinates);
        Geometry triangles = triangulationBuilder.getTriangles(gf);
        pm.done();
        ArrayList<Geometry> trianglesList = new ArrayList<Geometry>();
        int numTriangles = triangles.getNumGeometries();
        if (elevThres == null) {
            for (int i = 0; i < numTriangles; ++i) {
                Geometry geometryN = triangles.getGeometryN(i);
                trianglesList.add(geometryN);
            }
        } else {
            double pElevThres = elevThres;
            numTriangles = triangles.getNumGeometries();
            pm.beginTask("Extracting triangles based on threshold...", numTriangles);
            for (int i = 0; i < numTriangles; ++i) {
                double diff3;
                double diff2;
                pm.worked(1);
                Geometry geometryN = triangles.getGeometryN(i);
                Coordinate[] coordinates = geometryN.getCoordinates();
                double z0 = coordinates[0].z;
                double z1 = coordinates[1].z;
                double z2 = coordinates[2].z;
                double diff1 = Math.abs(z0 - z1);
                if (diff1 > pElevThres || (diff2 = Math.abs(z0 - z2)) > pElevThres || (diff3 = Math.abs(z1 - z2)) > pElevThres) continue;
                trianglesList.add(geometryN);
            }
            pm.done();
        }
        pm.beginTask("Triangulation1...", -1);
        ArrayList<Coordinate> lasCoordinates2 = new ArrayList<Coordinate>();
        for (Geometry g : trianglesList) {
            Coordinate[] c = g.getCoordinates();
            lasCoordinates2.add(c[0]);
            lasCoordinates2.add(c[1]);
            lasCoordinates2.add(c[2]);
        }
        trianglesList.clear();
        DelaunayTriangulationBuilder triangulationBuilder1 = new DelaunayTriangulationBuilder();
        triangulationBuilder1.setSites(lasCoordinates2);
        Geometry triangles1 = triangulationBuilder1.getTriangles(gf);
        pm.done();
        numTriangles = triangles1.getNumGeometries();
        for (int i = 0; i < numTriangles; ++i) {
            Geometry geometryN = triangles1.getGeometryN(i);
            trianglesList.add(geometryN);
        }
        return trianglesList;
    }

    /*
     * WARNING - void declaration
     */
    public static void smoothIDW(List<LasRecord> lasPoints, boolean useGround, double idwBuffer, IHMProgressMonitor pm) {
        void var7_11;
        Coordinate c;
        ArrayList<Coordinate> coordinatesList = new ArrayList<Coordinate>();
        if (useGround) {
            for (LasRecord lasRecord : lasPoints) {
                c = new Coordinate(lasRecord.x, lasRecord.y, lasRecord.groundElevation);
                coordinatesList.add(c);
            }
        } else {
            for (LasRecord lasRecord : lasPoints) {
                c = new Coordinate(lasRecord.x, lasRecord.y, lasRecord.z);
                coordinatesList.add(c);
            }
        }
        STRtree pointsTree = new STRtree(coordinatesList.size());
        pm.beginTask("Make points tree...", coordinatesList.size());
        for (Coordinate coord : coordinatesList) {
            pointsTree.insert(new Envelope(coord), (Object)coord);
            pm.worked(1);
        }
        pm.done();
        pm.beginTask("Interpolate...", coordinatesList.size());
        boolean bl = false;
        while (var7_11 < coordinatesList.size()) {
            Coordinate coord;
            coord = (Coordinate)coordinatesList.get((int)var7_11);
            Envelope env = new Envelope(coord);
            env.expandBy(idwBuffer);
            List nearPoints = pointsTree.query(env);
            double avg = 0.0;
            for (Coordinate coordinate : nearPoints) {
                avg += coordinate.z;
            }
            avg /= (double)nearPoints.size();
            LasRecord lasRecord = lasPoints.get((int)var7_11);
            if (useGround) {
                lasRecord.groundElevation = avg;
            } else {
                lasRecord.z = avg;
            }
            pm.worked(1);
            ++var7_11;
        }
        pm.done();
    }

    public static double[] getLastVisiblePointData(LasRecord baseRecord, List<LasRecord> lasRecords, boolean useGround) {
        if (lasRecords.size() < 1) {
            throw new IllegalArgumentException("This needs to have at least 1 point.");
        }
        double baseElev = useGround ? baseRecord.groundElevation : baseRecord.z;
        Coordinate baseCoord = new Coordinate(0.0, 0.0);
        double minAzimuthAngle = Double.POSITIVE_INFINITY;
        double maxAzimuthAngle = Double.NEGATIVE_INFINITY;
        LasRecord minAzimuthPoint = null;
        LasRecord maxAzimuthPoint = null;
        for (int i = 0; i < lasRecords.size(); ++i) {
            double currentElev;
            LasRecord currentPoint = lasRecords.get(i);
            double d = currentElev = useGround ? currentPoint.groundElevation : currentPoint.z;
            if (HMConstants.isNovalue(currentElev)) continue;
            currentElev -= baseElev;
            double currentProg = LasUtils.distance(baseRecord, currentPoint);
            Coordinate currentCoord = new Coordinate(currentProg, currentElev);
            double azimuth = GeometryUtilities.azimuth(baseCoord, currentCoord);
            if (azimuth <= minAzimuthAngle) {
                minAzimuthAngle = azimuth;
                minAzimuthPoint = currentPoint;
            }
            if (!(azimuth >= maxAzimuthAngle)) continue;
            maxAzimuthAngle = azimuth;
            maxAzimuthPoint = currentPoint;
        }
        if (minAzimuthPoint == null || maxAzimuthPoint == null) {
            return null;
        }
        return new double[]{useGround ? minAzimuthPoint.groundElevation : minAzimuthPoint.z, minAzimuthPoint.x, minAzimuthPoint.y, LasUtils.distance(baseRecord, minAzimuthPoint), minAzimuthAngle, useGround ? maxAzimuthPoint.groundElevation : maxAzimuthPoint.z, maxAzimuthPoint.x, maxAzimuthPoint.y, LasUtils.distance(baseRecord, maxAzimuthPoint), maxAzimuthAngle};
    }

    public static LasRecord clone(LasRecord lasRecord) {
        LasRecord clone = new LasRecord();
        clone.x = lasRecord.x;
        clone.y = lasRecord.y;
        clone.z = lasRecord.z;
        clone.intensity = lasRecord.intensity;
        clone.returnNumber = lasRecord.returnNumber;
        clone.numberOfReturns = lasRecord.numberOfReturns;
        clone.classification = lasRecord.classification;
        clone.color = lasRecord.color;
        clone.gpsTime = lasRecord.gpsTime;
        clone.groundElevation = lasRecord.groundElevation;
        clone.pointsDensity = lasRecord.pointsDensity;
        return clone;
    }

    static {
        dateTimeFormatterYYYYMMDD_string = "yyyy-MM-dd";
        dateTimeFormatterYYYYMMDD = DateTimeFormat.forPattern((String)dateTimeFormatterYYYYMMDD_string);
        gpsEpoch = new DateTime(1980, 1, 6, 0, 0, 0, 0, DateTimeZone.UTC);
    }

    public static enum VALUETYPE {
        ELEVATION,
        GROUNDELEVATION,
        CLASSIFICATION,
        INTENSITY,
        IMPULSE,
        NUM_OF_IMPULSES,
        X,
        Y;

    }
}

