/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.nmea;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class NmeaGpsPoint {
    public static final String GPGGA = "$GPGGA";
    public static final String GPRMC = "$GPRMC";
    public static final String strLatitude = "northing";
    public static final String strLongitude = "easting";
    public static final String strLat = "lat";
    public static final String strLon = "lon";
    public static final String strSpeed = "speed";
    public static final String strAltitude = "elev";
    public static final String strQuality = "quality";
    public static final String strSat = "satnum";
    public static final String strHdop = "hdop";
    public static final String strMsl = "dif_ell_msl";
    public static final String strUtctime = "utctime";
    public static final String strMag_var = "mag_var";
    public static final String strAngle = "angle";
    public static final String strValidity1 = "THIS POINT IS NOT VALID";
    public static final String strValidity2 = "";
    public double latitude = -1.0;
    public double longitude = -1.0;
    public double speed = -1.0;
    public double altitude = -1.0;
    public double quality = -1.0;
    public double sat = -1.0;
    public double hdop = -1.0;
    public double ellipsoidVsMsl = -1.0;
    public DateTime utcDateTime = null;
    public double mag_var = -1.0;
    public double angle = -1.0;
    public String altitudeUnit = "M";
    public String ellipsoidVsMslUnit = "M";
    public boolean isValid = false;
    private static DateTimeFormatter nmeaDateFormatter = DateTimeFormat.forPattern((String)"ddMMyyHHmmss.SSS");
    private static DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)"ddMMyyHHmmss");

    public NmeaGpsPoint() {
    }

    public NmeaGpsPoint(NmeaGpsPoint gpsPoint) {
        this.latitude = gpsPoint.latitude;
        this.longitude = gpsPoint.longitude;
        this.speed = gpsPoint.speed;
        this.quality = gpsPoint.quality;
        this.altitude = gpsPoint.altitude;
        this.sat = gpsPoint.sat;
        this.hdop = gpsPoint.hdop;
        this.ellipsoidVsMsl = gpsPoint.ellipsoidVsMsl;
        this.utcDateTime = gpsPoint.utcDateTime;
        this.mag_var = gpsPoint.mag_var;
        this.angle = gpsPoint.angle;
        this.altitudeUnit = gpsPoint.altitudeUnit;
        this.ellipsoidVsMslUnit = gpsPoint.ellipsoidVsMslUnit;
        this.isValid = gpsPoint.isValid;
    }

    public NmeaGpsPoint(String currentGPGGAsentence, String currentGPRMCsentence) {
        String[] dataBlocks;
        if (currentGPGGAsentence != null && currentGPGGAsentence.startsWith(GPGGA)) {
            dataBlocks = currentGPGGAsentence.split(",");
            if (dataBlocks[6].length() > 0) {
                this.quality = Double.parseDouble(dataBlocks[6]);
            }
            if (dataBlocks[7].length() > 0) {
                this.sat = Double.parseDouble(dataBlocks[7]);
            }
            if (dataBlocks[8].length() > 0) {
                this.hdop = Double.parseDouble(dataBlocks[8]);
            }
            if (dataBlocks[9].length() > 0) {
                this.altitude = Double.parseDouble(dataBlocks[9]);
                this.altitudeUnit = dataBlocks[10].toLowerCase();
            }
            if (dataBlocks[11].length() > 0) {
                this.ellipsoidVsMsl = Double.parseDouble(dataBlocks[11]);
                this.ellipsoidVsMslUnit = dataBlocks[12].toLowerCase();
            }
        }
        if (currentGPRMCsentence != null && currentGPRMCsentence.startsWith(GPRMC)) {
            dataBlocks = currentGPRMCsentence.split(",");
            if (dataBlocks[1].length() > 0 && dataBlocks[9].length() > 0) {
                try {
                    this.utcDateTime = nmeaDateFormatter.parseDateTime(dataBlocks[9] + dataBlocks[1]);
                }
                catch (Exception e) {
                    this.utcDateTime = DateTime.now();
                }
            }
            if (dataBlocks[2].length() > 0 && dataBlocks[2].trim().equals("A")) {
                this.isValid = true;
            }
            double latitude_in = 0.0;
            if (dataBlocks[3].length() > 0) {
                latitude_in = Double.parseDouble(dataBlocks[3]);
            }
            double longitude_in = 0.0;
            if (dataBlocks[5].length() > 0) {
                longitude_in = Double.parseDouble(dataBlocks[5]);
            }
            if (dataBlocks[10].length() > 0) {
                this.mag_var = Double.parseDouble(dataBlocks[10]);
            }
            double speed_in = 0.0;
            if (dataBlocks[7].length() > 0) {
                speed_in = Double.parseDouble(dataBlocks[7]);
            }
            if (dataBlocks[8].length() > 0) {
                this.angle = Double.parseDouble(dataBlocks[8]);
            }
            double latitude_degrees = Math.floor(latitude_in / 100.0);
            double latitude_minutes = latitude_in - latitude_degrees * 100.0;
            double longitude_degrees = Math.floor(longitude_in / 100.0);
            double longitude_minutes = longitude_in - longitude_degrees * 100.0;
            this.latitude = latitude_degrees + latitude_minutes / 60.0;
            this.longitude = longitude_degrees + longitude_minutes / 60.0;
            if (dataBlocks[4].equals("S")) {
                this.latitude = -this.latitude;
            }
            if (dataBlocks[6].equals("W")) {
                this.longitude = -this.longitude;
            }
            this.speed = (int)(speed_in * 1.852);
        }
    }

    public String toString() {
        String TAB = "/";
        Object retValue = strValidity2;
        String time = this.utcDateTime != null ? this.utcDateTime.toString(dateFormatter) : "-";
        retValue = "GpsPoint ( latitude = " + this.latitude + "/longitude = " + this.longitude + "/speed = " + this.speed + "/altitude = " + this.altitude + "/quality = " + this.quality + "/sat = " + this.sat + "/hdop = " + this.hdop + "/msl = " + this.ellipsoidVsMsl + "/utctime = " + time + "/mag_var = " + this.mag_var + "/angle = " + this.angle + "/ )";
        return retValue;
    }
}

