/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.properties;

import java.io.File;
import java.io.IOException;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.opengis.feature.simple.SimpleFeature;

@Description(value="Utility class for reading properties files to geotools featurecollections.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Properties, Feature, Vector, Reading")
@Label(value="Vector Reader")
@Name(value="propertiesfeaturereader")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
@UI(value="hide")
public class OmsPropertiesFeatureReader
extends HMModel {
    @Description(value="The properties file.")
    @UI(value="infile")
    @In
    public String file = null;
    @Description(value="The read feature collection.")
    @Out
    public SimpleFeatureCollection geodata = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void readFeatureCollection() throws IOException {
        if (!this.concatOr(this.geodata == null, this.doReset)) {
            return;
        }
        FeatureReader reader = null;
        try {
            File propertiesFile = new File(this.file);
            this.pm.beginTask("Reading features from properties file: " + propertiesFile.getName(), -1);
            PropertyDataStore store = new PropertyDataStore(propertiesFile.getParentFile());
            String name = FileUtilities.getNameWithoutExtention(propertiesFile);
            this.geodata = new DefaultFeatureCollection();
            Query query = new Query(name);
            reader = store.getFeatureReader(query, Transaction.AUTO_COMMIT);
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                ((DefaultFeatureCollection)this.geodata).add(feature);
            }
        }
        finally {
            this.pm.done();
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static SimpleFeatureCollection readPropertiesfile(String path) throws IOException {
        OmsPropertiesFeatureReader reader = new OmsPropertiesFeatureReader();
        reader.file = path;
        reader.readFeatureCollection();
        return reader.geodata;
    }
}

