/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.rasterreader;

import java.awt.RenderingHints;
import java.io.File;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverage.grid.io.UnknownFormat;
import org.geotools.coverage.processing.Operations;
import org.geotools.gce.grassraster.GrassCoverageReader;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.gce.grassraster.format.GrassCoverageFormat;
import org.geotools.gce.grassraster.format.GrassCoverageFormatFactory;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.factory.Hints;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.CrsUtilities;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.locationtech.jts.geom.Envelope;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Raster reader module.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Coverage, Raster, Reading")
@Label(value="Raster Reader")
@Name(value="rasterreader")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsRasterReader
extends HMModel {
    @Description(value="The raster file to read with extension (supported are: asc, tiff, grass).")
    @UI(value="infile_raster")
    @In
    public String file = null;
    @Description(value="The optional requested boundary north coordinate.")
    @UI(value="process_north")
    @In
    public Double pNorth = null;
    @Description(value="The optional requested boundary south coordinate.")
    @UI(value="process_south")
    @In
    public Double pSouth = null;
    @Description(value="The optional requested boundary west coordinate.")
    @UI(value="process_west")
    @In
    public Double pWest = null;
    @Description(value="The optional requested boundary east coordinate.")
    @UI(value="process_east")
    @In
    public Double pEast = null;
    @Description(value="The optional requested resolution in x.")
    @UI(value="process_xres")
    @In
    public Double pXres = null;
    @Description(value="The optional requested resolution in y.")
    @UI(value="process_yres")
    @In
    public Double pYres = null;
    @Description(value="The optional requested numer of rows.")
    @UI(value="process_rows")
    @In
    public Integer pRows = null;
    @Description(value="The optional requested numer of cols.")
    @UI(value="process_cols")
    @In
    public Integer pCols = null;
    @Description(value="The read output raster map.")
    @Out
    public GridCoverage2D outRaster = null;
    public static final String OMSRASTERREADER_DESCRIPTION = "Raster reader module.";
    public static final String OMSRASTERREADER_DOCUMENTATION = "OmsRasterReader.html";
    public static final String OMSRASTERREADER_KEYWORDS = "IO, Coverage, Raster, Reading";
    public static final String OMSRASTERREADER_LABEL = "Raster Reader";
    public static final String OMSRASTERREADER_NAME = "rasterreader";
    public static final int OMSRASTERREADER_STATUS = 40;
    public static final String OMSRASTERREADER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSRASTERREADER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSRASTERREADER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSRASTERREADER_FILE_DESCRIPTION = "The raster file to read with extension (supported are: asc, tiff, grass).";
    public static final String OMSRASTERREADER_P_NORTH_DESCRIPTION = "The optional requested boundary north coordinate.";
    public static final String OMSRASTERREADER_P_SOUTH_DESCRIPTION = "The optional requested boundary south coordinate.";
    public static final String OMSRASTERREADER_P_WEST_DESCRIPTION = "The optional requested boundary west coordinate.";
    public static final String OMSRASTERREADER_P_EAST_DESCRIPTION = "The optional requested boundary east coordinate.";
    public static final String OMSRASTERREADER_P_X_RES_DESCRIPTION = "The optional requested resolution in x.";
    public static final String OMSRASTERREADER_P_Y_RES_DESCRIPTION = "The optional requested resolution in y.";
    public static final String OMSRASTERREADER_P_ROWS_DESCRIPTION = "The optional requested numer of rows.";
    public static final String OMSRASTERREADER_P_COLS_DESCRIPTION = "The optional requested numer of cols.";
    public static final String OMSRASTERREADER_DO_LEGACY_GRASS_DESCRIPTION = "Optional flag to force a legacy GRASS driver usage.";
    public static final String OMSRASTERREADER_OUT_RASTER_DESCRIPTION = "The read output raster map.";
    public boolean doEnvelope = false;
    public GeneralEnvelope originalEnvelope;
    private GeneralParameterValue[] generalParameter = null;
    private double[] pBounds;
    private double[] pRes;
    private int[] pRowcol;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Execute
    public void process() throws Exception {
        File mapFile;
        AbstractGridFormat format;
        if (!this.concatOr(this.outRaster == null, this.doReset)) {
            return;
        }
        if (this.hasBoundsRequest() && !this.hasResolutionRequest() && !this.hasRowColsRequest()) {
            throw new RuntimeException("If bounds are requested, also a resolution or number of rows/cols has to be supplied.");
        }
        if (this.hasBoundsRequest()) {
            this.pBounds = new double[]{this.pNorth, this.pSouth, this.pWest, this.pEast};
        }
        if (this.hasResolutionRequest()) {
            this.pRes = new double[]{this.pXres, this.pYres};
        }
        if (this.hasRowColsRequest()) {
            this.pRowcol = new int[]{this.pRows, this.pCols};
        }
        if ((format = GridFormatFinder.findFormat((Object)(mapFile = new File(this.file)))) != null && !(format instanceof GrassCoverageFormat)) {
            if (format instanceof UnknownFormat) {
                throw new ModelsIllegalargumentException("Unupported format for: " + mapFile, this.getClass().getSimpleName(), this.pm);
            }
            try {
                boolean crsValid;
                this.pm.beginTask("Reading coverage: " + mapFile.getName(), -1);
                AbstractGridCoverage2DReader rasterReader = format.getReader((Object)mapFile, new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE));
                this.originalEnvelope = rasterReader.getOriginalEnvelope();
                if (!this.doEnvelope) {
                    this.outRaster = rasterReader.read(this.generalParameter);
                    this.resample();
                }
                if (crsValid = CrsUtilities.isCrsValid(this.outRaster.getCoordinateReferenceSystem())) return;
                this.pm.errorMessage("The read CRS doesn't seem to be valid. This could lead to unexpected results. Consider adding a .prj file with the proper CRS definition if none is present.");
                return;
            }
            finally {
                this.pm.done();
            }
        }
        if (!CoverageUtilities.isGrass(this.file)) throw new ModelsIllegalargumentException("Can't recognize the data format for: " + mapFile, this.getClass().getSimpleName(), this.pm);
        try {
            this.pm.beginTask("Reading coverage: " + mapFile.getName(), -1);
            this.readGrass(mapFile);
            return;
        }
        finally {
            this.pm.done();
        }
    }

    private void readGrass(File mapFile) throws Exception {
        JGrassMapEnvironment mapEnvironment = new JGrassMapEnvironment(new File(this.file));
        CoordinateReferenceSystem crs = mapEnvironment.getCoordinateReferenceSystem();
        JGrassRegion readRegion = mapEnvironment.getFileRegion();
        double n = readRegion.getNorth();
        double s = readRegion.getSouth();
        double w = readRegion.getWest();
        double e = readRegion.getEast();
        Envelope env = readRegion.getEnvelope();
        this.originalEnvelope = new GeneralEnvelope((org.opengis.geometry.Envelope)new ReferencedEnvelope(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), crs));
        if (this.pBounds != null) {
            n = this.pBounds[0];
            s = this.pBounds[1];
            w = this.pBounds[2];
            e = this.pBounds[3];
        }
        if (this.pRes != null) {
            readRegion = new JGrassRegion(w, e, s, n, this.pRes[0], this.pRes[1]);
        }
        if (this.pRowcol != null) {
            readRegion = new JGrassRegion(w, e, s, n, this.pRowcol[0], this.pRowcol[1]);
        }
        if (!this.doEnvelope) {
            if (this.generalParameter == null) {
                this.generalParameter = CoverageUtilities.createGridGeometryGeneralParameter(readRegion.getCols(), readRegion.getRows(), readRegion.getNorth(), readRegion.getSouth(), readRegion.getEast(), readRegion.getWest(), crs);
            }
            GrassCoverageFormat format = new GrassCoverageFormatFactory().createFormat();
            GrassCoverageReader reader = format.getReader((Object)mapEnvironment.getCELL());
            this.outRaster = reader.read(this.generalParameter);
        }
    }

    private void resample() {
        if (!(this.hasBoundsRequest() || this.hasResolutionRequest() || this.hasRowColsRequest())) {
            return;
        }
        RegionMap envelopeParams = CoverageUtilities.getRegionParamsFromGridCoverage(this.outRaster);
        double west = (Double)envelopeParams.get("WEST");
        double south = (Double)envelopeParams.get("SOUTH");
        double east = (Double)envelopeParams.get("EAST");
        double north = (Double)envelopeParams.get("NORTH");
        double xres = (Double)envelopeParams.get("XRES");
        double yres = (Double)envelopeParams.get("YRES");
        if (this.pBounds == null) {
            this.pBounds = new double[]{north, south, west, east};
        }
        if (this.pRes == null) {
            this.pRes = new double[]{xres, yres};
        }
        double n = this.pBounds[0];
        double s = this.pBounds[1];
        double w = this.pBounds[2];
        double e = this.pBounds[3];
        if (this.pRes != null || this.pRowcol != null) {
            int newRows = 0;
            int newCols = 0;
            if (this.pRowcol != null) {
                newRows = this.pRowcol[0];
                newCols = this.pRowcol[1];
                if (this.pRes == null) {
                    this.pRes = new double[2];
                }
                this.pRes[0] = (e - w) / (double)newCols;
                this.pRes[1] = (n - s) / (double)newRows;
            } else if (this.pRes != null) {
                this.pRowcol = new int[2];
                newRows = (int)Math.round((n - s) / this.pRes[1]);
                newCols = (int)Math.round((e - w) / this.pRes[0]);
            }
            this.pRowcol[0] = newRows;
            this.pRowcol[1] = newCols;
        }
        RegionMap newParams = CoverageUtilities.makeRegionParamsMap(n, s, w, e, this.pRes[0], this.pRes[1], this.pRowcol[1], this.pRowcol[0]);
        CoordinateReferenceSystem crs = this.outRaster.getCoordinateReferenceSystem();
        GridGeometry2D gg = CoverageUtilities.gridGeometryFromRegionParams(newParams, crs);
        this.outRaster = (GridCoverage2D)Operations.DEFAULT.resample((GridCoverage)this.outRaster, crs, (GridGeometry)gg, null);
    }

    private boolean hasBoundsRequest() {
        return this.pNorth != null && this.pSouth != null && this.pWest != null && this.pEast != null;
    }

    private boolean hasRowColsRequest() {
        return this.pRows != null && this.pCols != null;
    }

    private boolean hasResolutionRequest() {
        return this.pXres != null && this.pYres != null;
    }

    public static GridCoverage2D readRaster(String path) throws Exception {
        OmsRasterReader reader = new OmsRasterReader();
        reader.file = path;
        reader.process();
        GridCoverage2D geodata = reader.outRaster;
        return geodata;
    }
}

