/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.shapefile;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.PreferencesHandler;

@Description(value="Utility class for reading shapefiles to geotools featurecollections.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Shapefile, Feature, Vector, Reading")
@Label(value="Vector Reader")
@Name(value="shapefilefeaturereader")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
@UI(value="hide")
public class OmsShapefileFeatureReader
extends HMModel {
    @Description(value="The shapefile.")
    @UI(value="infile_vector")
    @In
    public String file = null;
    @Description(value="The read feature collection.")
    @Out
    public SimpleFeatureCollection geodata = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void readFeatureCollection() throws IOException {
        if (!this.concatOr(this.geodata == null, this.doReset)) {
            return;
        }
        try {
            File shapeFile = new File(this.file);
            this.pm.beginTask("Reading features from shapefile: " + shapeFile.getName(), -1);
            FileDataStore store = FileDataStoreFinder.getDataStore((File)shapeFile);
            if (store instanceof ShapefileDataStore) {
                ShapefileDataStore shpStore = (ShapefileDataStore)store;
                String shpCharset = PreferencesHandler.getShpCharset();
                if (shpCharset != null) {
                    shpStore.setCharset(Charset.forName(shpCharset));
                }
            }
            SimpleFeatureSource featureSource = store.getFeatureSource();
            this.geodata = featureSource.getFeatures();
            store.dispose();
        }
        finally {
            this.pm.done();
        }
    }

    public static SimpleFeatureCollection readShapefile(String path) throws IOException {
        OmsShapefileFeatureReader reader = new OmsShapefileFeatureReader();
        reader.file = path;
        reader.readFeatureCollection();
        return reader.geodata;
    }
}

