/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.timedependent;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.Finalize;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.io.DataIO;
import oms3.io.MemoryTable;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;

@Description(value="Utility class for writing a id2values map to a OMS formatted csv file.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Writing")
@Label(value="HashMap Data Writer")
@Name(value="tsitwriter")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsTimeSeriesIteratorWriter
extends HMModel {
    @Description(value="The csv file to write to.")
    @UI(value="outfile")
    @In
    public String file = null;
    @Description(value="The table name.")
    @In
    public String inTablename = "table";
    @Description(value="The hashmap of ids and values to write.")
    @In
    public HashMap<Integer, double[]> inData;
    @Description(value="The start date. If available time is added as first column.")
    @In
    public String tStart;
    @Description(value="The timestep. If available time is added as first column.")
    @In
    public int tTimestep = -1;
    @Description(value="The novalue to use in the file (default is -9999.0).")
    @In
    public String fileNovalue = "-9999.0";
    private MemoryTable memoryTable;
    private DateTimeFormatter formatter = HMConstants.utcDateFormatterYYYYMMDDHHMM;
    private String formatterPattern = HMConstants.utcDateFormatterYYYYMMDDHHMM_string;
    private DateTime runningDateTime;
    private boolean columnNamesAreSet = false;

    private void ensureOpen() throws IOException {
        if (this.memoryTable == null) {
            this.memoryTable = new MemoryTable();
            this.memoryTable.setName(this.inTablename);
            this.memoryTable.getInfo().put("Created", new DateTime().toString(this.formatter));
            this.memoryTable.getInfo().put("Author", "HortonMachine library");
            if (this.tStart != null && this.tTimestep != -1) {
                this.runningDateTime = this.formatter.parseDateTime(this.tStart);
            }
        }
    }

    @Execute
    public void writeNextLine() throws IOException {
        int index;
        this.ensureOpen();
        ArrayList<Integer> idsList = new ArrayList<Integer>();
        ArrayList<String> columnNamesList = new ArrayList<String>();
        ArrayList<Integer> uniqueIdsList = new ArrayList<Integer>();
        if (!this.columnNamesAreSet) {
            int j;
            Object values;
            Set<Map.Entry<Integer, double[]>> inDataSet = this.inData.entrySet();
            for (Map.Entry<Integer, double[]> inDataEntry : inDataSet) {
                Integer id = inDataEntry.getKey();
                values = inDataEntry.getValue();
                if (((double[])values).length == 1) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("value_");
                    sb.append(id);
                    columnNamesList.add(sb.toString());
                    idsList.add(id);
                    continue;
                }
                for (int i = 0; i < ((double[])values).length; ++i) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("value_");
                    sb.append(id);
                    sb.append("_");
                    sb.append(i);
                    columnNamesList.add(sb.toString());
                    idsList.add(id);
                }
            }
            for (Integer tmpId : idsList) {
                if (uniqueIdsList.contains(tmpId)) continue;
                uniqueIdsList.add(tmpId);
            }
            index = 0;
            if (this.runningDateTime != null) {
                columnNamesList.add(0, "timestamp");
                index = 1;
            }
            String[] columnNames = columnNamesList.toArray(new String[0]);
            this.memoryTable.setColumns(columnNames);
            index = 0;
            if (this.runningDateTime != null) {
                this.memoryTable.getColumnInfo(1).put("ID", "");
                index = 1;
            }
            int k = 0;
            values = idsList.iterator();
            while (values.hasNext()) {
                Integer id = (Integer)values.next();
                this.memoryTable.getColumnInfo(k + 1 + index).put("ID", String.valueOf(id));
                ++k;
            }
            index = 0;
            if (this.runningDateTime != null) {
                this.memoryTable.getColumnInfo(1).put("Type", "Date");
                index = 1;
            }
            for (j = 0; j < idsList.size(); ++j) {
                this.memoryTable.getColumnInfo(j + 1 + index).put("Type", "Double");
            }
            index = 0;
            if (this.runningDateTime != null) {
                this.memoryTable.getColumnInfo(1).put("Format", this.formatterPattern);
                index = 1;
            }
            for (j = 0; j < idsList.size(); ++j) {
                this.memoryTable.getColumnInfo(j + 1 + index).put("Format", "");
            }
        }
        Object[] valuesRow = null;
        index = 0;
        if (this.runningDateTime != null) {
            valuesRow = new Object[columnNamesList.size()];
            valuesRow[0] = this.runningDateTime.toString(this.formatter);
            index = 1;
        } else {
            valuesRow = new Object[columnNamesList.size() - 1];
        }
        for (Integer id : uniqueIdsList) {
            double[] dataArray;
            for (double value : dataArray = this.inData.get(id)) {
                valuesRow[index++] = HMConstants.isNovalue(value) ? this.fileNovalue : String.valueOf(value);
            }
        }
        this.memoryTable.addRow(valuesRow);
        if (this.runningDateTime != null) {
            this.runningDateTime = this.runningDateTime.plusMinutes(this.tTimestep);
        }
    }

    @Finalize
    public void close() throws IOException {
        DataIO.print(this.memoryTable, new PrintWriter(new File(this.file)));
    }
}

