/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.timeseries;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.Finalize;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.io.DataIO;
import oms3.io.MemoryTable;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;

@Description(value="Utility class for writing a set of timestamps and an array of values to an OMS formatted csv file.")
@Documentation(value="OmsTimeSeriesWriter.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Writing")
@Label(value="HashMap Data Writer")
@Name(value="tswriter")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsTimeSeriesWriter
extends HMModel {
    @Description(value="The csv file to write to.")
    @UI(value="outfile")
    @In
    public String file = null;
    @Description(value="The table name.")
    @In
    public String tablename = "table";
    @Description(value="The hashmap of data to write. IMPORTANT: The hashmap is assumed to be sorted.")
    @In
    public HashMap<DateTime, double[]> inData;
    @Description(value="A switch that defines whether to write the timestamps as dates or as intervals of seconds if a date doesn't make sense.")
    @In
    public boolean doDates = true;
    @Description(value="The comma separated list of column names.")
    @In
    public String columns = null;
    @Description(value="A list of lists of metadata that can be attached to the column of the csv file.")
    @In
    public List<List<String>> inMetadata = null;
    private MemoryTable memoryTable;
    private DateTimeFormatter formatter = HMConstants.utcDateFormatterYYYYMMDDHHMM;
    private String formatterPattern = HMConstants.utcDateFormatterYYYYMMDDHHMM_string;

    private void ensureOpen() throws IOException {
        if (this.memoryTable == null) {
            this.memoryTable = new MemoryTable();
            this.memoryTable.setName(this.tablename);
            this.memoryTable.getInfo().put("Created", new DateTime().toString(this.formatter));
            this.memoryTable.getInfo().put("Author", "HortonMachine");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Execute
    public void write() throws IOException {
        Object colNames;
        this.ensureOpen();
        Set<Map.Entry<DateTime, double[]>> entrySet = this.inData.entrySet();
        if (entrySet.isEmpty()) {
            throw new ModelsIllegalargumentException("The data to write are empty.", this, this.pm);
        }
        Map.Entry<DateTime, double[]> firstItem = entrySet.iterator().next();
        int cols = firstItem.getValue().length + 1;
        if (this.columns != null) {
            void var5_8;
            colNames = this.columns.split(",");
            boolean bl = false;
            while (var5_8 < ((String[])colNames).length) {
                colNames[var5_8] = colNames[var5_8].trim();
                ++var5_8;
            }
            this.memoryTable.setColumns((String[])colNames);
        } else {
            void var5_10;
            colNames = new String[cols];
            colNames[0] = "date";
            boolean bl = true;
            while (var5_10 < ((String[])colNames).length) {
                colNames[var5_10] = "value_" + (int)var5_10;
                ++var5_10;
            }
            this.memoryTable.setColumns((String[])colNames);
        }
        if (this.inMetadata != null && this.inMetadata.size() > 0) {
            for (List list : this.inMetadata) {
                Iterator<List<String>> metadataName = (String)list.get(0);
                for (int i = 1; i < list.size(); ++i) {
                    this.memoryTable.getColumnInfo(i).put((String)((Object)metadataName), (String)list.get(i - 1));
                }
            }
        }
        if (this.doDates) {
            boolean bl;
            boolean hasFormat = false;
            boolean bl2 = false;
            if (this.inMetadata != null && this.inMetadata.size() > 0) {
                hasFormat = false;
                for (List list : this.inMetadata) {
                    if (!list.contains("Format")) continue;
                    hasFormat = true;
                    break;
                }
                boolean bl3 = false;
                for (List<String> list : this.inMetadata) {
                    if (!list.contains("Type")) continue;
                    bl = true;
                    break;
                }
            }
            if (!hasFormat) {
                this.memoryTable.getColumnInfo(1).put("Format", this.formatterPattern);
                for (int i3 = 2; i3 <= cols; ++i3) {
                    this.memoryTable.getColumnInfo(i3).put("Format", "");
                }
            }
            if (!bl) {
                this.memoryTable.getColumnInfo(1).put("Type", "Date");
                for (int i4 = 2; i4 <= cols; ++i4) {
                    this.memoryTable.getColumnInfo(i4).put("Type", "");
                }
            }
        }
        for (Map.Entry<DateTime, double[]> entry : entrySet) {
            Object[] valuesRow = new Object[cols];
            DateTime dateTime = entry.getKey();
            if (this.doDates) {
                valuesRow[0] = dateTime.toString(this.formatter);
            } else {
                Interval interval = new Interval((ReadableInstant)firstItem.getKey(), (ReadableInstant)dateTime);
                long dt = interval.toDuration().getStandardSeconds();
                valuesRow[0] = dt;
            }
            double[] valuesArray = entry.getValue();
            for (int j = 0; j < valuesArray.length; ++j) {
                valuesRow[j + 1] = valuesArray[j];
            }
            this.memoryTable.addRow(valuesRow);
        }
    }

    @Finalize
    public void close() throws IOException {
        DataIO.print(this.memoryTable, new PrintWriter(new File(this.file)));
    }
}

