/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.vectorreader;

import java.io.File;
import java.io.IOException;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.hortonmachine.dbs.compat.ASpatialDb;
import org.hortonmachine.dbs.compat.EDb;
import org.hortonmachine.dbs.geopackage.GeopackageCommonDb;
import org.hortonmachine.gears.io.properties.OmsPropertiesFeatureReader;
import org.hortonmachine.gears.io.shapefile.OmsShapefileFeatureReader;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.spatialite.SpatialDbsImportUtils;
import org.opengis.feature.simple.SimpleFeatureType;

@Description(value="Vectors features reader module.")
@Documentation(value="OmsVectorReader.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Shapefile, Feature, Vector, Reading")
@Label(value="Vector Reader")
@Name(value="vectorreader")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsVectorReader
extends HMModel {
    @Description(value="The vector type to read (Supported is: shp, properties).")
    @In
    public String pType = null;
    @Description(value="The vector file to read.")
    @UI(value="infile_vector")
    @In
    public String file = null;
    @Description(value="The read feature collection.")
    @Out
    public SimpleFeatureCollection outVector = null;
    public static final String OMSVECTORREADER_DESCRIPTION = "Vectors features reader module.";
    public static final String OMSVECTORREADER_DOCUMENTATION = "OmsVectorReader.html";
    public static final String OMSVECTORREADER_KEYWORDS = "IO, Shapefile, Feature, Vector, Reading";
    public static final String OMSVECTORREADER_LABEL = "Vector Reader";
    public static final String OMSVECTORREADER_NAME = "vectorreader";
    public static final int OMSVECTORREADER_STATUS = 40;
    public static final String OMSVECTORREADER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSVECTORREADER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSVECTORREADER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSVECTORREADER_P_TYPE_DESCRIPTION = "The vector type to read (Supported is: shp, properties).";
    public static final String OMSVECTORREADER_FILE_DESCRIPTION = "The vector file to read.";
    public static final String OMSVECTORREADER_TABLE_DESCRIPTION = "The table name (where applicable).";
    public static final String OMSVECTORREADER_OUT_VECTOR_DESCRIPTION = "The read feature collection.";

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outVector == null, this.doReset)) {
            return;
        }
        this.checkNull(this.file);
        File vectorFile = new File(this.file);
        String name = vectorFile.getName();
        if (name.toLowerCase().endsWith("shp")) {
            OmsShapefileFeatureReader reader = new OmsShapefileFeatureReader();
            reader.file = vectorFile.getAbsolutePath();
            reader.pm = this.pm;
            reader.readFeatureCollection();
            this.outVector = reader.geodata;
            if (((SimpleFeatureType)this.outVector.getSchema()).getCoordinateReferenceSystem() == null) {
                this.pm.errorMessage("The coordinate reference system could not be defined for: " + reader.file);
            }
        } else if (name.toLowerCase().contains(".gpkg")) {
            if (!name.contains("#")) {
                throw new ModelsIllegalargumentException("The table name needs to be specified in the geopackage path after the #.", this);
            }
            String[] split = this.file.split("#");
            if (split.length == 1 || split[1].trim().length() == 0) {
                throw new ModelsIllegalargumentException("The geopackage contains several tables, the table neame needs to be specified in the path after the #.", this);
            }
            String table = split[1];
            String dbPath = split[0];
            try (GeopackageCommonDb db = (GeopackageCommonDb)EDb.GEOPACKAGE.getSpatialDb();){
                db.open(dbPath);
                db.initSpatialMetadata(null);
                this.outVector = SpatialDbsImportUtils.tableToFeatureFCollection((ASpatialDb)db, table, -1, -1, null);
            }
        } else if (name.toLowerCase().endsWith("properties")) {
            this.outVector = OmsPropertiesFeatureReader.readPropertiesfile(vectorFile.getAbsolutePath());
        } else {
            throw new IOException("Format is currently not supported for file: " + name);
        }
    }

    public static SimpleFeatureCollection readVector(String path) throws Exception {
        SimpleFeatureCollection fc = OmsVectorReader.getFC(path);
        return fc;
    }

    private static SimpleFeatureCollection getFC(String path) throws Exception {
        OmsVectorReader reader = new OmsVectorReader();
        reader.file = path;
        reader.process();
        SimpleFeatureCollection fc = reader.outVector;
        return fc;
    }

    public static ReferencedEnvelope readEnvelope(String filePath) throws Exception {
        File shapeFile = new File(filePath);
        FileDataStore store = FileDataStoreFinder.getDataStore((File)shapeFile);
        SimpleFeatureSource featureSource = store.getFeatureSource();
        return featureSource.getBounds();
    }
}

