/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.io.vectorwriter;

import java.io.File;
import java.io.IOException;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.hortonmachine.dbs.compat.ASpatialDb;
import org.hortonmachine.dbs.compat.EDb;
import org.hortonmachine.dbs.geopackage.GeopackageCommonDb;
import org.hortonmachine.gears.io.shapefile.OmsShapefileFeatureWriter;
import org.hortonmachine.gears.libs.exceptions.ModelsIOException;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.spatialite.SpatialDbsImportUtils;
import org.hortonmachine.gears.utils.CrsUtilities;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Vectors features writer to file module.")
@Documentation(value="OmsVectorWriter.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Shapefile, Feature, Vector, Writing")
@Label(value="Vector Writer")
@Name(value="vectorwriter")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsVectorWriter
extends HMModel {
    @Description(value="The read feature collection.")
    @In
    public SimpleFeatureCollection inVector = null;
    @Description(value="The vector type to write (Supported is: shp).")
    @In
    public String pType = null;
    @Description(value="Flag to define if existing data should be overwritten.")
    @In
    public boolean doOverwrite = true;
    @Description(value="The vector file to write.")
    @UI(value="infile_vector")
    @In
    public String file = null;
    public static final String OMSVECTORWRITER_DESCRIPTION = "Vectors features writer to file module.";
    public static final String OMSVECTORWRITER_DOCUMENTATION = "OmsVectorWriter.html";
    public static final String OMSVECTORWRITER_KEYWORDS = "IO, Shapefile, Feature, Vector, Writing";
    public static final String OMSVECTORWRITER_LABEL = "Vector Writer";
    public static final String OMSVECTORWRITER_NAME = "vectorwriter";
    public static final int OMSVECTORWRITER_STATUS = 40;
    public static final String OMSVECTORWRITER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSVECTORWRITER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSVECTORWRITER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSVECTORWRITER_IN_VECTOR_DESCRIPTION = "The read feature collection.";
    public static final String OMSVECTORWRITER_P_TYPE_DESCRIPTION = "The vector type to write (Supported is: shp).";
    public static final String OMSVECTORWRITER_P_OVERWRITE_DESCRIPTION = "Flag to define if existing data should be overwritten.";
    public static final String OMSVECTORWRITER_TABLE_DESCRIPTION = "The table to write to (where applicable).";
    public static final String OMSVECTORWRITER_FILE_DESCRIPTION = "The vector file to write.";

    @Execute
    public void process() throws Exception {
        this.checkNull(this.file);
        File vectorFile = new File(this.file);
        if (this.inVector.size() == 0) {
            this.pm.message("Warning, not writing an empty vector to file: " + vectorFile.getName());
            return;
        }
        String name = vectorFile.getName();
        if (name.toLowerCase().endsWith("shp") || this.pType != null && this.pType.equals("shp")) {
            if (vectorFile.exists() && !this.doOverwrite) {
                throw new ModelsIOException("Overwriting is disabled. First delete the data.", this);
            }
            OmsShapefileFeatureWriter.writeShapefile(vectorFile.getAbsolutePath(), this.inVector, this.pm);
        } else if (name.toLowerCase().contains(".gpkg")) {
            if (!name.contains("#")) {
                throw new ModelsIllegalargumentException("The table name needs to be specified in the geopackage path after the #.", this);
            }
            String[] split = this.file.split("#");
            if (split.length == 1 || split[1].trim().length() == 0) {
                throw new ModelsIllegalargumentException("The geopackage contains several tables, the table neame needs to be specified in the path after the #.", this);
            }
            String table = split[1];
            String dbPath = split[0];
            try (GeopackageCommonDb db = (GeopackageCommonDb)EDb.GEOPACKAGE.getSpatialDb();){
                boolean existed = db.open(dbPath);
                db.initSpatialMetadata(null);
                CoordinateReferenceSystem crs = this.inVector.getBounds().getCoordinateReferenceSystem();
                int srid = CrsUtilities.getSrid(crs);
                db.addCRS("EPSG", srid, crs.toWKT());
                if (db.hasTable(table) && !this.doOverwrite) {
                    throw new ModelsIOException("Overwriting is disabled. First delete the data.", this);
                }
                if (!db.hasTable(table) || !existed) {
                    SpatialDbsImportUtils.createTableFromSchema((ASpatialDb)db, (SimpleFeatureType)this.inVector.getSchema(), table, null, false);
                }
                SpatialDbsImportUtils.importFeatureCollection((ASpatialDb)db, this.inVector, table, -1, false, this.pm);
            }
        } else {
            throw new IOException("Format is currently not supported for file: " + name);
        }
    }

    public static void writeVector(String path, SimpleFeatureCollection featureCollection) throws Exception {
        OmsVectorWriter writer = new OmsVectorWriter();
        writer.file = path;
        writer.inVector = featureCollection;
        writer.process();
    }
}

