/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.libs.modules;

public enum Direction {
    E(1, 0, 1, 5),
    EN(1, -1, 2, 6),
    N(0, -1, 3, 7),
    NW(-1, -1, 4, 8),
    W(-1, 0, 5, 1),
    WS(-1, 1, 6, 2),
    S(0, 1, 7, 3),
    SE(1, 1, 8, 4);

    private static final Direction[] orderedDirs;
    public int col;
    public int row;
    private int exiting;
    private int entering;
    private static Direction[][] dirs;

    private Direction(int col, int row, int exiting, int entering) {
        this.col = col;
        this.row = row;
        this.exiting = exiting;
        this.entering = entering;
    }

    public int getFlow() {
        return this.exiting;
    }

    public int getEnteringFlow() {
        return this.entering;
    }

    public static int getOutletValue() {
        return 10;
    }

    public static Direction getDir(int col, int row) {
        if (col < -1 || col > 1 || row < -1 || col > 1) {
            return null;
        }
        return dirs[row + 1][col + 1];
    }

    public static Direction[] getOrderedDirs() {
        return orderedDirs;
    }

    public static Direction forFlow(int flowValue) {
        switch (flowValue) {
            case 1: {
                return E;
            }
            case 2: {
                return EN;
            }
            case 3: {
                return N;
            }
            case 4: {
                return NW;
            }
            case 5: {
                return W;
            }
            case 6: {
                return WS;
            }
            case 7: {
                return S;
            }
            case 8: {
                return SE;
            }
            case 10: {
                return null;
            }
        }
        throw new IllegalArgumentException("Can't understand flow direction: " + flowValue);
    }

    public double getDistance(double xRes, double yRes) {
        switch (this) {
            case E: 
            case W: {
                return xRes;
            }
            case N: 
            case S: {
                return yRes;
            }
            case EN: 
            case NW: 
            case WS: 
            case SE: {
                return Math.sqrt(xRes * xRes + yRes * yRes);
            }
        }
        throw new IllegalArgumentException();
    }

    static {
        orderedDirs = new Direction[]{E, EN, N, NW, W, WS, S, SE};
        dirs = new Direction[][]{{NW, N, EN}, {W, null, E}, {WS, S, SE}};
    }
}

