/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.libs.modules;

import java.util.ArrayList;
import java.util.List;
import javax.media.jai.iterator.RandomIter;
import org.hortonmachine.gears.libs.modules.Direction;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.Node;
import org.hortonmachine.gears.utils.math.NumericsUtilities;

public class FlowNode
extends Node {
    public static final int OUTLET = 10;
    public static final int NETVALUE = 2;
    public final int flow;
    private boolean isMarkedAsOutlet = false;
    private boolean isHeadingOutside = false;
    private boolean wasHeadingOutsideChecked = false;
    private int eFlow;
    private int enFlow;
    private int nFlow;
    private int nwFlow;
    private int wFlow;
    private int wsFlow;
    private int sFlow;
    private int seFlow;
    private List<FlowNode> enteringNodes;
    private double flowD;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowNode(RandomIter flowIter, int cols, int rows, int col, int row, Integer novalue) {
        super(flowIter, cols, rows, col, row, novalue.doubleValue());
        if (!this.isInRaster(col, row)) {
            this.isValid = false;
            this.flow = this.intNovalue;
        } else {
            RandomIter randomIter = this.gridIter;
            synchronized (randomIter) {
                this.flowD = this.gridIter.getSampleDouble(col, row, 0);
            }
            this.isValid = !HMConstants.isNovalue(this.flowD);
            this.flow = (int)this.flowD;
        }
        if (this.flow == 10) {
            this.isMarkedAsOutlet = true;
        }
        int index = -1;
        for (int c = -1; c <= 1; ++c) {
            for (int r = -1; r <= 1; ++r) {
                ++index;
                if (c == 0 && r == 0) continue;
                int newC = col + c;
                int newR = row + r;
                int tmp = this.intNovalue;
                if (!this.isInRaster(newC, newR)) {
                    this.touchesBound = true;
                } else {
                    RandomIter randomIter = this.gridIter;
                    synchronized (randomIter) {
                        double tmpD = this.gridIter.getSampleDouble(newC, newR, 0);
                        if (!HMConstants.isNovalue(tmpD)) {
                            tmp = (int)tmpD;
                        }
                    }
                }
                switch (index) {
                    case 0: {
                        this.nwFlow = tmp;
                        break;
                    }
                    case 1: {
                        this.wFlow = tmp;
                        break;
                    }
                    case 2: {
                        this.wsFlow = tmp;
                        break;
                    }
                    case 3: {
                        this.nFlow = tmp;
                        break;
                    }
                    case 4: {
                        throw new RuntimeException();
                    }
                    case 5: {
                        this.sFlow = tmp;
                        break;
                    }
                    case 6: {
                        this.enFlow = tmp;
                        break;
                    }
                    case 7: {
                        this.eFlow = tmp;
                        break;
                    }
                    case 8: {
                        this.seFlow = tmp;
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                if (!HMConstants.isNovalue(tmp)) continue;
                this.touchesBound = true;
            }
        }
    }

    public String toString() {
        return "FlowNode [\n\tcol=" + this.col + ", \n\trow=" + this.row + ", \n\tflow=" + this.flow + "(" + this.flowD + "), \n\tisValid=" + this.isValid() + ", \n\ttouchesBounds=" + this.touchesBound + ", \n\tisSource=" + this.isSource() + "\n]";
    }

    public boolean isMarkedAsOutlet() {
        return this.isMarkedAsOutlet;
    }

    public boolean isHeadingOutside() {
        if (!this.wasHeadingOutsideChecked) {
            FlowNode goDownstream;
            this.isHeadingOutside = !this.isValid ? false : (this.touchesBound ? (goDownstream = this.goDownstream()) == null || !goDownstream.isValid() : false);
            this.wasHeadingOutsideChecked = true;
        }
        return this.isHeadingOutside;
    }

    public boolean isSource() {
        if (!this.isValid()) {
            return false;
        }
        List<FlowNode> enteringNodes = this.getEnteringNodes();
        return enteringNodes.size() == 0;
    }

    public int getFlowAt(Direction direction) {
        switch (direction) {
            case E: {
                return this.eFlow;
            }
            case W: {
                return this.wFlow;
            }
            case N: {
                return this.nFlow;
            }
            case S: {
                return this.sFlow;
            }
            case EN: {
                return this.enFlow;
            }
            case NW: {
                return this.nwFlow;
            }
            case WS: {
                return this.wsFlow;
            }
            case SE: {
                return this.seFlow;
            }
        }
        throw new IllegalArgumentException();
    }

    public FlowNode goDownstream() {
        Direction direction;
        if (this.isValid && (direction = Direction.forFlow(this.flow)) != null) {
            FlowNode nextNode = new FlowNode(this.gridIter, this.cols, this.rows, this.col + direction.col, this.row + direction.row, this.intNovalue);
            if (nextNode.isValid) {
                return nextNode;
            }
        }
        return null;
    }

    public List<FlowNode> getEnteringNodes() {
        if (this.enteringNodes == null) {
            Direction[] orderedDirs;
            this.enteringNodes = new ArrayList<FlowNode>();
            block10: for (Direction direction : orderedDirs = Direction.getOrderedDirs()) {
                switch (direction) {
                    case E: {
                        if (this.eFlow != Direction.E.getEnteringFlow()) continue block10;
                        int newCol = this.col + direction.col;
                        int newRow = this.row + direction.row;
                        FlowNode node = new FlowNode(this.gridIter, this.cols, this.rows, newCol, newRow, this.intNovalue);
                        this.enteringNodes.add(node);
                        continue block10;
                    }
                    case N: {
                        if (this.nFlow != Direction.N.getEnteringFlow()) continue block10;
                        int newCol = this.col + direction.col;
                        int newRow = this.row + direction.row;
                        FlowNode node = new FlowNode(this.gridIter, this.cols, this.rows, newCol, newRow, this.intNovalue);
                        this.enteringNodes.add(node);
                        continue block10;
                    }
                    case W: {
                        if (this.wFlow != Direction.W.getEnteringFlow()) continue block10;
                        int newCol = this.col + direction.col;
                        int newRow = this.row + direction.row;
                        FlowNode node = new FlowNode(this.gridIter, this.cols, this.rows, newCol, newRow, this.intNovalue);
                        this.enteringNodes.add(node);
                        continue block10;
                    }
                    case S: {
                        if (this.sFlow != Direction.S.getEnteringFlow()) continue block10;
                        int newCol = this.col + direction.col;
                        int newRow = this.row + direction.row;
                        FlowNode node = new FlowNode(this.gridIter, this.cols, this.rows, newCol, newRow, this.intNovalue);
                        this.enteringNodes.add(node);
                        continue block10;
                    }
                    case EN: {
                        if (this.enFlow != Direction.EN.getEnteringFlow()) continue block10;
                        int newCol = this.col + direction.col;
                        int newRow = this.row + direction.row;
                        FlowNode node = new FlowNode(this.gridIter, this.cols, this.rows, newCol, newRow, this.intNovalue);
                        this.enteringNodes.add(node);
                        continue block10;
                    }
                    case NW: {
                        if (this.nwFlow != Direction.NW.getEnteringFlow()) continue block10;
                        int newCol = this.col + direction.col;
                        int newRow = this.row + direction.row;
                        FlowNode node = new FlowNode(this.gridIter, this.cols, this.rows, newCol, newRow, this.intNovalue);
                        this.enteringNodes.add(node);
                        continue block10;
                    }
                    case WS: {
                        if (this.wsFlow != Direction.WS.getEnteringFlow()) continue block10;
                        int newCol = this.col + direction.col;
                        int newRow = this.row + direction.row;
                        FlowNode node = new FlowNode(this.gridIter, this.cols, this.rows, newCol, newRow, this.intNovalue);
                        this.enteringNodes.add(node);
                        continue block10;
                    }
                    case SE: {
                        if (this.seFlow != Direction.SE.getEnteringFlow()) continue block10;
                        int newCol = this.col + direction.col;
                        int newRow = this.row + direction.row;
                        FlowNode node = new FlowNode(this.gridIter, this.cols, this.rows, newCol, newRow, this.intNovalue);
                        this.enteringNodes.add(node);
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
        }
        return this.enteringNodes;
    }

    public FlowNode getUpstreamTcaBased(RandomIter tcaIter, RandomIter hacklengthIter) {
        Direction[] orderedDirs = Direction.getOrderedDirs();
        double maxTca = Double.NEGATIVE_INFINITY;
        double maxHacklength = Double.NEGATIVE_INFINITY;
        int maxCol = 0;
        int maxRow = 0;
        boolean gotOne = false;
        for (Direction direction : orderedDirs) {
            int flowValue;
            int newCol = 0;
            int newRow = 0;
            switch (direction) {
                case E: {
                    if (this.eFlow != Direction.E.getEnteringFlow()) break;
                    newCol = this.col + direction.col;
                    newRow = this.row + direction.row;
                    gotOne = true;
                    break;
                }
                case N: {
                    if (this.nFlow != Direction.N.getEnteringFlow()) break;
                    newCol = this.col + direction.col;
                    newRow = this.row + direction.row;
                    gotOne = true;
                    break;
                }
                case W: {
                    if (this.wFlow != Direction.W.getEnteringFlow()) break;
                    newCol = this.col + direction.col;
                    newRow = this.row + direction.row;
                    gotOne = true;
                    break;
                }
                case S: {
                    if (this.sFlow != Direction.S.getEnteringFlow()) break;
                    newCol = this.col + direction.col;
                    newRow = this.row + direction.row;
                    gotOne = true;
                    break;
                }
                case EN: {
                    if (this.enFlow != Direction.EN.getEnteringFlow()) break;
                    newCol = this.col + direction.col;
                    newRow = this.row + direction.row;
                    gotOne = true;
                    break;
                }
                case NW: {
                    if (this.nwFlow != Direction.NW.getEnteringFlow()) break;
                    newCol = this.col + direction.col;
                    newRow = this.row + direction.row;
                    gotOne = true;
                    break;
                }
                case WS: {
                    if (this.wsFlow != Direction.WS.getEnteringFlow()) break;
                    newCol = this.col + direction.col;
                    newRow = this.row + direction.row;
                    gotOne = true;
                    break;
                }
                case SE: {
                    if (this.seFlow != Direction.SE.getEnteringFlow()) break;
                    newCol = this.col + direction.col;
                    newRow = this.row + direction.row;
                    gotOne = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (!this.isInRaster(newCol, newRow) || HMConstants.isNovalue(flowValue = this.gridIter.getSample(newCol, newRow, 0))) continue;
            int tcaValue = tcaIter.getSample(newCol, newRow, 0);
            double hacklengthValue = 0.0;
            if (hacklengthIter != null) {
                hacklengthValue = tcaIter.getSampleDouble(newCol, newRow, 0);
            }
            if (NumericsUtilities.dEq(tcaValue, maxTca) && hacklengthIter != null) {
                if (!(hacklengthValue > maxHacklength)) continue;
                maxTca = tcaValue;
                maxCol = newCol;
                maxRow = newRow;
                maxHacklength = hacklengthValue;
                continue;
            }
            if (!((double)tcaValue > maxTca)) continue;
            maxTca = tcaValue;
            maxCol = newCol;
            maxRow = newRow;
            maxHacklength = hacklengthValue;
        }
        if (!gotOne) {
            return null;
        }
        FlowNode node = new FlowNode(this.gridIter, this.cols, this.rows, maxCol, maxRow, this.intNovalue);
        return node;
    }

    private boolean isInRaster(int col, int row) {
        return col >= 0 && col < this.cols && row >= 0 && row < this.rows;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.col;
        long temp = Double.doubleToLongBits(this.flowD);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.row;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlowNode other = (FlowNode)obj;
        if (this.col != other.col || this.row != other.row) {
            return false;
        }
        return Double.doubleToLongBits(this.flowD) == Double.doubleToLongBits(other.flowD);
    }
}

