/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.libs.modules;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.WritableRandomIter;
import org.hortonmachine.gears.libs.modules.Direction;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.Node;
import org.hortonmachine.gears.utils.math.NumericsUtilities;

public class GridNode
extends Node {
    public double elevation;
    public double xRes;
    public double yRes;
    private boolean isPit = false;
    private boolean isOutlet = false;
    private boolean isFlat = false;
    private double eElev;
    private double enElev;
    private double nElev;
    private double nwElev;
    private double wElev;
    private double wsElev;
    private double sElev;
    private double seElev;
    private double surroundingMin;
    private static DecimalFormat f = new DecimalFormat("0.0000000");
    private List<GridNode> nodes;

    public GridNode(RandomIter elevationIter, int cols, int rows, double xRes, double yRes, int col, int row, Double novalue) {
        super(elevationIter, cols, rows, col, row, novalue);
        this.xRes = xRes;
        this.yRes = yRes;
        if (this.isInRaster(col, row)) {
            this.elevation = this.gridIter.getSampleDouble(col, row, 0);
            this.isValid = !HMConstants.isNovalue(this.elevation, this.doubleNovalue);
        } else {
            this.elevation = this.doubleNovalue;
            this.isValid = false;
        }
        this.surroundingMin = Double.POSITIVE_INFINITY;
        int index = -1;
        for (int c = -1; c <= 1; ++c) {
            for (int r = -1; r <= 1; ++r) {
                ++index;
                if (c == 0 && r == 0) continue;
                int newC = col + c;
                int newR = row + r;
                double tmp = this.doubleNovalue;
                if (!this.isInRaster(newC, newR)) {
                    this.touchesBound = true;
                } else {
                    try {
                        tmp = this.gridIter.getSampleDouble(newC, newR, 0);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        this.touchesBound = true;
                    }
                }
                switch (index) {
                    case 0: {
                        this.nwElev = tmp;
                        break;
                    }
                    case 1: {
                        this.wElev = tmp;
                        break;
                    }
                    case 2: {
                        this.wsElev = tmp;
                        break;
                    }
                    case 3: {
                        this.nElev = tmp;
                        break;
                    }
                    case 4: {
                        throw new RuntimeException();
                    }
                    case 5: {
                        this.sElev = tmp;
                        break;
                    }
                    case 6: {
                        this.enElev = tmp;
                        break;
                    }
                    case 7: {
                        this.eElev = tmp;
                        break;
                    }
                    case 8: {
                        this.seElev = tmp;
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                if (HMConstants.isNovalue(tmp, this.doubleNovalue)) {
                    this.touchesNovalue = true;
                    continue;
                }
                if (tmp < this.surroundingMin && tmp != this.elevation) {
                    this.surroundingMin = tmp;
                }
                if (tmp != this.elevation) continue;
                this.isFlat = true;
            }
        }
        if (!this.touchesBound && !this.touchesNovalue && this.isValid && this.elevation < this.surroundingMin) {
            this.isPit = true;
        }
    }

    public String toString() {
        return "GridNode [\n\tcol=" + this.col + ", \n\trow=" + this.row + ", \n\televation=" + this.elevation + ", \n\tisValid=" + this.isValid + ", \n\tisPit=" + this.isPit + ", \n\tisFlat=" + this.isFlat + ", \n\ttouchesNovalue=" + this.touchesNovalue + ", \n\ttouchesBounds=" + this.touchesBound + "\n-----------------------------------\n| " + f.format(this.nwElev) + " | " + f.format(this.nElev) + " | " + f.format(this.enElev) + " |\n-----------------------------------\n| " + f.format(this.wElev) + " | " + f.format(this.elevation) + " | " + f.format(this.eElev) + " |\n-----------------------------------\n| " + f.format(this.wsElev) + " | " + f.format(this.sElev) + " | " + f.format(this.seElev) + " |\n-----------------------------------\n]";
    }

    @Override
    public void setFloatValueInMap(WritableRandomIter map, float value) {
        if (map == null) {
            return;
        }
        try {
            this.elevation = value;
            map.setSample(this.col, this.row, 0, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setDoubleValueInMap(WritableRandomIter map, double value) {
        if (map == null) {
            return;
        }
        try {
            this.elevation = value;
            map.setSample(this.col, this.row, 0, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isOutlet() {
        return this.isOutlet;
    }

    public boolean isPit() {
        return this.isPit;
    }

    public boolean isPitFor(List<GridNode> existingConnectedNodes) {
        if (!this.isValid || this.touchesBound || this.touchesNovalue) {
            return false;
        }
        boolean isPitFor = false;
        double min = Double.POSITIVE_INFINITY;
        for (GridNode checkNode : existingConnectedNodes) {
            if (checkNode == null || !checkNode.isValid || !(min > checkNode.elevation)) continue;
            min = checkNode.elevation;
        }
        if (this.elevation <= min) {
            isPitFor = true;
        }
        return isPitFor;
    }

    public double getSurroundingMin() {
        return this.surroundingMin;
    }

    public double[][] getWindow(int size, boolean doCircular) {
        if (size % 2 == 0) {
            ++size;
        }
        double[][] window = new double[size][size];
        int delta = (size - 1) / 2;
        if (!doCircular) {
            for (int c = -delta; c <= delta; ++c) {
                int tmpCol = this.col + c;
                for (int r = -delta; r <= delta; ++r) {
                    int tmpRow = this.row + r;
                    GridNode n = new GridNode(this.gridIter, this.cols, this.rows, this.xRes, this.yRes, tmpCol, tmpRow, this.doubleNovalue);
                    window[r + delta][c + delta] = n.elevation;
                }
            }
        } else {
            double radius = delta;
            for (int c = -delta; c <= delta; ++c) {
                int tmpCol = this.col + c;
                for (int r = -delta; r <= delta; ++r) {
                    int tmpRow = this.row + r;
                    double distance = Math.sqrt(c * c + r * r);
                    if (distance <= radius) {
                        GridNode n = new GridNode(this.gridIter, this.cols, this.rows, this.xRes, this.yRes, tmpCol, tmpRow, this.doubleNovalue);
                        window[r + delta][c + delta] = n.elevation;
                        continue;
                    }
                    window[r + delta][c + delta] = this.doubleNovalue;
                }
            }
        }
        return window;
    }

    public List<GridNode> getWindow(int size) {
        if (size % 2 == 0) {
            ++size;
        }
        ArrayList<GridNode> windowNodes = new ArrayList<GridNode>(size * size);
        int delta = (size - 1) / 2;
        for (int c = -delta; c <= delta; ++c) {
            int tmpCol = this.col + c;
            for (int r = -delta; r <= delta; ++r) {
                int tmpRow = this.row + r;
                GridNode n = new GridNode(this.gridIter, this.cols, this.rows, this.xRes, this.yRes, tmpCol, tmpRow, this.doubleNovalue);
                windowNodes.add(n);
            }
        }
        return windowNodes;
    }

    public double getElevationAt(Direction direction) {
        switch (direction) {
            case E: {
                return this.eElev;
            }
            case W: {
                return this.wElev;
            }
            case N: {
                return this.nElev;
            }
            case S: {
                return this.sElev;
            }
            case EN: {
                return this.enElev;
            }
            case NW: {
                return this.nwElev;
            }
            case WS: {
                return this.wsElev;
            }
            case SE: {
                return this.seElev;
            }
        }
        throw new IllegalArgumentException();
    }

    public GridNode goDownstreamSP() {
        Direction[] orderedDirs = Direction.getOrderedDirs();
        double maxSlope = Double.NEGATIVE_INFINITY;
        GridNode nextNode = null;
        for (Direction direction : orderedDirs) {
            double slopeTo;
            GridNode node;
            int newCol = this.col + direction.col;
            int newRow = this.row + direction.row;
            if (!this.isInRaster(newCol, newRow) || !(node = new GridNode(this.gridIter, this.cols, this.rows, this.xRes, this.yRes, newCol, newRow, this.doubleNovalue)).isValid() || !((slopeTo = this.getSlopeTo(node)) > 0.0) || !(slopeTo > maxSlope)) continue;
            nextNode = node;
            maxSlope = slopeTo;
        }
        if (nextNode == null && !this.isPit) {
            this.isOutlet = true;
        }
        return nextNode;
    }

    public int getFlow() {
        GridNode nextDown = this.goDownstreamSP();
        if (nextDown == null) {
            return -9999;
        }
        int dcol = nextDown.col - this.col;
        int drow = nextDown.row - this.row;
        Direction dir = Direction.getDir(dcol, drow);
        return dir.getFlow();
    }

    public List<GridNode> getSurroundingNodes() {
        ArrayList<GridNode> nodes = new ArrayList<GridNode>();
        Direction[] orderedDirs = Direction.getOrderedDirs();
        for (int i = 0; i < orderedDirs.length; ++i) {
            Direction direction = orderedDirs[i];
            int newCol = this.col + direction.col;
            int newRow = this.row + direction.row;
            if (this.isInRaster(newCol, newRow)) {
                GridNode node = new GridNode(this.gridIter, this.cols, this.rows, this.xRes, this.yRes, newCol, newRow, this.doubleNovalue);
                if (node.isValid()) {
                    nodes.add(node);
                    continue;
                }
                nodes.add(null);
                continue;
            }
            nodes.add(null);
        }
        return nodes;
    }

    public GridNode getNodeAt(Direction direction) {
        int newCol = this.col + direction.col;
        int newRow = this.row + direction.row;
        GridNode node = new GridNode(this.gridIter, this.cols, this.rows, this.xRes, this.yRes, newCol, newRow, this.doubleNovalue);
        return node;
    }

    public Direction isNeighborOf(GridNode otherNode) {
        Direction[] orderedDirs = Direction.getOrderedDirs();
        for (int i = 0; i < orderedDirs.length; ++i) {
            Direction direction = orderedDirs[i];
            int newCol = this.col + direction.col;
            int newRow = this.row + direction.row;
            if (otherNode.col != newCol || otherNode.row != newRow) continue;
            return direction;
        }
        return null;
    }

    public Direction isSameValueNeighborOf(GridNode otherNode) {
        Direction direction = this.isNeighborOf(otherNode);
        if (direction != null && NumericsUtilities.dEq(this.elevation, otherNode.elevation)) {
            return direction;
        }
        return null;
    }

    public List<GridNode> getValidSurroundingNodes() {
        if (this.nodes == null) {
            this.nodes = new ArrayList<GridNode>();
            Direction[] orderedDirs = Direction.getOrderedDirs();
            for (int i = 0; i < orderedDirs.length; ++i) {
                GridNode node;
                Direction direction = orderedDirs[i];
                int newCol = this.col + direction.col;
                int newRow = this.row + direction.row;
                if (!this.isInRaster(newCol, newRow) || !(node = new GridNode(this.gridIter, this.cols, this.rows, this.xRes, this.yRes, newCol, newRow, this.doubleNovalue)).isValid()) continue;
                this.nodes.add(node);
            }
        }
        return this.nodes;
    }

    public List<GridNode> getEnteringNodesSP() {
        ArrayList<GridNode> nodes = new ArrayList<GridNode>();
        List<GridNode> surroundingNodes = this.getSurroundingNodes();
        for (GridNode flowNode : surroundingNodes) {
            GridNode downstream;
            if (flowNode == null || !(downstream = flowNode.goDownstreamSP()).isValid() || !this.equals(downstream)) continue;
            nodes.add(flowNode);
        }
        return nodes;
    }

    public List<GridNode> getNonEnteringNodesSP() {
        ArrayList<GridNode> nodes = new ArrayList<GridNode>();
        List<GridNode> surroundingNodes = this.getSurroundingNodes();
        for (GridNode flowNode : surroundingNodes) {
            GridNode downstream;
            if (flowNode == null || (downstream = flowNode.goDownstreamSP()).isValid() && this.equals(downstream)) continue;
            nodes.add(flowNode);
        }
        return nodes;
    }

    private boolean isInRaster(int col, int row) {
        return col >= 0 && col < this.cols && row >= 0 && row < this.rows;
    }

    public double getSlopeTo(GridNode node) {
        double slope = (this.elevation - node.elevation) / this.getDistance(node);
        return slope;
    }

    public double getDistance(GridNode node) {
        return Math.sqrt(Math.pow((double)(node.col - this.col) * this.xRes, 2.0) + Math.pow((double)(node.row - this.row) * this.yRes, 2.0));
    }

    public double getEastElev() {
        return this.eElev;
    }

    public double getENElev() {
        return this.enElev;
    }

    public double getNorthElev() {
        return this.nElev;
    }

    public double getNWElev() {
        return this.nwElev;
    }

    public double getWestElev() {
        return this.wElev;
    }

    public double getWSElev() {
        return this.wsElev;
    }

    public double getSouthElev() {
        return this.sElev;
    }

    public double getSEElev() {
        return this.seElev;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.col;
        long temp = Double.doubleToLongBits(this.elevation);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.row;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GridNode other = (GridNode)obj;
        if (this.col != other.col || this.row != other.row) {
            return false;
        }
        return Double.doubleToLongBits(this.elevation) == Double.doubleToLongBits(other.elevation);
    }

    public boolean isFlat() {
        return this.isFlat;
    }
}

