/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.libs.modules;

import java.io.File;
import java.text.DecimalFormat;
import javax.swing.filechooser.FileFilter;
import org.geotools.coverage.grid.GridCoverage2D;
import org.hortonmachine.dbs.compat.EDb;
import org.hortonmachine.gears.libs.modules.HMFileFilter;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class HMConstants {
    public static final double doubleNovalue = -9999.0;
    public static final float floatNovalue = -9999.0f;
    public static final int intNovalue = -9999;
    public static final short shortNovalue = -9999;
    public static String dateTimeFormatterYYYYMMDDHHMMSScompact_string = "yyyyMMddHHmmss";
    public static DateTimeFormatter dateTimeFormatterYYYYMMDDHHMMSScompact = DateTimeFormat.forPattern((String)dateTimeFormatterYYYYMMDDHHMMSScompact_string);
    public static String dateTimeFormatterYYYYMMDDHHMMSS_string = "yyyy-MM-dd HH:mm:ss";
    public static DateTimeFormatter dateTimeFormatterYYYYMMDDHHMMSS = DateTimeFormat.forPattern((String)dateTimeFormatterYYYYMMDDHHMMSS_string);
    public static String dateTimeFormatterYYYYMMDDHHMM_string = "yyyy-MM-dd HH:mm";
    public static DateTimeFormatter dateTimeFormatterYYYYMMDDHHMM = DateTimeFormat.forPattern((String)dateTimeFormatterYYYYMMDDHHMM_string);
    public static String utcDateFormatterYYYYMMDDHHMMSS_string = "yyyy-MM-dd HH:mm:ss";
    public static DateTimeFormatter utcDateFormatterYYYYMMDDHHMMSS = DateTimeFormat.forPattern((String)utcDateFormatterYYYYMMDDHHMMSS_string).withZone(DateTimeZone.UTC);
    public static String utcDateFormatterYYYYMMDDHHMM_string = "yyyy-MM-dd HH:mm";
    public static DateTimeFormatter utcDateFormatterYYYYMMDDHHMM = DateTimeFormat.forPattern((String)utcDateFormatterYYYYMMDDHHMM_string).withZone(DateTimeZone.UTC);
    public static DecimalFormat DEGREE6_FORMATTER = new DecimalFormat("###.######");
    public static int TEMPERATURE = 0;
    public static int PRESSURE = 1;
    public static int HUMIDITY = 2;
    public static int WIND = 3;
    public static int DTDAY = 4;
    public static int DTMONTH = 5;
    public static final double omega = 0.261799388;
    public static final double tk = 273.15;
    public static final double ka = 0.41;
    public static final double Tf = 0.0;
    public static final double Isc = 1367.0;
    public static final double rho_w = 1000.0;
    public static final double rho_i = 917.0;
    public static final double Lf = 333700.0;
    public static final double Lv = 2834000.0;
    public static final double C_liq = 4188.0;
    public static final double C_ice = 2117.27;
    public static final double GAMMA = 0.006509;
    public static final double sigma = 5.67E-8;
    public static final String AIG = "adf";
    public static final String ESRIGRID = "asc";
    public static final String PNG = "png";
    public static final String JPG = "jpg";
    public static final String JPEG = "jpeg";
    public static final String GEOTIFF = "tiff";
    public static final String GEOTIF = "tif";
    public static final String GRASS = "grass";
    public static final String SHP = "shp";
    public static final String GPKG = "gpkg";
    public static final String LAS = "las";
    public static final String LAZ = "laz";
    public static final String DB_TABLE_PATH_SEPARATOR = "#";
    public static final String[] SUPPORTED_VECTOR_EXTENSIONS = new String[]{"shp", "gpkg"};
    public static final String[] SUPPORTED_LIDAR_EXTENSIONS = new String[]{"las"};
    public static final String[] SUPPORTED_RASTER_EXTENSIONS = new String[]{"tiff", "tif", "asc", "gpkg"};
    public static final String[] SUPPORTED_DB_EXTENSIONS = new String[]{EDb.SPATIALITE.getExtension(), EDb.H2GIS.getExtension(), "gpap", EDb.GEOPACKAGE.getExtension()};
    public static final String OTHER = "Others";
    public static final String MATRIXREADER = "Matrix Reader";
    public static final String GENERICREADER = "Generic Reader";
    public static final String GENERICWRITER = "Generic Writer";
    public static final String HASHMAP_READER = "HashMap Data Reader";
    public static final String HASHMAP_WRITER = "HashMap Data Writer";
    public static final String LIST_READER = "List Data Reader";
    public static final String LIST_WRITER = "List Data Writer";
    public static final String RASTERREADER = "Raster Reader";
    public static final String GRIDGEOMETRYREADER = "Grid Geometry Reader";
    public static final String RASTERWRITER = "Raster Writer";
    public static final String FEATUREREADER = "Vector Reader";
    public static final String FEATUREWRITER = "Vector Writer";
    public static final String RASTERPROCESSING = "Raster Processing";
    public static final String VECTORPROCESSING = "Vector Processing";
    public static final String LESTO = "Lesto";
    public static final String MOBILE = "Mobile";
    public static final String BASIN = "HortonMachine/Basin";
    public static final String DEMMANIPULATION = "HortonMachine/Dem Manipulation";
    public static final String GEOMORPHOLOGY = "HortonMachine/Geomorphology";
    public static final String HYDROGEOMORPHOLOGY = "HortonMachine/Hydro-Geomorphology";
    public static final String HILLSLOPE = "HortonMachine/Hillslope";
    public static final String NETWORK = "HortonMachine/Network";
    public static final String STATISTICS = "HortonMachine/Statistics";
    public static final String GDAL = "Gdal";
    public static final String PDAL = "Pdal";
    public static final String GPL3_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String WORKINGFOLDER = "@@@WORKINGFOLDER@@@";
    public static final String HIDE_UI_HINT = "hide";
    public static final String FILEIN_UI_HINT_GENERIC = "infile";
    public static final String FILEIN_UI_HINT_CSV = "infile_csv";
    public static final String FILEIN_UI_HINT_LAS = "infile_las";
    public static final String FILEIN_UI_HINT_RASTER = "infile_raster";
    public static final String FILEIN_UI_HINT_VECTOR = "infile_vector";
    public static final String FILEIN_UI_HINT_DBF = "infile_dbf";
    public static final String FILEIN_UI_HINT_GPAP = "infile_gpap";
    public static final String FILEIN_UI_HINT_JSON = "infile_json";
    public static final String FOLDERIN_UI_HINT = "infolder";
    public static final String FILEOUT_UI_HINT = "outfile";
    public static final String FOLDEROUT_UI_HINT = "outfolder";
    public static final String FILESPATHLIST_UI_HINT = "filespathlist";
    public static final String CRS_UI_HINT = "crs";
    public static final String COMBO_UI_HINT = "combo";
    public static final String ITERATOR_UI_HINT = "iterator";
    public static final String EASTINGNORTHING_UI_HINT = "eastnorth";
    public static final String NORTHING_UI_HINT = "northing";
    public static final String EASTING_UI_HINT = "easting";
    public static final String MULTILINE_UI_HINT = "multiline";
    public static final String MAPCALC_UI_HINT = "mapcalc";
    public static final String PROCESS_NORTH_UI_HINT = "process_north";
    public static final String PROCESS_SOUTH_UI_HINT = "process_south";
    public static final String PROCESS_EAST_UI_HINT = "process_east";
    public static final String PROCESS_WEST_UI_HINT = "process_west";
    public static final String PROCESS_COLS_UI_HINT = "process_cols";
    public static final String PROCESS_ROWS_UI_HINT = "process_rows";
    public static final String PROCESS_XRES_UI_HINT = "process_xres";
    public static final String PROCESS_YRES_UI_HINT = "process_yres";
    public static final FileFilter vectorFileFilter = new HMFileFilter("Supported Vector Files", SUPPORTED_VECTOR_EXTENSIONS);
    public static final FileFilter rasterFileFilter = new HMFileFilter("Supported Raster Files", SUPPORTED_RASTER_EXTENSIONS);
    public static final FileFilter lasFileFilter = new HMFileFilter("Supported LiDAR Files", SUPPORTED_LIDAR_EXTENSIONS);
    public static final FileFilter dbFileFilter = new HMFileFilter("Supported Database Files", SUPPORTED_DB_EXTENSIONS);

    public static double getNovalue(GridCoverage2D gc) {
        Double nvObj = CoverageUtilities.getNovalue(gc);
        double nv = -9999.0;
        if (nvObj != null) {
            nv = nvObj;
        }
        return nv;
    }

    public static int getIntNovalue(GridCoverage2D gc) {
        Double nvObj = CoverageUtilities.getNovalue(gc);
        int nv = -9999;
        if (nvObj != null) {
            nv = nvObj.intValue();
        }
        return nv;
    }

    public static boolean isNovalue(double value) {
        return Double.isNaN(value) || value == -9999.0;
    }

    public static boolean isNovalue(double value, double noValue) {
        return value == noValue || HMConstants.isNovalue(value);
    }

    public static boolean isOneNovalue(double ... values) {
        for (double value : values) {
            if (!Double.isNaN(value) && value != -9999.0) continue;
            return true;
        }
        return false;
    }

    public static boolean isNovalue(float value) {
        return Float.isNaN(value) || value == -9999.0f;
    }

    public static boolean isNovalue(int value) {
        return -9999 == value;
    }

    public static boolean doesOverFlow(int width, int height) {
        return (long)width * (long)height >= Integer.MAX_VALUE;
    }

    public static boolean isVector(File file) {
        String name = file.getName().toLowerCase();
        for (String ext : SUPPORTED_VECTOR_EXTENSIONS) {
            if (!name.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRaster(File file) {
        String name = file.getName().toLowerCase();
        for (String ext : SUPPORTED_RASTER_EXTENSIONS) {
            if (!name.endsWith(ext)) continue;
            return true;
        }
        return false;
    }
}

