/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.libs.modules;

import java.io.File;
import java.util.logging.Handler;
import java.util.logging.Logger;
import oms3.annotations.Description;
import oms3.annotations.In;
import oms3.annotations.Out;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.hortonmachine.gears.io.rasterreader.OmsRasterReader;
import org.hortonmachine.gears.io.rasterwriter.OmsRasterWriter;
import org.hortonmachine.gears.io.vectorreader.OmsVectorReader;
import org.hortonmachine.gears.io.vectorwriter.OmsVectorWriter;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.exceptions.ModelsUserCancelException;
import org.hortonmachine.gears.libs.modules.ModelsSupporter;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;
import org.hortonmachine.gears.libs.monitor.LogProgressMonitor;
import org.locationtech.jts.geom.GeometryFactory;

public class HMModel {
    private static boolean doLogging = false;
    @Description(en="The progress monitor.", it="The progress monitor.")
    @In
    public IHMProgressMonitor pm = new LogProgressMonitor();
    public GeometryFactory gf = new GeometryFactory();
    @UI(value="iterator")
    @In
    @Out
    public boolean doProcess = false;
    public boolean doReset = false;

    public static int getDefaultThreadsNum() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        return availableProcessors;
    }

    protected boolean isCanceled(IHMProgressMonitor pm) {
        if (pm.isCanceled()) {
            pm.done();
            return true;
        }
        return false;
    }

    public void checkCancel() {
        if (this.pm != null && this.pm.isCanceled()) {
            throw new ModelsUserCancelException();
        }
    }

    protected boolean concatOr(boolean ... statements) {
        boolean isTrue = statements[0];
        for (int i = 1; i < statements.length; ++i) {
            isTrue = isTrue || statements[i];
        }
        return isTrue;
    }

    protected void checkNull(Object ... objects) {
        for (Object object : objects) {
            if (object != null) continue;
            throw new ModelsIllegalargumentException("Mandatory input argument is missing. Check your syntax...", this.getClass().getSimpleName(), this.pm);
        }
    }

    protected void checkFileExists(String ... existingFilePath) {
        StringBuilder sb = null;
        for (String filePath : existingFilePath) {
            File file = new File(filePath);
            if (file.exists()) continue;
            if (sb == null) {
                sb = new StringBuilder();
                sb.append("The following file doesn't seem to exist: ");
            }
            sb.append("\n\t").append(file.getAbsolutePath());
        }
        if (sb != null) {
            throw new ModelsIllegalargumentException(sb.toString(), this.getClass().getSimpleName(), this.pm);
        }
    }

    protected String checkWorkingFolderInPath(String filePath) {
        if (filePath.contains("@@@WORKINGFOLDER@@@")) {
            return null;
        }
        return filePath;
    }

    public GridCoverage2D getRaster(String source) throws Exception {
        if (source == null || source.trim().length() == 0) {
            return null;
        }
        OmsRasterReader reader = new OmsRasterReader();
        reader.pm = this.pm;
        reader.file = source;
        reader.process();
        GridCoverage2D geodata = reader.outRaster;
        return geodata;
    }

    public SimpleFeatureCollection getVector(String source) throws Exception {
        if (source == null || source.trim().length() == 0) {
            return null;
        }
        OmsVectorReader reader = new OmsVectorReader();
        reader.pm = this.pm;
        reader.file = source;
        reader.process();
        SimpleFeatureCollection fc = reader.outVector;
        return fc;
    }

    public void dumpRaster(GridCoverage2D raster, String source) throws Exception {
        if (raster == null || source == null) {
            return;
        }
        OmsRasterWriter writer = new OmsRasterWriter();
        writer.pm = this.pm;
        writer.inRaster = raster;
        writer.file = source;
        writer.process();
    }

    public void dumpVector(SimpleFeatureCollection vector, String source) throws Exception {
        if (vector == null || source == null) {
            return;
        }
        OmsVectorWriter writer = new OmsVectorWriter();
        writer.pm = this.pm;
        writer.file = source;
        writer.inVector = vector;
        writer.process();
    }

    public void help() throws Exception {
        String help = ModelsSupporter.generateHelp(this);
        this.pm.message(help);
    }

    public void template() throws Exception {
        String help = ModelsSupporter.generateTemplate(this);
        this.pm.message(help);
    }

    static {
        System.setProperty("org.geotools.referencing.forceXY", "true");
        if (!doLogging) {
            Handler[] handlers;
            Logger l0 = Logger.getLogger("");
            for (Handler handler : handlers = l0.getHandlers()) {
                l0.removeHandler(handler);
            }
        }
    }
}

