/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.libs.modules;

import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.GeneralEnvelope;
import org.hortonmachine.gears.io.rasterwriter.OmsRasterWriter;
import org.hortonmachine.gears.io.vectorreader.OmsVectorReader;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.libs.monitor.DummyProgressMonitor;
import org.hortonmachine.gears.modules.r.imagemosaic.OmsImageMosaicCreator;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.colors.EColorTables;
import org.hortonmachine.gears.utils.colors.RasterStyleUtilities;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public abstract class HMModelIM
extends HMModel {
    private List<ImageMosaicReader> readers = new ArrayList<ImageMosaicReader>();
    protected List<RandomIter> inRasterIterators = new ArrayList<RandomIter>();
    protected List<Double> inRasterNovalues = new ArrayList<Double>();
    protected List<GridCoverage2D> inRasters = new ArrayList<GridCoverage2D>();
    protected List<WritableRandomIter> outRasterIterators = new ArrayList<WritableRandomIter>();
    protected List<GridCoverage2D> outGridCoverages = new ArrayList<GridCoverage2D>();
    private List<File> outRasterFiles = new ArrayList<File>();
    protected String locationField;
    protected double xRes;
    protected double yRes;
    protected CoordinateReferenceSystem crs;
    protected double[] llCorner;
    protected double[] urCorner;
    protected List<Geometry> boundsGeometries;
    protected int cellBuffer = 0;
    protected GridGeometry2D readGridGeometry;
    private boolean isSingleInX = true;
    private boolean isSingleInY = true;

    protected void addSource(File imageMosaicSource) throws Exception {
        URL imageMosaicUrl = imageMosaicSource.toURI().toURL();
        AbstractGridFormat imageMosaicFormat = GridFormatFinder.findFormat((Object)imageMosaicUrl);
        ImageMosaicReader imReader = (ImageMosaicReader)imageMosaicFormat.getReader((Object)imageMosaicUrl);
        if (this.readers.size() == 0) {
            File propertiesFile = FileUtilities.substituteExtention(imageMosaicSource, "properties");
            LinkedHashMap<String, String> propertiesMap = FileUtilities.readFileToHashMap(propertiesFile.getAbsolutePath(), null, false);
            String xyREs = (String)((HashMap)propertiesMap).get("Levels");
            String[] split = xyREs.split(",");
            this.xRes = Double.parseDouble(split[0]);
            this.yRes = Double.parseDouble(split[1]);
            this.locationField = (String)((HashMap)propertiesMap).get("LocationAttribute");
            this.crs = imReader.getCoordinateReferenceSystem();
            GeneralEnvelope originalEnvelope = imReader.getOriginalEnvelope();
            this.llCorner = originalEnvelope.getLowerCorner().getCoordinate();
            this.urCorner = originalEnvelope.getUpperCorner().getCoordinate();
            SimpleFeatureCollection vectorBounds = OmsVectorReader.readVector(imageMosaicSource.getAbsolutePath());
            this.boundsGeometries = FeatureUtilities.featureCollectionToGeometriesList(vectorBounds, true, this.locationField);
            Envelope singleTileEnv = this.boundsGeometries.get(0).getEnvelopeInternal();
            Envelope allTilesEnv = new Envelope();
            for (Geometry boundsGeometry : this.boundsGeometries) {
                allTilesEnv.expandToInclude(boundsGeometry.getEnvelopeInternal());
            }
            if (allTilesEnv.getWidth() > singleTileEnv.getWidth()) {
                this.isSingleInX = false;
            }
            if (allTilesEnv.getHeight() > singleTileEnv.getHeight()) {
                this.isSingleInY = false;
            }
        }
        this.readers.add(imReader);
    }

    protected void addDestination(File outputFile) throws IOException {
        this.outRasterFiles.add(outputFile);
    }

    protected void addDestination(File outputFile, int position) throws IOException {
        if (this.outRasterFiles.size() < position + 1) {
            for (int i = 0; i < position + 1; ++i) {
                this.outRasterFiles.add(new File("dummy"));
            }
        }
        this.outRasterFiles.set(position, outputFile);
    }

    protected GridCoverage2D getGridCoverage(int readerNum, double north, double south, double east, double west) throws Exception {
        GeneralParameterValue[] readGeneralParameterValues = CoverageUtilities.createGridGeometryGeneralParameter(this.xRes, this.yRes, north, south, east, west, this.crs);
        ImageMosaicReader reader = this.readers.get(readerNum);
        GridCoverage2D readGC = reader.read(readGeneralParameterValues);
        return readGC;
    }

    protected GridCoverage2D getGridCoverage(int readerNum, Envelope envelope) throws Exception {
        return this.getGridCoverage(readerNum, envelope.getMaxY(), envelope.getMinY(), envelope.getMaxX(), envelope.getMinX());
    }

    protected void processByTileCells() throws Exception {
        int size = this.boundsGeometries.size();
        int count = 0;
        for (Geometry boundGeometry : this.boundsGeometries) {
            ++count;
            try {
                this.pm.message("Processing tile " + boundGeometry.getUserData() + "(" + count + " of " + size + ")");
                this.pm.message("\t\t->geom: " + boundGeometry.getEnvelopeInternal());
                this.pm.message("\t\t->reading with cell buffer: " + this.cellBuffer);
                this.pm.message("\t\t->reading with x/y resolution: " + this.xRes + "/" + this.yRes);
                this.processGeometryByTileCell(count, boundGeometry);
            }
            catch (Exception e) {
                this.pm.errorMessage("Problems found for tile: " + boundGeometry.getUserData());
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGeometryByTileCell(int count, Geometry boundGeometry) throws IOException, TransformException, Exception {
        Envelope writeEnv = boundGeometry.getEnvelopeInternal();
        double writeEast = writeEnv.getMaxX();
        double writeWest = writeEnv.getMinX();
        double writeNorth = writeEnv.getMaxY();
        double writeSouth = writeEnv.getMinY();
        int writeCols = (int)((writeEast - writeWest) / this.xRes);
        int writeRows = (int)((writeNorth - writeSouth) / this.yRes);
        Envelope readEnv = new Envelope(writeEnv);
        readEnv.expandBy((double)this.cellBuffer * this.xRes, (double)this.cellBuffer * this.yRes);
        double readEast = readEnv.getMaxX();
        double readWest = readEnv.getMinX();
        double readNorth = readEnv.getMaxY();
        double readSouth = readEnv.getMinY();
        this.outGridCoverages.clear();
        this.inRasterIterators.clear();
        this.inRasters.clear();
        this.outRasterIterators.clear();
        GridGeometry2D writeGridGeometry = CoverageUtilities.gridGeometryFromRegionValues(writeNorth, writeSouth, writeEast, writeWest, writeCols, writeRows, this.crs);
        for (File outRasterFile : this.outRasterFiles) {
            File parentFile = outRasterFile.getParentFile();
            if (parentFile != null && parentFile.exists()) {
                WritableRaster outWR = CoverageUtilities.createWritableRaster(writeCols, writeRows, null, null, -9999.0);
                RegionMap writeParams = CoverageUtilities.gridGeometry2RegionParamsMap(writeGridGeometry);
                GridCoverage2D writeGC = CoverageUtilities.buildCoverage(outRasterFile.getName(), outWR, (HashMap<String, Double>)writeParams, this.crs);
                this.outGridCoverages.add(writeGC);
                WritableRandomIter outDataIter = CoverageUtilities.getWritableRandomIterator(outWR);
                this.outRasterIterators.add(outDataIter);
                continue;
            }
            this.outGridCoverages.add(null);
            this.outRasterIterators.add(null);
        }
        this.readGridGeometry = null;
        GeneralParameterValue[] readGeneralParameterValues = CoverageUtilities.createGridGeometryGeneralParameter(this.xRes, this.yRes, readNorth, readSouth, readEast, readWest, this.crs);
        int index = 0;
        for (ImageMosaicReader reader : this.readers) {
            try {
                GridCoverage2D readGC = reader.read(readGeneralParameterValues);
                this.readGridGeometry = readGC.getGridGeometry();
                Raster readRaster = readGC.getRenderedImage().getData();
                RandomIter readIter = RandomIterFactory.create((Raster)readRaster, null);
                this.inRasterIterators.add(readIter);
                this.inRasters.add(readGC);
                this.inRasterNovalues.add(HMConstants.getNovalue(readGC));
                ++index;
            }
            catch (Exception e) {
                StringBuilder errSb = new StringBuilder();
                errSb.append("ERROR: could not read coverage for parameters: \n");
                errSb.append(readGeneralParameterValues[0]);
                errSb.append("ERROR: with reader N." + index + ": " + Arrays.toString(reader.getGridCoverageNames()));
                errSb.append("\nERROR: " + e.getLocalizedMessage());
                this.pm.errorMessage(errSb.toString());
                this.freeIterators();
                throw new IOException("Problems reading Mosaic!");
            }
        }
        GridCoordinates2D llGrid = this.readGridGeometry.worldToGrid((DirectPosition)new DirectPosition2D(this.llCorner[0], this.llCorner[1]));
        GridCoordinates2D urGrid = this.readGridGeometry.worldToGrid((DirectPosition)new DirectPosition2D(this.urCorner[0], this.urCorner[1]));
        int minX = llGrid.x;
        int maxY = llGrid.y;
        int maxX = urGrid.x;
        int minY = urGrid.y;
        GridEnvelope2D gridRange2D = this.readGridGeometry.getGridRange2D();
        int readRows = gridRange2D.height;
        minY += gridRange2D.y;
        maxY = this.isSingleInY ? (maxY -= gridRange2D.y) : (maxY += gridRange2D.y);
        int readCols = gridRange2D.width;
        minX += gridRange2D.x;
        maxX = this.isSingleInX ? (maxX -= gridRange2D.x) : (maxX += gridRange2D.x);
        try {
            GridCoordinates2D gridCoordinates2D = new GridCoordinates2D();
            for (int writeRow = 0; writeRow < writeRows; ++writeRow) {
                for (int writeCol = 0; writeCol < writeCols; ++writeCol) {
                    gridCoordinates2D.x = writeCol;
                    gridCoordinates2D.y = writeRow;
                    DirectPosition writeGridToWorld = writeGridGeometry.gridToWorld(gridCoordinates2D);
                    GridCoordinates2D worldToReadGrid = this.readGridGeometry.worldToGrid(writeGridToWorld);
                    int readCol = worldToReadGrid.x;
                    int readRow = worldToReadGrid.y;
                    if (readCol + this.cellBuffer > maxX || readCol - this.cellBuffer < minX || readRow + this.cellBuffer > maxY || readRow - this.cellBuffer < minY) continue;
                    this.processCell(readCol, readRow, writeCol, writeRow, readCols, readRows, writeCols, writeRows);
                }
            }
        }
        finally {
            this.freeIterators();
        }
        for (int i = 0; i < this.outRasterFiles.size(); ++i) {
            File outParentFolder;
            File outputFile = this.outRasterFiles.get(i);
            GridCoverage2D writeGC = this.outGridCoverages.get(i);
            if (writeGC == null || (outParentFolder = outputFile.getParentFile()) == null || !outParentFolder.exists()) continue;
            String outBaseName = FileUtilities.getNameWithoutExtention(outputFile);
            File outTileFile = new File(outParentFolder, outBaseName + "_" + count + ".tiff");
            OmsRasterWriter writer = new OmsRasterWriter();
            writer.pm = new DummyProgressMonitor();
            writer.inRaster = writeGC;
            writer.file = outTileFile.getAbsolutePath();
            writer.process();
        }
    }

    private void freeIterators() {
        for (RandomIter randomIter : this.inRasterIterators) {
            if (randomIter == null) continue;
            randomIter.done();
        }
        for (RandomIter randomIter : this.outRasterIterators) {
            if (randomIter == null) continue;
            randomIter.done();
        }
    }

    protected void makeMosaic() throws Exception {
        for (int i = 0; i < this.outRasterFiles.size(); ++i) {
            File outParentFolder;
            File outputFile = this.outRasterFiles.get(i);
            if (outputFile == null || (outParentFolder = outputFile.getParentFile()) == null || !outParentFolder.exists()) continue;
            OmsImageMosaicCreator im = new OmsImageMosaicCreator();
            im.inFolder = outParentFolder.getAbsolutePath();
            im.process();
        }
    }

    protected void makeStyle(EColorTables colorTable, double min, double max) throws Exception {
        for (int i = 0; i < this.outRasterFiles.size(); ++i) {
            File outParentFolder;
            File outputFile = this.outRasterFiles.get(i);
            if (outputFile == null || (outParentFolder = outputFile.getParentFile()) == null || !outParentFolder.exists()) continue;
            if (colorTable == null) {
                colorTable = EColorTables.extrainbow;
            }
            String name = outParentFolder.getName();
            String style = RasterStyleUtilities.styleToString(RasterStyleUtilities.createStyleForColortable(colorTable.name(), min, max, null, 1.0));
            File styleFile = new File(outParentFolder, name + ".sld");
            FileUtilities.writeFile(style, styleFile);
        }
    }

    protected void dispose() {
        for (ImageMosaicReader reader : this.readers) {
            reader.dispose();
        }
    }

    protected abstract void processCell(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);
}

