/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.libs.modules;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public class NetLink {
    public int num;
    public int upRow;
    public int upCol;
    public int downRow;
    public int downCol;
    public int downLinkRow;
    public int downLinkCol;
    public Integer desiredChainNetLink;
    private int tca = 0;
    private NetLink downStreamLink;
    private List<NetLink> upStreamLinks = new CopyOnWriteArrayList<NetLink>();
    private boolean isFixed;

    public NetLink(int num, int upCol, int upRow, int downCol, int downRow, int downLinkCol, int downLinkRow, boolean isFixed) {
        this.num = num;
        this.upCol = upCol;
        this.upRow = upRow;
        this.downCol = downCol;
        this.downRow = downRow;
        this.downLinkCol = downLinkCol;
        this.downLinkRow = downLinkRow;
        this.isFixed = isFixed;
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public void setTca(int tca) {
        this.tca = tca;
    }

    public int getTca() {
        return this.tca;
    }

    public NetLink getDownStreamLink() {
        return this.downStreamLink;
    }

    public void setDownStreamLink(NetLink downStreamLink) {
        this.downStreamLink = downStreamLink;
    }

    public List<NetLink> getUpStreamLinks() {
        return this.upStreamLinks;
    }

    public void connect(NetLink other) {
        if (this.downLinkCol == other.upCol && this.downLinkRow == other.upRow && this.downStreamLink == null) {
            this.downStreamLink = other;
            if (!other.upStreamLinks.contains(this)) {
                other.upStreamLinks.add(this);
            }
        } else if (other.downLinkCol == this.upCol && other.downLinkRow == this.upRow && other.downStreamLink == null) {
            other.downStreamLink = this;
            if (!this.upStreamLinks.contains(other)) {
                this.upStreamLinks.add(other);
            }
        }
    }

    public String toString() {
        String ups = this.upStreamLinks.stream().map(nl -> "" + nl.num).collect(Collectors.joining(", "));
        int upLinksTca = 0;
        for (NetLink netLink : this.upStreamLinks) {
            upLinksTca += netLink.tca;
        }
        int cells = this.tca - upLinksTca;
        Object s = "\n___________________\n";
        s = (String)s + "| num=" + this.num + "\n";
        s = (String)s + "| tca=" + cells + "\n";
        s = (String)s + "| ups=[" + ups + "]\n";
        s = (String)s + "|___________________|\n";
        s = (String)s + "|        " + this.upCol + "/" + this.upRow + "\n";
        s = (String)s + "|                || \n";
        s = (String)s + "|                ||\n";
        s = (String)s + "|                ||\n";
        s = (String)s + "|                \\/\n";
        s = (String)s + "|        " + this.downCol + "/" + this.downRow + "\n";
        s = (String)s + "|___________________|\n";
        s = (String)s + "|        " + this.downLinkCol + "/" + this.downLinkRow + "\n";
        if (this.downStreamLink != null) {
            s = (String)s + "| down=[" + this.downStreamLink.num + "]\n";
        }
        s = (String)s + "|___________________|\n";
        return s;
    }

    public String toMindMapString() {
        String down = "down=" + this.downCol + "/" + this.downRow;
        String up = "up=" + this.upCol + "/" + this.upRow;
        int upLinksTca = 0;
        for (NetLink netLink : this.upStreamLinks) {
            upLinksTca += netLink.tca;
        }
        int cells = this.tca - upLinksTca;
        String cellsDeltaStr = "tca=" + cells;
        String cellsStr = "outlet tca=" + this.tca;
        String fixed = "";
        if (this.isFixed) {
            fixed = "\\n  <b>FIXED</b>";
        }
        return "<b>basin" + this.num + "</b>\\n  \\n  " + down + "\\n  " + up + "\\n  " + cellsDeltaStr + "\\n  " + cellsStr + fixed;
    }

    public String toJsonString() {
        Object str = "  {\n";
        str = (String)str + "    \"num\":" + this.num + ",\n";
        str = (String)str + "    \"downCol\":" + this.downCol + ",\n";
        str = (String)str + "    \"downRow\":" + this.downRow + ",\n";
        str = (String)str + "    \"upCol\":" + this.upCol + ",\n";
        str = (String)str + "    \"upRow\":" + this.upRow + ",\n";
        str = (String)str + "    \"downLinkCol\":" + this.downLinkCol + ",\n";
        str = (String)str + "    \"downLinkRow\":" + this.downLinkRow + "\n";
        str = (String)str + "  }";
        return str;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.downCol;
        result = 31 * result + this.downRow;
        result = 31 * result + this.upCol;
        result = 31 * result + this.upRow;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NetLink other = (NetLink)obj;
        if (this.downCol != other.downCol) {
            return false;
        }
        if (this.downRow != other.downRow) {
            return false;
        }
        if (this.upCol != other.upCol) {
            return false;
        }
        return this.upRow == other.upRow;
    }
}

