/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.libs.modules;

import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.WritableRandomIter;

public abstract class Node {
    public final int row;
    public final int col;
    public final int cols;
    public final int rows;
    protected boolean isValid;
    protected boolean touchesBound = false;
    protected boolean touchesNovalue = false;
    protected final RandomIter gridIter;
    protected double doubleNovalue = -9999.0;
    protected float floatNovalue = -9999.0f;
    protected int intNovalue = -9999;

    public Node(RandomIter gridIter, int cols, int rows, int col, int row, Double novalue) {
        this.gridIter = gridIter;
        this.cols = cols;
        this.rows = rows;
        this.col = col;
        this.row = row;
        if (novalue != null) {
            this.doubleNovalue = novalue;
            this.floatNovalue = novalue.floatValue();
            if (!Double.isNaN(novalue)) {
                this.intNovalue = novalue.intValue();
            }
        }
    }

    public double getValueFromMap(RandomIter map) {
        return this.getDoubleValueFromMap(map);
    }

    public float getFloatValueFromMap(RandomIter map) {
        try {
            if (map == null) {
                return this.floatNovalue;
            }
            float value = map.getSampleFloat(this.col, this.row, 0);
            return value;
        }
        catch (Exception e) {
            return this.floatNovalue;
        }
    }

    public int getIntValueFromMap(RandomIter map) {
        try {
            if (map == null) {
                return this.intNovalue;
            }
            int value = map.getSample(this.col, this.row, 0);
            return value;
        }
        catch (Exception e) {
            return this.intNovalue;
        }
    }

    public double getDoubleValueFromMap(RandomIter map) {
        try {
            if (map == null) {
                return this.doubleNovalue;
            }
            double value = map.getSampleDouble(this.col, this.row, 0);
            return value;
        }
        catch (Exception e) {
            return this.doubleNovalue;
        }
    }

    public void setValueInMap(WritableRandomIter map, double value) {
        this.setDoubleValueInMap(map, value);
    }

    public void setFloatValueInMap(WritableRandomIter map, float value) {
        if (map == null) {
            return;
        }
        try {
            map.setSample(this.col, this.row, 0, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setIntValueInMap(WritableRandomIter map, int value) {
        if (map == null) {
            return;
        }
        try {
            map.setSample(this.col, this.row, 0, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDoubleValueInMap(WritableRandomIter map, double value) {
        if (map == null) {
            return;
        }
        try {
            map.setSample(this.col, this.row, 0, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean touchesBound() {
        return this.touchesBound;
    }

    public boolean touchesNovalue() {
        return this.touchesNovalue;
    }
}

