/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.libs.modules.multiprocessing;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BlockingExecutorService
implements ExecutorService {
    private ExecutorService delegate;
    private Semaphore taskCount;

    public BlockingExecutorService(ExecutorService delegate, int maxTaskCount) {
        this.delegate = delegate;
        this.taskCount = new Semaphore(maxTaskCount);
    }

    protected void beforeSubmit() {
        try {
            this.taskCount.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void execute(Runnable command) {
        this.beforeSubmit();
        this.delegate.execute(() -> {
            try {
                command.run();
            }
            finally {
                this.taskCount.release();
            }
        });
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.beforeSubmit();
        return this.delegate.submit(() -> {
            try {
                Object v = task.call();
                return v;
            }
            finally {
                this.taskCount.release();
            }
        });
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        this.beforeSubmit();
        return this.delegate.submit(() -> {
            try {
                task.run();
            }
            finally {
                this.taskCount.release();
            }
        }, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        this.beforeSubmit();
        return this.delegate.submit(() -> {
            try {
                task.run();
            }
            finally {
                this.taskCount.release();
            }
        });
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new RuntimeException("not yet implemented.");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new RuntimeException("not yet implemented.");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new RuntimeException("not yet implemented.");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new RuntimeException("not yet implemented.");
    }
}

