/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.libs.modules.multiprocessing;

import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.hortonmachine.gears.libs.modules.multiprocessing.BlockingExecutorService;
import org.hortonmachine.gears.libs.modules.multiprocessing.InThreadExecutionPlanner;
import org.hortonmachine.gears.libs.modules.multiprocessing.MultiProcessingTask;

public abstract class ExecutionPlanner {
    public static final BlockingExecutorService defaultExecutor;
    public static Supplier<ExecutionPlanner> defaultPlannerFactory;
    protected int numberOfTasks = -1;

    public static ExecutionPlanner createDefaultPlanner() {
        return defaultPlannerFactory.get();
    }

    public ExecutionPlanner setNumberOfTasks(int num) {
        this.numberOfTasks = num;
        return this;
    }

    public abstract void submit(MultiProcessingTask var1);

    public abstract void join() throws Exception;

    static {
        ThreadFactory threadFactory = new ThreadFactory(){
            volatile int threadNumber = 0;

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "process-worker-" + this.threadNumber++);
                t.setDaemon(false);
                return t;
            }
        };
        int procNum = Runtime.getRuntime().availableProcessors();
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(procNum, procNum, 60L, TimeUnit.SECONDS, new LinkedTransferQueue<Runnable>(), threadFactory);
        defaultExecutor = new BlockingExecutorService(threadPool, procNum);
        defaultPlannerFactory = () -> new InThreadExecutionPlanner();
    }
}

