/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.libs.modules.multiprocessing;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import org.hortonmachine.gears.libs.modules.multiprocessing.ExecutionPlanner;
import org.hortonmachine.gears.libs.modules.multiprocessing.MultiProcessingTask;

public class FixedChunkSizePlanner
extends ExecutionPlanner {
    public static final int MAX_CHUNK_SIZE = 10000;
    private int targetChunkSize = -1;
    private List<MultiProcessingTask> accu;
    private List<Future> submitted = new ArrayList<Future>(1024);
    private Exception exc;

    @Override
    public void submit(MultiProcessingTask task) {
        if (this.targetChunkSize == -1) {
            if (this.numberOfTasks <= 0) {
                throw new IllegalStateException("No setNumberOfTasks() given.");
            }
            int procNum = Runtime.getRuntime().availableProcessors();
            this.targetChunkSize = Math.min(this.numberOfTasks / (procNum * 3), 10000);
            this.accu = new ArrayList<MultiProcessingTask>(this.targetChunkSize);
        }
        this.accu.add(task);
        if (this.accu.size() >= this.targetChunkSize) {
            this.submitChunk(this.accu);
            this.accu = new ArrayList<MultiProcessingTask>(this.targetChunkSize);
        }
    }

    protected void submitChunk(List<MultiProcessingTask> chunk) {
        Runnable work = () -> {
            try {
                for (MultiProcessingTask task : chunk) {
                    task.calculate();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        };
        boolean success = false;
        int waitMillis = 10;
        while (!success) {
            success = this.submitted.add(defaultExecutor.submit(work));
            waitMillis = Math.min(100, waitMillis * 2);
        }
    }

    protected void handleException(Exception e) {
        this.exc = this.exc == null ? e : this.exc;
    }

    @Override
    public void join() throws Exception {
        if (this.exc != null) {
            throw this.exc;
        }
        if (!this.accu.isEmpty()) {
            this.submitChunk(this.accu);
            this.accu = null;
        }
        for (Future f : this.submitted) {
            try {
                f.get();
            }
            catch (InterruptedException | CancellationException exception) {}
        }
    }
}

