/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.libs.modules.multiprocessing;

import org.hortonmachine.gears.libs.modules.multiprocessing.ExecutionPlanner;
import org.hortonmachine.gears.libs.modules.multiprocessing.MultiProcessing;

public abstract class GridMultiProcessing
extends MultiProcessing {
    protected void processGrid(int cols, int rows, Calculator calculator) throws Exception {
        this.processGrid(cols, rows, false, calculator);
    }

    protected void processGrid(int cols, int rows, boolean ignoreBorder, Calculator calculator) throws Exception {
        ExecutionPlanner planner = this.createDefaultPlanner();
        planner.setNumberOfTasks(rows * cols);
        int startC = 0;
        int startR = 0;
        int endC = cols;
        int endR = rows;
        if (ignoreBorder) {
            startC = 1;
            startR = 1;
            endC = cols - 1;
            endR = rows - 1;
        }
        for (int r = startR; r < endR; ++r) {
            int c = startC;
            while (c < endC) {
                int _c = c++;
                int _r = r;
                planner.submit(() -> {
                    if (!this.pm.isCanceled()) {
                        calculator.calculate(_c, _r);
                    }
                });
            }
        }
        planner.join();
    }

    @FunctionalInterface
    protected static interface Calculator {
        public void calculate(int var1, int var2) throws Exception;
    }
}

