/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.libs.modules.multiprocessing;

import java.util.HashMap;
import java.util.Map;
import javax.media.jai.iterator.RandomIter;
import org.geotools.coverage.grid.GridCoverage2D;
import org.hortonmachine.gears.libs.modules.GridNode;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.multiprocessing.ExecutionPlanner;
import org.hortonmachine.gears.libs.modules.multiprocessing.MultiProcessing;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;

public abstract class GridNodeMultiProcessing
extends MultiProcessing {
    private Map<Integer, RegionMap> regionMaps = new HashMap<Integer, RegionMap>();

    public RegionMap regionMap(GridCoverage2D grid) {
        return this.regionMaps.computeIfAbsent(grid.hashCode(), key -> CoverageUtilities.getRegionParamsFromGridCoverage(grid));
    }

    protected void processGridNodes(GridCoverage2D inElev, Calculator<GridNode> calculator) throws Exception {
        RegionMap regionMap = this.regionMap(inElev);
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        double xRes = regionMap.getXres();
        double yRes = regionMap.getYres();
        RandomIter elevationIter = CoverageUtilities.getRandomIterator(inElev);
        double novalue = HMConstants.getNovalue(inElev);
        ExecutionPlanner planner = this.createDefaultPlanner();
        planner.setNumberOfTasks(rows * cols);
        for (int r = 0; r < rows; ++r) {
            int c = 0;
            while (c < cols) {
                int _c = c++;
                int _r = r;
                planner.submit(() -> {
                    if (!this.pm.isCanceled()) {
                        GridNode node = new GridNode(elevationIter, cols, rows, xRes, yRes, _c, _r, novalue);
                        calculator.calculate(node);
                    }
                });
            }
        }
        planner.join();
    }

    @FunctionalInterface
    protected static interface Calculator<T> {
        public void calculate(T var1) throws Exception;
    }
}

