/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.libs.monitor;

import java.io.PrintStream;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;

public class LogProgressMonitor
implements IHMProgressMonitor {
    private static final String DOTS = "...";
    private static final String PERC = "%...";
    protected boolean cancelled = false;
    protected String taskName;
    protected int totalWork;
    protected int runningWork;
    protected volatile int lastPercentage = -1;
    private String prefix = null;
    private PrintStream outStream = System.out;
    private PrintStream errorStream = System.err;

    public LogProgressMonitor() {
        this(null, null, "");
    }

    public LogProgressMonitor(PrintStream outStream, PrintStream errorStream) {
        this(outStream, errorStream, "");
    }

    public LogProgressMonitor(String prefix) {
        this(null, null, prefix);
    }

    public LogProgressMonitor(PrintStream outStream, PrintStream errorStream, String prefix) {
        if (outStream != null) {
            this.outStream = outStream;
        }
        if (errorStream != null) {
            this.errorStream = errorStream;
        }
        this.prefix = prefix;
    }

    @Override
    public void beginTask(String name, int totalWork) {
        this.taskName = name;
        this.totalWork = totalWork;
        this.runningWork = 0;
        if (this.prefix != null) {
            this.taskName = this.prefix + this.taskName;
        }
        this.outStream.println(this.taskName);
    }

    public void beginTask(String name) {
        this.taskName = name;
        this.totalWork = -1;
        this.runningWork = 0;
        if (this.prefix != null) {
            this.taskName = this.prefix + this.taskName;
        }
        this.outStream.println(this.taskName);
    }

    @Override
    public void done() {
        Object msg = "Finished.";
        if (this.prefix != null) {
            msg = this.prefix + (String)msg;
        }
        this.outStream.println((String)msg);
    }

    @Override
    public void internalWorked(double work) {
    }

    @Override
    public boolean isCanceled() {
        return this.cancelled;
    }

    @Override
    public void setCanceled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    public void setTaskName(String name) {
        this.taskName = name;
    }

    @Override
    public void subTask(String name) {
    }

    @Override
    public void worked(int workDone) {
        if (this.totalWork == -1) {
            Object msg = DOTS;
            if (this.prefix != null) {
                msg = this.prefix + (String)msg;
            }
            this.outStream.println((String)msg);
        } else {
            this.runningWork += workDone;
            int percentage = (int)(100.0f * ((float)this.runningWork / (float)this.totalWork));
            if (percentage % 10 == 0) {
                String msg = percentage + PERC;
                if (this.prefix != null) {
                    msg = this.prefix + msg;
                }
                if (percentage != this.lastPercentage) {
                    this.outStream.println(msg);
                    this.lastPercentage = percentage;
                }
            }
        }
    }

    @Override
    public <T> T adapt(Class<T> adaptee) {
        return null;
    }

    @Override
    public void errorMessage(String message) {
        if (this.prefix != null) {
            this.errorStream.println(this.prefix + message);
        } else {
            this.errorStream.println(message);
        }
    }

    @Override
    public void message(String message) {
        if (this.prefix != null) {
            this.outStream.println(this.prefix + message);
        } else {
            this.outStream.println(message);
        }
    }

    @Override
    public void exceptionThrown(String message) {
    }

    @Override
    public void onModuleExit() {
    }
}

