/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.aoi;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Range;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.processing.Operations;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.libs.modules.JGTProcessingRegion;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.opengis.coverage.Coverage;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Module that extracts a gridcoverage for a given area of interest, resampling it if necessary.")
@Label(value="Area of interest")
@Name(value="Area of interest")
@Documentation(value="")
@Author(name="Andrea Antonello, Falko Braeutigam", contact="www.hydrologis.com")
@Keywords(value="raster, crop")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsAreaOfInterestGridCoverage
extends HMModel {
    @In
    @Description(value="The source raster data.")
    public GridCoverage2DReader inCoverageReader;
    @In
    @Description(value="The requested are aof interest bounds.")
    public ReferencedEnvelope aoi;
    @In
    @Description(value="The requested resampling resolution factor.")
    @Range(min=1.0, max=100.0)
    public int resolutionFactor = 1;
    @Description(value="The resampled and cropped gridcoverage.")
    @Out
    public GridCoverage2D outCoverage;

    @Execute
    public void process() throws Exception {
        CoordinateReferenceSystem crs = this.inCoverageReader.getCoordinateReferenceSystem();
        this.aoi = this.aoi.transform(crs, true);
        GeneralEnvelope originalEnvelope = this.inCoverageReader.getOriginalEnvelope();
        GridEnvelope2D overviewGridEnvelope = (GridEnvelope2D)this.inCoverageReader.getOriginalGridRange();
        double[] llCorner = originalEnvelope.getLowerCorner().getCoordinate();
        double[] urCorner = originalEnvelope.getUpperCorner().getCoordinate();
        JGTProcessingRegion originalRegion = new JGTProcessingRegion(llCorner[0], urCorner[0], llCorner[1], urCorner[1], overviewGridEnvelope.height, overviewGridEnvelope.width);
        RegionMap originalRegionMap = CoverageUtilities.makeRegionParamsMap(urCorner[1], llCorner[1], llCorner[0], urCorner[0], originalRegion.getWEResolution(), originalRegion.getNSResolution(), overviewGridEnvelope.width, overviewGridEnvelope.height);
        RegionMap subRegion = originalRegionMap.toSubRegion(this.aoi.getMaxY(), this.aoi.getMinY(), this.aoi.getMinX(), this.aoi.getMaxX());
        double xres = subRegion.getXres();
        double yres = subRegion.getYres();
        if (this.resolutionFactor > 1) {
            xres *= (double)this.resolutionFactor;
            yres *= (double)this.resolutionFactor;
        }
        this.outCoverage = CoverageUtilities.getGridCoverage((GridCoverage2DReader)((AbstractGridCoverage2DReader)this.inCoverageReader), subRegion.getNorth(), subRegion.getSouth(), subRegion.getEast(), subRegion.getWest(), xres, yres, crs);
        ReferencedEnvelope outenvelope = new ReferencedEnvelope(subRegion.getWest(), subRegion.getEast(), subRegion.getSouth(), subRegion.getNorth(), crs);
        this.outCoverage = (GridCoverage2D)Operations.DEFAULT.crop((Coverage)this.outCoverage, (Envelope)outenvelope);
    }
}

