/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.carver;

import java.awt.image.WritableRaster;
import java.util.HashMap;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.linesrasterizer.OmsLinesRasterizer;
import org.hortonmachine.gears.modules.r.scanline.OmsScanLineRasterizer;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;

@Description(value="Carves a raster using a vector map.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="Carve, Raster")
@Label(value="Raster Processing")
@Name(value="carver")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsCarver
extends HMModel {
    @Description(value="The input raster.")
    @In
    public GridCoverage2D inRaster = null;
    @Description(value="The polygon vector map used to carve the raster.")
    @In
    public SimpleFeatureCollection inCarverPolygons = null;
    @Description(value="The lines vector map used to carve the raster.")
    @In
    public SimpleFeatureCollection inCarverLines = null;
    private String pMode = "simple";
    @Description(value="The optional vector lines field containing the depth to be carved.")
    @In
    public String fDepthLines = null;
    @Description(value="The carve depth to use for vector lines if no field is supplied.")
    @In
    public double pDepthLines = 6.0;
    @Description(value="The optional vector polygons field containing the depth to be carved.")
    @In
    public String fDepthPolygons = null;
    @Description(value="The carve depth to use for vector polygons if no field is supplied.")
    @In
    public double pDepthPolygons = 6.0;
    @Description(value="The carved raster map.")
    @Out
    public GridCoverage2D outRaster = null;
    private RegionMap regionMap;

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inRaster);
        this.regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
        if (this.pMode.equals("simple")) {
            this.simpleMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void simpleMode() throws Exception {
        int cols = this.regionMap.getCols();
        int rows = this.regionMap.getRows();
        GridCoverage2D depthLinesRaster = null;
        GridCoverage2D depthPolygonsRaster = null;
        if (this.inCarverLines != null) {
            OmsLinesRasterizer lr = new OmsLinesRasterizer();
            lr.fCat = this.fDepthLines;
            lr.pCat = this.pDepthLines;
            lr.inVector = this.inCarverLines;
            lr.pNorth = this.regionMap.getNorth();
            lr.pSouth = this.regionMap.getSouth();
            lr.pEast = this.regionMap.getEast();
            lr.pWest = this.regionMap.getWest();
            lr.pRows = rows;
            lr.pCols = cols;
            lr.pm = this.pm;
            lr.process();
            depthLinesRaster = lr.outRaster;
        }
        if (this.inCarverPolygons != null) {
            OmsScanLineRasterizer raster = new OmsScanLineRasterizer();
            raster.inVector = this.inCarverPolygons;
            raster.pNorth = this.regionMap.getNorth();
            raster.pSouth = this.regionMap.getSouth();
            raster.pEast = this.regionMap.getEast();
            raster.pWest = this.regionMap.getWest();
            raster.pRows = rows;
            raster.pCols = cols;
            raster.fCat = this.fDepthLines;
            raster.pValue = this.pDepthLines;
            raster.pm = this.pm;
            raster.process();
            depthPolygonsRaster = raster.outRaster;
        }
        GridCoverage2D finalCarveGC = null;
        if (depthLinesRaster != null && depthPolygonsRaster != null) {
            finalCarveGC = CoverageUtilities.mergeCoverages(depthPolygonsRaster, depthLinesRaster);
        } else if (depthLinesRaster == null && depthPolygonsRaster != null) {
            finalCarveGC = depthPolygonsRaster;
        } else if (depthLinesRaster != null && depthPolygonsRaster == null) {
            finalCarveGC = depthLinesRaster;
        } else {
            throw new ModelsIllegalargumentException("At least one lines or one polygon carving layer needs to be supplied.", this, this.pm);
        }
        RandomIter dtmIter = CoverageUtilities.getRandomIterator(this.inRaster);
        RandomIter depthIter = CoverageUtilities.getRandomIterator(finalCarveGC);
        WritableRaster outWR = CoverageUtilities.createWritableRaster(cols, rows, null, null, -9999.0);
        WritableRandomIter outIter = RandomIterFactory.createWritable((WritableRaster)outWR, null);
        try {
            for (int y = 0; y < rows; ++y) {
                for (int x = 0; x < cols; ++x) {
                    double dtmValue = dtmIter.getSampleDouble(x, y, 0);
                    if (HMConstants.isNovalue(dtmValue)) continue;
                    double depthValue = depthIter.getSampleDouble(x, y, 0);
                    double newValue = HMConstants.isNovalue(depthValue) ? dtmValue : dtmValue - depthValue;
                    outIter.setSample(x, y, 0, newValue);
                }
            }
        }
        finally {
            dtmIter.done();
            depthIter.done();
            outIter.done();
        }
        this.outRaster = CoverageUtilities.buildCoverage("outraster", outWR, (HashMap<String, Double>)this.regionMap, this.inRaster.getCoordinateReferenceSystem());
    }
}

