/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.connectivity;

import java.awt.image.WritableRaster;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Bibliography;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.Unit;
import org.geotools.coverage.grid.GridCoverage2D;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.exceptions.ModelsRuntimeException;
import org.hortonmachine.gears.libs.modules.FlowNode;
import org.hortonmachine.gears.libs.modules.GridNode;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.ConstantRandomIter;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;

@Description(value="Module for the calculation of the downslope connectivity.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="connectivity, raster")
@Label(value="HortonMachine/Hillslope")
@Name(value="downslopeconnectivity")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
@Bibliography(value={"Geomorphometric assessment of spatial sediment connectivity in small Alpine catchments. - Cavalli et al. 2012"})
public class OmsDownSlopeConnectivity
extends HMModel {
    @Description(value="The map of flowdirections.")
    @In
    public GridCoverage2D inFlow;
    @Description(value="The network map.")
    @In
    public GridCoverage2D inNet;
    @Description(value="The map of slope.")
    @Unit(value="m/m")
    @In
    public GridCoverage2D inSlope;
    @Description(value="The optional map of weights.")
    @In
    public GridCoverage2D inWeights;
    @Description(value="The optional constant value of weights.")
    @In
    public Double pWeight;
    @Description(value="The connectivity map.")
    @Out
    public GridCoverage2D outConnectivity = null;
    public static final String outConnectivity_DESCR = "The connectivity map.";
    public static final String pWeight_DESCR = "The optional constant value of weights.";
    public static final String inWeights_DESCR = "The optional map of weights.";
    public static final String inSlope_DESCR = "The map of slope.";
    public static final String inNet_DESCR = "The network map.";
    public static final String inFlow_DESCR = "The map of flowdirections.";
    public static final String KEYWORDS = "connectivity, raster";
    public static final String BIBLIO = "Geomorphometric assessment of spatial sediment connectivity in small Alpine catchments. - Cavalli et al. 2012";
    public static final String NAME = "downslopeconnectivity";
    public static final String DESCRIPTION = "Module for the calculation of the downslope connectivity.";
    public static final String LABEL = "HortonMachine/Hillslope";

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inFlow, this.inNet, this.inSlope);
        if (this.pWeight == null && this.inWeights == null) {
            throw new ModelsIllegalargumentException("At lest one weight definition needs to be supplied.", this);
        }
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inFlow);
        int nCols = regionMap.getCols();
        int nRows = regionMap.getRows();
        double xres = regionMap.getXres();
        double yres = regionMap.getYres();
        RandomIter flowIter = CoverageUtilities.getRandomIterator(this.inFlow);
        RandomIter netIter = CoverageUtilities.getRandomIterator(this.inNet);
        RandomIter slopeIter = CoverageUtilities.getRandomIterator(this.inSlope);
        int flowNv = HMConstants.getIntNovalue(this.inFlow);
        double netNv = HMConstants.getNovalue(this.inNet);
        Object weightsIter = this.inWeights != null ? CoverageUtilities.getRandomIterator(this.inWeights) : new ConstantRandomIter(this.pWeight);
        WritableRaster[] connectivityRasterHolder = new WritableRaster[1];
        this.outConnectivity = CoverageUtilities.createCoverageFromTemplate(this.inFlow, -9999.0, connectivityRasterHolder);
        WritableRandomIter connectivityIter = CoverageUtilities.getWritableRandomIterator(connectivityRasterHolder[0]);
        this.pm.beginTask("Calculate downslope connectivity...", nRows);
        for (int r = 0; r < nRows; ++r) {
            if (this.pm.isCanceled()) {
                return;
            }
            for (int c = 0; c < nCols; ++c) {
                FlowNode flowNode = new FlowNode(flowIter, nCols, nRows, c, r, flowNv);
                if (!flowNode.isValid()) continue;
                GridNode netNode = new GridNode(netIter, nCols, nRows, xres, yres, c, r, netNv);
                double connectivitySum = 0.0;
                while (flowNode.isValid() && !netNode.isValid()) {
                    FlowNode nextFlowNode = flowNode.goDownstream();
                    if (nextFlowNode == null) {
                        throw new ModelsRuntimeException("Could not properly navigate the flowdirections. Are you using an extracted basin?", this);
                    }
                    int col = flowNode.col;
                    int nextCol = nextFlowNode.col;
                    int row = flowNode.row;
                    int nextRow = nextFlowNode.row;
                    double distance = Math.sqrt(Math.pow((double)(nextCol - col) * xres, 2.0) + Math.pow((double)(nextRow - row) * yres, 2.0));
                    double weight = weightsIter.getSampleDouble(flowNode.col, flowNode.row, 0);
                    double slope = slopeIter.getSampleDouble(flowNode.col, flowNode.row, 0);
                    if (slope == 0.0) {
                        slope = 0.005;
                    }
                    double Di = distance / weight / slope;
                    connectivitySum += Di;
                    flowNode = nextFlowNode;
                    netNode = new GridNode(netIter, nCols, nRows, xres, yres, nextFlowNode.col, nextFlowNode.row, netNv);
                }
                connectivityIter.setSample(c, r, 0, connectivitySum);
            }
            this.pm.worked(1);
        }
        this.pm.done();
    }
}

