/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.cutout;

import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.multiprocessing.GridMultiProcessing;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;

@Description(value="Module for raster thresholding and masking.")
@Documentation(value="OmsCutOut.html")
@Author(name="Silvia Franceschi, Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Threshold, OmsMapcalc")
@Label(value="Raster Processing")
@Name(value="cutout")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsCutOut
extends GridMultiProcessing {
    @Description(value="The map that has to be processed.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The map to use as mask.")
    @In
    public GridCoverage2D inMask;
    @Description(value="The upper threshold value.")
    @In
    public Double pMax;
    @Description(value="The lower threshold value.")
    @In
    public Double pMin;
    @Description(value="Switch for doing extraction of the mask area or the inverse (negative). Default is false and extract the mask area.")
    @In
    public boolean doInverse = false;
    @Description(value="The processed map.")
    @Out
    public GridCoverage2D outRaster = null;
    public static final String OMSCUTOUT_DESCRIPTION = "Module for raster thresholding and masking.";
    public static final String OMSCUTOUT_DOCUMENTATION = "OmsCutOut.html";
    public static final String OMSCUTOUT_KEYWORDS = "Raster, Threshold, OmsMapcalc";
    public static final String OMSCUTOUT_LABEL = "Raster Processing";
    public static final String OMSCUTOUT_NAME = "cutout";
    public static final int OMSCUTOUT_STATUS = 40;
    public static final String OMSCUTOUT_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSCUTOUT_AUTHORNAMES = "Silvia Franceschi, Andrea Antonello";
    public static final String OMSCUTOUT_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSCUTOUT_IN_RASTER_DESCRIPTION = "The map that has to be processed.";
    public static final String OMSCUTOUT_IN_MASK_DESCRIPTION = "The map to use as mask.";
    public static final String OMSCUTOUT_P_MAX_DESCRIPTION = "The upper threshold value.";
    public static final String OMSCUTOUT_P_MIN_DESCRIPTION = "The lower threshold value.";
    public static final String OMSCUTOUT_DO_INVERSE_DESCRIPTION = "Switch for doing extraction of the mask area or the inverse (negative). Default is false and extract the mask area.";
    public static final String OMSCUTOUT_OUT_RASTER_DESCRIPTION = "The processed map.";
    private RandomIter maskIter;
    private boolean doMax = false;
    private boolean doMin = false;
    private double max = -1.0;
    private double min = -1.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outRaster == null, this.doReset)) {
            return;
        }
        if (this.pMax != null) {
            this.max = this.pMax;
            this.doMax = true;
        }
        if (this.pMin != null) {
            this.min = this.pMin;
            this.doMin = true;
        }
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
        int nCols = regionMap.getCols();
        int nRows = regionMap.getRows();
        RenderedImage geodataRI = this.inRaster.getRenderedImage();
        RandomIter geodataIter = RandomIterFactory.create((RenderedImage)geodataRI, null);
        double maskNv = 0.0;
        if (this.inMask != null) {
            RenderedImage maskRI = this.inMask.getRenderedImage();
            maskNv = HMConstants.getNovalue(this.inMask);
            this.maskIter = RandomIterFactory.create((RenderedImage)maskRI, null);
        }
        WritableRaster outWR = CoverageUtilities.renderedImage2WritableRaster(geodataRI, false);
        WritableRandomIter outIter = RandomIterFactory.createWritable((WritableRaster)outWR, null);
        try {
            double _maskNv = maskNv;
            this.pm.beginTask("Processing map...", nRows * nCols);
            this.processGrid(nCols, nRows, false, (c, r) -> {
                if (this.pm.isCanceled()) {
                    return;
                }
                this.pm.worked(1);
                if (this.maskIter != null) {
                    double maskValue = this.maskIter.getSampleDouble(c, r, 0);
                    if (!this.doInverse) {
                        if (HMConstants.isNovalue(maskValue, _maskNv)) {
                            outIter.setSample(c, r, 0, -9999.0);
                            return;
                        }
                    } else if (!HMConstants.isNovalue(maskValue, _maskNv)) {
                        outIter.setSample(c, r, 0, -9999.0);
                        return;
                    }
                }
                double value = geodataIter.getSampleDouble(c, r, 0);
                if (this.doMax && value > this.max) {
                    outIter.setSample(c, r, 0, -9999.0);
                    return;
                }
                if (this.doMin && value < this.min) {
                    outIter.setSample(c, r, 0, -9999.0);
                }
            });
            this.pm.done();
        }
        finally {
            geodataIter.done();
            outIter.done();
            if (this.maskIter != null) {
                this.maskIter.done();
            }
        }
        this.outRaster = CoverageUtilities.buildCoverage(OMSCUTOUT_NAME, outWR, (HashMap<String, Double>)regionMap, this.inRaster.getCoordinateReferenceSystem());
    }

    public static GridCoverage2D cut(GridCoverage2D raster, GridCoverage2D mask) throws Exception {
        OmsCutOut cutDrain = new OmsCutOut();
        cutDrain.inRaster = raster;
        cutDrain.inMask = mask;
        cutDrain.process();
        return cutDrain.outRaster;
    }
}

