/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.edgedetection;

import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import javax.media.jai.RasterFactory;

public class Canny {
    private static final float GAUSSIAN_CUT_OFF = 0.005f;
    private static final float MAGNITUDE_SCALE = 100.0f;
    private static final float MAGNITUDE_LIMIT = 1000.0f;
    private static final int MAGNITUDE_MAX = 100000;
    private int height;
    private int width;
    private int picsize;
    private int[] data;
    private int[] magnitude;
    private RenderedImage sourceImage;
    private float gaussianKernelRadius;
    private float lowThreshold;
    private float highThreshold;
    private int gaussianKernelWidth;
    private boolean contrastNormalized;
    private float[] xConv;
    private float[] yConv;
    private float[] xGradient;
    private float[] yGradient;
    private WritableRaster edgesRaster;
    private WritableRaster magnitudeRaster;
    private WritableRaster xgradRaster;
    private WritableRaster ygradRaster;

    public Canny() {
        this.lowThreshold = 2.5f;
        this.highThreshold = 7.5f;
        this.gaussianKernelRadius = 2.0f;
        this.gaussianKernelWidth = 16;
        this.contrastNormalized = false;
    }

    public Canny(Float lowThreshold, Float highThreshold, Float gaussianKernelRadius, Integer gaussianKernelWidth, Boolean contrastNormalized, RenderedImage sourceImage) {
        this.sourceImage = sourceImage;
        this.lowThreshold = lowThreshold == null ? 2.5f : lowThreshold.floatValue();
        this.highThreshold = highThreshold == null ? 7.5f : highThreshold.floatValue();
        this.gaussianKernelRadius = gaussianKernelRadius == null ? 2.0f : gaussianKernelRadius.floatValue();
        this.gaussianKernelWidth = gaussianKernelWidth == null ? 16 : gaussianKernelWidth;
        this.contrastNormalized = contrastNormalized == null ? false : contrastNormalized;
    }

    public RenderedImage getSourceImage() {
        return this.sourceImage;
    }

    public void setSourceImage(RenderedImage image) {
        this.sourceImage = image;
    }

    public float getLowThreshold() {
        return this.lowThreshold;
    }

    public void setLowThreshold(float threshold) {
        if (threshold < 0.0f) {
            throw new IllegalArgumentException();
        }
        this.lowThreshold = threshold;
    }

    public float getHighThreshold() {
        return this.highThreshold;
    }

    public void setHighThreshold(float threshold) {
        if (threshold < 0.0f) {
            throw new IllegalArgumentException();
        }
        this.highThreshold = threshold;
    }

    public int getGaussianKernelWidth() {
        return this.gaussianKernelWidth;
    }

    public void setGaussianKernelWidth(int gaussianKernelWidth) {
        if (gaussianKernelWidth < 2) {
            throw new IllegalArgumentException();
        }
        this.gaussianKernelWidth = gaussianKernelWidth;
    }

    public float getGaussianKernelRadius() {
        return this.gaussianKernelRadius;
    }

    public void setGaussianKernelRadius(float gaussianKernelRadius) {
        if (gaussianKernelRadius < 0.1f) {
            throw new IllegalArgumentException();
        }
        this.gaussianKernelRadius = gaussianKernelRadius;
    }

    public boolean isContrastNormalized() {
        return this.contrastNormalized;
    }

    public void setContrastNormalized(boolean contrastNormalized) {
        this.contrastNormalized = contrastNormalized;
    }

    public void process() {
        this.width = this.sourceImage.getWidth();
        this.height = this.sourceImage.getHeight();
        this.picsize = this.width * this.height;
        this.initArrays();
        this.readLuminance();
        if (this.contrastNormalized) {
            this.normalizeContrast();
        }
        this.computeGradients(this.gaussianKernelRadius, this.gaussianKernelWidth);
        int low = Math.round(this.lowThreshold * 100.0f);
        int high = Math.round(this.highThreshold * 100.0f);
        this.performHysteresis(low, high);
        this.thresholdEdges();
        this.writeEdges();
    }

    private void initArrays() {
        if (this.data == null || this.picsize != this.data.length) {
            this.data = new int[this.picsize];
            this.magnitude = new int[this.picsize];
            this.xConv = new float[this.picsize];
            this.yConv = new float[this.picsize];
            this.xGradient = new float[this.picsize];
            this.yGradient = new float[this.picsize];
        }
    }

    private void computeGradients(float kernelRadius, int kernelWidth) {
        int y;
        int x;
        float g1;
        int kwidth;
        float[] kernel = new float[kernelWidth];
        float[] diffKernel = new float[kernelWidth];
        for (kwidth = 0; !(kwidth >= kernelWidth || (g1 = this.gaussian(kwidth, kernelRadius)) <= 0.005f && kwidth >= 2); ++kwidth) {
            float g2 = this.gaussian((float)kwidth - 0.5f, kernelRadius);
            float g3 = this.gaussian((float)kwidth + 0.5f, kernelRadius);
            kernel[kwidth] = (g1 + g2 + g3) / 3.0f / ((float)Math.PI * 2 * kernelRadius * kernelRadius);
            diffKernel[kwidth] = g3 - g2;
        }
        int initX = kwidth - 1;
        int maxX = this.width - (kwidth - 1);
        int initY = this.width * (kwidth - 1);
        int maxY = this.width * (this.height - (kwidth - 1));
        for (x = initX; x < maxX; ++x) {
            for (y = initY; y < maxY; y += this.width) {
                float sumX;
                int index = x + y;
                float sumY = sumX = (float)this.data[index] * kernel[0];
                int yOffset = this.width;
                for (int xOffset = 1; xOffset < kwidth; ++xOffset) {
                    sumY += kernel[xOffset] * (float)(this.data[index - yOffset] + this.data[index + yOffset]);
                    sumX += kernel[xOffset] * (float)(this.data[index - xOffset] + this.data[index + xOffset]);
                    yOffset += this.width;
                }
                this.yConv[index] = sumY;
                this.xConv[index] = sumX;
            }
        }
        for (x = initX; x < maxX; ++x) {
            for (y = initY; y < maxY; y += this.width) {
                float sum = 0.0f;
                int index = x + y;
                for (int i = 1; i < kwidth; ++i) {
                    sum += diffKernel[i] * (this.yConv[index - i] - this.yConv[index + i]);
                }
                this.xGradient[index] = sum;
            }
        }
        for (x = kwidth; x < this.width - kwidth; ++x) {
            for (y = initY; y < maxY; y += this.width) {
                float sum = 0.0f;
                int index = x + y;
                int yOffset = this.width;
                for (int i = 1; i < kwidth; ++i) {
                    sum += diffKernel[i] * (this.xConv[index - yOffset] - this.xConv[index + yOffset]);
                    yOffset += this.width;
                }
                this.yGradient[index] = sum;
            }
        }
        initX = kwidth;
        maxX = this.width - kwidth;
        initY = this.width * kwidth;
        maxY = this.width * (this.height - kwidth);
        for (x = initX; x < maxX; ++x) {
            for (y = initY; y < maxY; y += this.width) {
                block16: {
                    float gradMag;
                    block17: {
                        float f;
                        float tmp;
                        float nwMag;
                        float seMag;
                        float sMag;
                        float nMag;
                        float yGrad;
                        float xGrad;
                        block18: {
                            float f2;
                            float eMag;
                            float wMag;
                            block14: {
                                float f3;
                                float swMag;
                                float neMag;
                                block15: {
                                    float f4;
                                    int index = x + y;
                                    int indexN = index - this.width;
                                    int indexS = index + this.width;
                                    int indexW = index - 1;
                                    int indexE = index + 1;
                                    int indexNW = indexN - 1;
                                    int indexNE = indexN + 1;
                                    int indexSW = indexS - 1;
                                    int indexSE = indexS + 1;
                                    xGrad = this.xGradient[index];
                                    yGrad = this.yGradient[index];
                                    gradMag = this.hypot(xGrad, yGrad);
                                    nMag = this.hypot(this.xGradient[indexN], this.yGradient[indexN]);
                                    sMag = this.hypot(this.xGradient[indexS], this.yGradient[indexS]);
                                    wMag = this.hypot(this.xGradient[indexW], this.yGradient[indexW]);
                                    eMag = this.hypot(this.xGradient[indexE], this.yGradient[indexE]);
                                    neMag = this.hypot(this.xGradient[indexNE], this.yGradient[indexNE]);
                                    seMag = this.hypot(this.xGradient[indexSE], this.yGradient[indexSE]);
                                    swMag = this.hypot(this.xGradient[indexSW], this.yGradient[indexSW]);
                                    nwMag = this.hypot(this.xGradient[indexNW], this.yGradient[indexNW]);
                                    if (!(xGrad * yGrad <= 0.0f)) break block14;
                                    if (!(Math.abs(xGrad) >= Math.abs(yGrad))) break block15;
                                    tmp = Math.abs(xGrad * gradMag);
                                    if (!(f4 >= Math.abs(yGrad * neMag - (xGrad + yGrad) * eMag)) || !(tmp > Math.abs(yGrad * swMag - (xGrad + yGrad) * wMag))) break block16;
                                    break block17;
                                }
                                tmp = Math.abs(yGrad * gradMag);
                                if (!(f3 >= Math.abs(xGrad * neMag - (yGrad + xGrad) * nMag)) || !(tmp > Math.abs(xGrad * swMag - (yGrad + xGrad) * sMag))) break block16;
                                break block17;
                            }
                            if (!(Math.abs(xGrad) >= Math.abs(yGrad))) break block18;
                            tmp = Math.abs(xGrad * gradMag);
                            if (!(f2 >= Math.abs(yGrad * seMag + (xGrad - yGrad) * eMag)) || !(tmp > Math.abs(yGrad * nwMag + (xGrad - yGrad) * wMag))) break block16;
                            break block17;
                        }
                        tmp = Math.abs(yGrad * gradMag);
                        if (!(f >= Math.abs(xGrad * seMag + (yGrad - xGrad) * sMag)) || !(tmp > Math.abs(xGrad * nwMag + (yGrad - xGrad) * nMag))) break block16;
                    }
                    this.magnitude[index] = gradMag >= 1000.0f ? 100000 : (int)(100.0f * gradMag);
                    continue;
                }
                this.magnitude[index] = 0;
            }
        }
    }

    private float hypot(float x, float y) {
        return (float)Math.hypot(x, y);
    }

    private float gaussian(float x, float sigma) {
        return (float)Math.exp(-(x * x) / (2.0f * sigma * sigma));
    }

    private void performHysteresis(int low, int high) {
        Arrays.fill(this.data, 0);
        int offset = 0;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (this.data[offset] == 0 && this.magnitude[offset] >= high) {
                    this.follow(x, y, offset, low);
                }
                ++offset;
            }
        }
    }

    private void follow(int x1, int y1, int i1, int threshold) {
        int x0 = x1 == 0 ? x1 : x1 - 1;
        int x2 = x1 == this.width - 1 ? x1 : x1 + 1;
        int y0 = y1 == 0 ? y1 : y1 - 1;
        int y2 = y1 == this.height - 1 ? y1 : y1 + 1;
        this.data[i1] = this.magnitude[i1];
        for (int x = x0; x <= x2; ++x) {
            for (int y = y0; y <= y2; ++y) {
                int i2 = x + y * this.width;
                if (y == y1 && x == x1 || this.data[i2] != 0 || this.magnitude[i2] < threshold) continue;
                this.follow(x, y, i2, threshold);
                return;
            }
        }
    }

    private void thresholdEdges() {
        for (int i = 0; i < this.picsize; ++i) {
            this.data[i] = this.data[i] > 0 ? -1 : -16777216;
        }
    }

    private void readLuminance() {
        block5: {
            Object dataElements;
            block7: {
                block6: {
                    block4: {
                        Raster r = this.sourceImage.getData();
                        dataElements = r.getDataElements(0, 0, this.width, this.height, null);
                        if (!(dataElements instanceof double[])) break block4;
                        double[] pixels = (double[])dataElements;
                        for (int i = 0; i < this.picsize; ++i) {
                            this.data[i] = (int)(pixels[i] * 10000.0);
                        }
                        break block5;
                    }
                    if (!(dataElements instanceof float[])) break block6;
                    float[] pixels = (float[])dataElements;
                    for (int i = 0; i < this.picsize; ++i) {
                        this.data[i] = (int)(pixels[i] * 10000.0f);
                    }
                    break block5;
                }
                if (!(dataElements instanceof int[])) break block7;
                int[] pixels = (int[])dataElements;
                for (int i = 0; i < this.picsize; ++i) {
                    this.data[i] = pixels[i] * 10000;
                }
                break block5;
            }
            if (!(dataElements instanceof short[])) break block5;
            short[] pixels = (short[])dataElements;
            for (int i = 0; i < this.picsize; ++i) {
                this.data[i] = pixels[i] * 10000;
            }
        }
    }

    private void normalizeContrast() {
        int i;
        int[] histogram = new int[256];
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            int n = this.data[i2];
            histogram[n] = histogram[n] + 1;
        }
        int[] remap = new int[256];
        int sum = 0;
        int j = 0;
        for (i = 0; i < histogram.length; ++i) {
            int target = (sum += histogram[i]) * 255 / this.picsize;
            for (int k = j + 1; k <= target; ++k) {
                remap[k] = i;
            }
            j = target;
        }
        for (i = 0; i < this.data.length; ++i) {
            this.data[i] = remap[this.data[i]];
        }
    }

    private void writeEdges() {
        this.edgesRaster = this.createEdgesRaster(this.width, this.height, this.data);
    }

    public WritableRaster getEdgesRaster() {
        return this.edgesRaster;
    }

    public WritableRaster getMagnitudeRaster() {
        this.magnitudeRaster = this.createDoubleWritableRaster(this.width, this.height, this.magnitude);
        return this.magnitudeRaster;
    }

    public WritableRaster getXgradRaster() {
        this.xgradRaster = this.createDoubleWritableRaster(this.width, this.height, this.xGradient);
        return this.xgradRaster;
    }

    public WritableRaster getYgradRaster() {
        this.ygradRaster = this.createDoubleWritableRaster(this.width, this.height, this.yGradient);
        return this.ygradRaster;
    }

    private WritableRaster createEdgesRaster(int width, int height, int[] pixels) {
        int dataType = 5;
        ComponentSampleModel sampleModel = new ComponentSampleModel(dataType, width, height, 1, width, new int[]{0});
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)sampleModel, null);
        int index = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                double value = pixels[index];
                value = value != -1.0 ? -9999.0 : 1.0;
                raster.setSample(x, y, 0, value);
                ++index;
            }
        }
        return raster;
    }

    private WritableRaster createDoubleWritableRaster(int width, int height, int[] pixels) {
        int dataType = 5;
        ComponentSampleModel sampleModel = new ComponentSampleModel(dataType, width, height, 1, width, new int[]{0});
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)sampleModel, null);
        int index = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                raster.setSample(x, y, 0, (double)pixels[index]);
                ++index;
            }
        }
        return raster;
    }

    private WritableRaster createDoubleWritableRaster(int width, int height, float[] pixels) {
        int dataType = 5;
        ComponentSampleModel sampleModel = new ComponentSampleModel(dataType, width, height, 1, width, new int[]{0});
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)sampleModel, null);
        int index = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                raster.setSample(x, y, 0, (double)pixels[index]);
                ++index;
            }
        }
        return raster;
    }
}

