/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.edgedetection;

import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.edgedetection.Canny;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;

@Description(value="Edge detection operations")
@Author(name="Tom Gibara, Andrea Antonello", contact="http://www.tomgibara.com/computer-vision/canny-edge-detector, www.hydrologis.com")
@Keywords(value="Edge detection, Raster")
@Label(value="Raster Processing")
@Name(value="omscanny")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsCannyEdgeDetector
extends HMModel {
    @Description(value="The map on which to perform edge detection.")
    @In
    public GridCoverage2D inMap = null;
    @Description(value="The low threshold for the algorithm (default = 2.5).")
    @In
    public Float pLowthres = Float.valueOf(2.5f);
    @Description(value="The hight threshold for the algorithm (default = 7.5).")
    @In
    public Float pHighthres = Float.valueOf(7.5f);
    @Description(value="The radius of the gaussian kernel (default = 2).")
    @In
    public Float pRadiusgauss = Float.valueOf(2.0f);
    @Description(value="The width of the gaussian kernel (default= 16).")
    @In
    public Integer pWidthgauss = 16;
    @Description(value="Switch to normalize the contrast.")
    @In
    public boolean doNormcontrast = false;
    @Description(value="The resulting map.")
    @Out
    public GridCoverage2D outMap = null;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outMap == null, this.doReset)) {
            return;
        }
        RenderedImage renderedImage = this.inMap.getRenderedImage();
        Canny canny = new Canny(this.pLowthres, this.pHighthres, this.pRadiusgauss, this.pWidthgauss, this.doNormcontrast, renderedImage);
        this.pm.beginTask("Processing edgedetection...", -1);
        canny.process();
        this.pm.done();
        WritableRaster edgesWR = canny.getEdgesRaster();
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inMap);
        this.outMap = CoverageUtilities.buildCoverage("canny", edgesWR, (HashMap<String, Double>)regionMap, this.inMap.getCoordinateReferenceSystem());
    }
}

