/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.filter;

import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import javax.media.jai.KernelJAI;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.jaitools.media.jai.kernel.KernelFactory;

@Description(value="A Kernel based filter.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="kernel, filter, raster")
@Label(value="Raster Processing")
@Name(value="kernelfilter")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsKernelFilter
extends HMModel {
    @Description(value="An input raster")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The kernel to use.")
    @UI(value="combo:binary,cosine,distance,epanechnikov,gaussian,inverse_distance,quartic,triangular,triweight")
    @In
    public String pKernel = "epanechnikov";
    @Description(value="The kernel radius to use in cells (default = 10).")
    @In
    public int pRadius = 10;
    @Description(value="Filtered raster")
    @Out
    public GridCoverage2D outRaster;

    public void process() throws Exception {
        this.checkNull(this.inRaster);
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        KernelFactory.ValueType type = OmsKernelFilter.getKernelType(this.pKernel);
        KernelJAI kernel = KernelFactory.createCircle((int)this.pRadius, (KernelFactory.ValueType)type);
        RenderedImage inImg = this.inRaster.getRenderedImage();
        RandomIter inIter = RandomIterFactory.create((RenderedImage)inImg, null);
        WritableRaster outWR = CoverageUtilities.createWritableRaster(cols, rows, null, null, -9999.0);
        WritableRandomIter outIter = RandomIterFactory.createWritable((WritableRaster)outWR, null);
        float[] kernelData = kernel.getKernelData();
        this.pm.beginTask("Processing...", cols - 2 * this.pRadius);
        for (int r = this.pRadius; r < rows - this.pRadius; ++r) {
            for (int c = this.pRadius; c < cols - this.pRadius; ++c) {
                double kernelSum = 0.0;
                int k = 0;
                double outputValue = 0.0;
                int kr = -this.pRadius;
                while (kr <= this.pRadius) {
                    for (int kc = -this.pRadius; kc <= this.pRadius; ++kc) {
                        double value = inIter.getSampleDouble(c + kc, r + kr, 0);
                        if (HMConstants.isNovalue(value)) continue;
                        outputValue += value * (double)kernelData[k];
                        kernelSum += (double)kernelData[k];
                    }
                    ++kr;
                    ++k;
                }
                outIter.setSample(c, r, 0, outputValue / kernelSum);
            }
            this.pm.worked(1);
        }
        this.pm.done();
        this.outRaster = CoverageUtilities.buildCoverage("filtered", outWR, (HashMap<String, Double>)regionMap, this.inRaster.getCoordinateReferenceSystem());
    }

    private static KernelFactory.ValueType getKernelType(String pKernel2) {
        KernelFactory.ValueType type = null;
        if ((pKernel2 = pKernel2.trim()).equals("binary")) {
            type = KernelFactory.ValueType.BINARY;
        } else if (pKernel2.equals("cosine")) {
            type = KernelFactory.ValueType.COSINE;
        } else if (pKernel2.equals("distance")) {
            type = KernelFactory.ValueType.DISTANCE;
        } else if (pKernel2.equals("gaussian")) {
            type = KernelFactory.ValueType.GAUSSIAN;
        } else if (pKernel2.equals("inverse_distance")) {
            type = KernelFactory.ValueType.INVERSE_DISTANCE;
        } else if (pKernel2.equals("quartic")) {
            type = KernelFactory.ValueType.QUARTIC;
        } else if (pKernel2.equals("triangular")) {
            type = KernelFactory.ValueType.TRIANGULAR;
        } else if (pKernel2.equals("triweight")) {
            type = KernelFactory.ValueType.TRIWEIGHT;
        } else if (pKernel2.equals("epanechnikov")) {
            type = KernelFactory.ValueType.EPANECHNIKOV;
        } else {
            throw new ModelsIllegalargumentException("Kernel type not recognised: " + pKernel2, "OmsKernelFilter");
        }
        return type;
    }

    public static double[] gaussianSmooth(double[] values, int kernelRadius) throws Exception {
        int i;
        int size = values.length;
        double[] newValues = new double[values.length];
        double[] kernelData2D = OmsKernelFilter.makeGaussianKernel(kernelRadius);
        for (i = 0; i < kernelRadius; ++i) {
            newValues[i] = values[i];
        }
        for (int r = kernelRadius; r < size - kernelRadius; ++r) {
            double kernelSum = 0.0;
            double outputValue = 0.0;
            int k = 0;
            int kc = -kernelRadius;
            while (kc <= kernelRadius) {
                double value = values[r + kc];
                if (!HMConstants.isNovalue(value)) {
                    outputValue += value * kernelData2D[k];
                    kernelSum += kernelData2D[k];
                }
                ++kc;
                ++k;
            }
            newValues[r] = outputValue / kernelSum;
        }
        for (i = size - kernelRadius; i < size; ++i) {
            newValues[i] = values[i];
        }
        return newValues;
    }

    public static double[] averageSmooth(double[] values, int lookAhead) throws Exception {
        int i;
        int size = values.length;
        double[] newValues = new double[values.length];
        for (i = 0; i < lookAhead; ++i) {
            newValues[i] = values[i];
        }
        for (i = lookAhead; i < size - lookAhead; ++i) {
            double sum = 0.0;
            int k = 0;
            for (int l = -lookAhead; l <= lookAhead; ++l) {
                double value = values[i + l];
                if (HMConstants.isNovalue(value)) continue;
                sum += value;
                ++k;
            }
            newValues[i] = sum / (double)k;
        }
        for (i = size - lookAhead; i < size; ++i) {
            newValues[i] = values[i];
        }
        return newValues;
    }

    public static double[] makeGaussianKernel(int radius) {
        int rows = radius * 2 + 1;
        double r = radius;
        double[] matrix = new double[rows];
        double sigma = r / 3.0;
        double sigma22 = 2.0 * sigma * sigma;
        double sigmaPi2 = Math.PI * 2 * sigma;
        double sqrtSigmaPi2 = Math.sqrt(sigmaPi2);
        double radius2 = r * r;
        double total = 0.0;
        int index = 0;
        for (int row = -radius; row <= radius; ++row) {
            double distance = row * row;
            matrix[index] = distance > radius2 ? 0.0 : Math.exp(-distance / sigma22) / sqrtSigmaPi2;
            total += matrix[index];
            ++index;
        }
        int i = 0;
        while (i < rows) {
            int n = i++;
            matrix[n] = matrix[n] / total;
        }
        return matrix;
    }
}

