/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.filter;

import java.awt.image.WritableRaster;
import java.util.HashMap;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.hortonmachine.gears.io.rasterreader.OmsRasterReader;
import org.hortonmachine.gears.io.rasterwriter.OmsRasterWriter;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;

@Description(value="A sigma selective mean (averaging) filter ")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="raster, filter, sigma")
@Label(value="Raster Processing")
@Name(value="selectivesigmafilter")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsSigmaFilterPlus
extends HMModel {
    @Description(value="The input raster")
    @In
    public GridCoverage2D inGeodata;
    @Description(value="The filter window radius in cells.")
    @In
    public double pRadius = 2.0;
    @Description(value="Pixel value range in sigmas")
    @In
    public double pSigmaWidth = 2.0;
    @Description(value="The output raster")
    @Out
    public GridCoverage2D outGeodata;
    private double minPixFraction = 0.2;
    private boolean outlierAware = true;
    private int nPasses = 1;
    protected int kRadius;
    protected int kNPoints;
    protected int[] lineRadius;

    public static void main(String[] args) throws Exception {
        String inPath = "/home/hydrologis/TMP/R3GIS/data/planetscope_20191018_092049_0f15_sat0f15_epsg32634.tiff";
        String outPath = "/home/hydrologis/TMP/R3GIS/data/planetscope_20191018_092049_0f15_sat0f15_epsg32634_sigma.tiff";
        OmsSigmaFilterPlus sf = new OmsSigmaFilterPlus();
        sf.inGeodata = OmsRasterReader.readRaster(inPath);
        sf.pRadius = 5.0;
        sf.pSigmaWidth = 2.5;
        sf.process();
        GridCoverage2D outSigma = sf.outGeodata;
        OmsRasterWriter.writeRaster(outPath, outSigma);
    }

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inGeodata);
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inGeodata);
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        double[] pixels = CoverageUtilities.renderedImage2DoubleArray(this.inGeodata.getRenderedImage(), 3);
        if (this.pRadius >= 1.5 && this.pRadius < 1.75) {
            this.pRadius = 1.75;
        } else if (this.pRadius >= 2.5 && this.pRadius < 2.85) {
            this.pRadius = 2.85;
        }
        int r2 = (int)(this.pRadius * this.pRadius) + 1;
        this.kRadius = (int)Math.sqrt((double)r2 + 1.0E-10);
        this.lineRadius = new int[2 * this.kRadius + 1];
        this.lineRadius[this.kRadius] = this.kRadius;
        this.kNPoints = 2 * this.kRadius + 1;
        for (int y = 1; y <= this.kRadius; ++y) {
            int dx;
            this.lineRadius[this.kRadius + y] = dx = (int)Math.sqrt((double)(r2 - y * y) + 1.0E-10);
            this.lineRadius[this.kRadius - y] = dx;
            this.kNPoints += 4 * dx + 2;
        }
        for (int pass = 0; pass < this.nPasses; ++pass) {
            int minPixNumber = (int)((double)this.kNPoints * this.minPixFraction + 0.999999);
            pixels = this.doFiltering(pixels, cols, rows, this.kRadius, this.lineRadius, this.pSigmaWidth, minPixNumber, this.outlierAware);
        }
        WritableRaster outWR = CoverageUtilities.doubleArray2WritableRaster(pixels, cols, rows);
        this.outGeodata = CoverageUtilities.buildCoverage("sigma", outWR, (HashMap<String, Double>)regionMap, this.inGeodata.getCoordinateReferenceSystem());
    }

    public double[] doFiltering(double[] pixels, int cols, int rows, int kRadius, int[] lineRadius, double sigmaWidth, int minPixNumber, boolean outlierAware) {
        int xmin = -kRadius;
        int xEnd = cols;
        int xmax = xEnd + kRadius;
        int kSize = 2 * kRadius + 1;
        int cacheWidth = xmax - xmin;
        int xminInside = xmin > 0 ? xmin : 0;
        int xmaxInside = xmax < cols ? xmax : cols;
        int widthInside = xmaxInside - xminInside;
        boolean smallKernel = kRadius < 2;
        double[] cache = new double[cacheWidth * kSize];
        int iCache = 0;
        for (int y = 0 - kRadius; y < rows + kRadius; ++y) {
            int x = xmin;
            while (x < xmax) {
                cache[iCache] = pixels[(x < 0 ? 0 : (x >= cols ? cols - 1 : x)) + cols * (y < 0 ? 0 : (y >= rows ? rows - 1 : y))];
                ++x;
                ++iCache;
            }
        }
        int nextLineInCache = 2 * kRadius;
        double[] sums = new double[2];
        this.pm.beginTask("Processing...", rows);
        for (int y = 0; y < rows; ++y) {
            int ynext = y + kRadius;
            if (ynext >= rows) {
                ynext = rows - 1;
            }
            double leftpxl = pixels[cols * ynext];
            double rightpxl = pixels[cols - 1 + cols * ynext];
            int iCache2 = cacheWidth * nextLineInCache;
            int x = xmin;
            while (x < 0) {
                cache[iCache2] = leftpxl;
                ++x;
                ++iCache2;
            }
            System.arraycopy(pixels, xminInside + cols * ynext, cache, iCache2, widthInside);
            iCache2 += widthInside;
            x = cols;
            while (x < xmax) {
                cache[iCache2] = rightpxl;
                ++x;
                ++iCache2;
            }
            nextLineInCache = (nextLineInCache + 1) % kSize;
            boolean fullCalculation = true;
            int x2 = 0;
            int p = x2 + y * cols;
            int xCache0 = kRadius;
            while (x2 < xEnd) {
                double value = pixels[p];
                if (fullCalculation) {
                    fullCalculation = smallKernel;
                    this.getAreaSums(cache, cacheWidth, xCache0, lineRadius, kSize, sums);
                } else {
                    this.addSideSums(cache, cacheWidth, xCache0, lineRadius, kSize, sums);
                }
                double mean = sums[0] / (double)this.kNPoints;
                double variance = sums[1] / (double)this.kNPoints - mean * mean;
                double sigmaRange = sigmaWidth * Math.sqrt(variance);
                double sigmaBottom = value - sigmaRange;
                double sigmaTop = value + sigmaRange;
                double sum = 0.0;
                int count = 0;
                for (int y1 = 0; y1 < kSize; ++y1) {
                    int x1 = xCache0 - lineRadius[y1];
                    int iCache1 = y1 * cacheWidth + x1;
                    while (x1 <= xCache0 + lineRadius[y1]) {
                        double v = cache[iCache1];
                        if (v >= sigmaBottom && v <= sigmaTop) {
                            sum += v;
                            ++count;
                        }
                        ++x1;
                        ++iCache1;
                    }
                }
                pixels[p] = count >= minPixNumber ? sum / (double)count : (outlierAware ? (sums[0] - value) / (double)(this.kNPoints - 1) : mean);
                ++x2;
                ++p;
                ++xCache0;
            }
            int newLineRadius0 = lineRadius[kSize - 1];
            System.arraycopy(lineRadius, 0, lineRadius, 1, kSize - 1);
            lineRadius[0] = newLineRadius0;
            this.pm.worked(1);
        }
        this.pm.done();
        return pixels;
    }

    private void getAreaSums(double[] cache, int cacheWidth, int xCache0, int[] lineRadius, int kSize, double[] sums) {
        double sum = 0.0;
        double sum2 = 0.0;
        for (int y = 0; y < kSize; ++y) {
            int x = xCache0 - lineRadius[y];
            int iCache = y * cacheWidth + x;
            while (x <= xCache0 + lineRadius[y]) {
                double v = cache[iCache];
                sum += v;
                sum2 += v * v;
                ++x;
                ++iCache;
            }
        }
        sums[0] = sum;
        sums[1] = sum2;
    }

    private void addSideSums(double[] cache, int cacheWidth, int xCache0, int[] lineRadius, int kSize, double[] sums) {
        double sum = 0.0;
        double sum2 = 0.0;
        for (int y = 0; y < kSize; ++y) {
            int iCache0 = y * cacheWidth + xCache0;
            double v = cache[iCache0 + lineRadius[y]];
            sum += v;
            sum2 += v * v;
            v = cache[iCache0 - lineRadius[y] - 1];
            sum -= v;
            sum2 -= v * v;
        }
        sums[0] = sums[0] + sum;
        sums[1] = sums[1] + sum2;
    }
}

