/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.holefiller;

import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.interpolation2d.core.IDWInterpolator;
import org.hortonmachine.gears.modules.r.interpolation2d.core.ISurfaceInterpolator;
import org.hortonmachine.gears.modules.r.interpolation2d.core.TPSInterpolator;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.TransformException;

@Description(value="Module that fills raster holes using interpolation.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Holefiller, Raster")
@Label(value="Raster Processing")
@Name(value="holefiller")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsHoleFiller
extends HMModel {
    @Description(value="The raster to fill holes in.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The regions vector map on which to checkc for nulls.")
    @In
    public SimpleFeatureCollection inROI;
    @Description(value="The interpolation mode to use.")
    @UI(value="combo:TPS,IDW")
    @In
    public String pMode = "TPS";
    @Description(value="The buffer to use for interpolation.")
    @Unit(value="m")
    @In
    public double pBuffer = 4.0;
    @Description(value="The new raster.")
    @Out
    public GridCoverage2D outRaster;
    public static final String OMSHOLEFILLER_DESCRIPTION = "Module that fills raster holes using interpolation.";
    public static final String OMSHOLEFILLER_DOCUMENTATION = "";
    public static final String OMSHOLEFILLER_KEYWORDS = "Holefiller, Raster";
    public static final String OMSHOLEFILLER_LABEL = "Raster Processing";
    public static final String OMSHOLEFILLER_NAME = "holefiller";
    public static final int OMSHOLEFILLER_STATUS = 40;
    public static final String OMSHOLEFILLER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSHOLEFILLER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSHOLEFILLER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSHOLEFILLER_IN_RASTER_DESCRIPTION = "The raster to fill holes in.";
    public static final String OMSHOLEFILLER_MODE_DESCRIPTION = "The interpolation mode to use.";
    public static final String OMSHOLEFILLER_P_BUFFER_DESCRIPTION = "The buffer to use for interpolation.";
    public static final String OMSHOLEFILLER_IN_ROI_DESCRIPTION = "The regions vector map on which to checkc for nulls.";
    public static final String OMSHOLEFILLER_OUT_RASTER_DESCRIPTION = "The new raster.";

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inRaster);
        ISurfaceInterpolator interpolator = this.pMode.equals("IDW") ? new IDWInterpolator(this.pBuffer) : new TPSInterpolator(this.pBuffer);
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
        int rows = regionMap.getRows();
        int cols = regionMap.getCols();
        WritableRaster outWR = CoverageUtilities.renderedImage2WritableRaster(this.inRaster.getRenderedImage(), false);
        WritableRandomIter outIter = CoverageUtilities.getWritableRandomIterator(outWR);
        GridGeometry2D gridGeometry = this.inRaster.getGridGeometry();
        PreparedGeometry preparedRoi = null;
        if (this.inROI != null) {
            List<Geometry> roiList = FeatureUtilities.featureCollectionToGeometriesList(this.inROI, false, null);
            GeometryCollection gc = new GeometryCollection(roiList.toArray(GeometryUtilities.TYPE_GEOMETRY), this.gf);
            preparedRoi = PreparedGeometryFactory.prepare((Geometry)gc);
        }
        this.pm.beginTask("Filling holes...", cols - 2);
        for (int r = 1; r < rows - 1; ++r) {
            for (int c = 1; c < cols - 1; ++c) {
                List<Coordinate> surroundingValids;
                if (this.pm.isCanceled()) {
                    return;
                }
                double value = outIter.getSampleDouble(c, r, 0);
                if (!HMConstants.isNovalue(value)) continue;
                DirectPosition worldPosition = gridGeometry.gridToWorld(new GridCoordinates2D(c, r));
                double[] coordinate = worldPosition.getCoordinate();
                Coordinate pointCoordinate = new Coordinate(coordinate[0], coordinate[1]);
                Point point = this.gf.createPoint(pointCoordinate);
                if (preparedRoi != null && !preparedRoi.intersects((Geometry)point) || (surroundingValids = this.getValidSurroundingPoints(outIter, gridGeometry, c, r)).size() <= 3) continue;
                double newValue = interpolator.getValue(surroundingValids.toArray(new Coordinate[0]), pointCoordinate);
                outIter.setSample(c, r, 0, newValue);
            }
            this.pm.worked(1);
        }
        this.pm.done();
        outIter.done();
        this.outRaster = CoverageUtilities.buildCoverage("nulled", outWR, (HashMap<String, Double>)regionMap, this.inRaster.getCoordinateReferenceSystem());
    }

    private List<Coordinate> getValidSurroundingPoints(WritableRandomIter outIter, GridGeometry2D gridGeometry, int c, int r) throws TransformException {
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        for (int dc = -1; dc <= 1; ++dc) {
            for (int dr = -1; dr <= 1; ++dr) {
                double value;
                if (dc == 0 && dr == 0 || HMConstants.isNovalue(value = outIter.getSampleDouble(c + dc, r + dr, 0))) continue;
                DirectPosition worldPosition = gridGeometry.gridToWorld(new GridCoordinates2D(c + dc, r + dr));
                double[] coordinate = worldPosition.getCoordinate();
                Coordinate pointCoordinate = new Coordinate(coordinate[0], coordinate[1]);
                pointCoordinate.z = value;
                coords.add(pointCoordinate);
            }
        }
        return coords;
    }
}

