/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.interpolation2d;

import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.interpolation2d.core.IDWInterpolator;
import org.hortonmachine.gears.modules.r.interpolation2d.core.ISurfaceInterpolator;
import org.hortonmachine.gears.modules.r.interpolation2d.core.TPSInterpolator;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.geometry.EGeometryType;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.strtree.STRtree;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.TransformException;

@Description(value="Thin Plate Spline and IWD Interpolators")
@Documentation(value="")
@Author(name="Jan Jezek, Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="Interpolation, Raster, Spline")
@Label(value="Raster Processing")
@Name(value="surfaceinterpolator")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsSurfaceInterpolator
extends HMModel {
    @Description(value="The input vector map of points.")
    @In
    public SimpleFeatureCollection inVector;
    @Description(value="The grid on which to interpolate.")
    @In
    public GridCoverage2D inGrid = null;
    @Description(value="A mask raster map. Values will be computed only where the mask has values.")
    @In
    public GridCoverage2D inMask = null;
    @Description(value="Field from which to take the category value.")
    @In
    public String fCat;
    @Description(value="Interpolation mode.")
    @UI(value="combo:TPS,IDW")
    @In
    public String pMode = "TPS";
    @Description(value="The buffer to use for interpolation.")
    @Unit(value="m")
    @In
    public double pBuffer = 4.0;
    @Description(value="Max threads to use.")
    @In
    public int pMaxThreads = OmsSurfaceInterpolator.getDefaultThreadsNum();
    @Description(value="The interpolated raster")
    @Out
    public GridCoverage2D outRaster = null;
    private ISurfaceInterpolator interpolator;
    private STRtree coordinatesSpatialTree;
    private GridGeometry2D gridGeometry;

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inGrid);
        this.gridGeometry = this.inGrid.getGridGeometry();
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inGrid);
        final int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        this.coordinatesSpatialTree = new STRtree();
        if (this.inVector != null) {
            this.checkNull(this.fCat);
            GeometryDescriptor geometryDescriptor = ((SimpleFeatureType)this.inVector.getSchema()).getGeometryDescriptor();
            if (!EGeometryType.isPoint(geometryDescriptor)) {
                throw new ModelsIllegalargumentException("The geometry has to be a point geometry.", this, this.pm);
            }
            SimpleFeatureIterator featureIterator = this.inVector.features();
            Coordinate[] coordinates = new Coordinate[this.inVector.size()];
            int index = 0;
            this.pm.beginTask("Indexing control points...", coordinates.length);
            while (featureIterator.hasNext()) {
                double value;
                SimpleFeature feature = (SimpleFeature)featureIterator.next();
                Geometry geometry = (Geometry)feature.getDefaultGeometry();
                coordinates[index] = geometry.getCoordinate();
                coordinates[index].z = value = ((Number)feature.getAttribute(this.fCat)).doubleValue();
                Envelope env = new Envelope(coordinates[index]);
                this.coordinatesSpatialTree.insert(env, (Object)coordinates[index]);
                this.pm.worked(1);
            }
            this.pm.done();
            this.pm.message("Indexed control points: " + coordinates.length);
        } else {
            this.pm.beginTask("Indexing control points...", cols);
            RandomIter inIter = CoverageUtilities.getRandomIterator(this.inGrid);
            int count = 0;
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < cols; ++c) {
                    double value = inIter.getSampleDouble(c, r, 0);
                    if (HMConstants.isNovalue(value)) continue;
                    Coordinate coordinate = CoverageUtilities.coordinateFromColRow(c, r, this.gridGeometry);
                    coordinate.z = value;
                    Envelope env = new Envelope(coordinate);
                    this.coordinatesSpatialTree.insert(env, (Object)coordinate);
                    ++count;
                }
                this.pm.worked(1);
            }
            this.pm.done();
            this.pm.message("Indexed control points (from input grid): " + count);
        }
        this.coordinatesSpatialTree.build();
        this.interpolator = this.pMode.equals("IDW") ? new IDWInterpolator(this.pBuffer) : new TPSInterpolator(this.pBuffer);
        WritableRaster interpolatedWR = CoverageUtilities.createWritableRaster(cols, rows, null, null, -9999.0);
        final WritableRandomIter interpolatedIter = RandomIterFactory.createWritable((WritableRaster)interpolatedWR, null);
        boolean doMultiThread = this.pMaxThreads > 1;
        ExecutorService fixedThreadPool = null;
        if (doMultiThread) {
            fixedThreadPool = Executors.newFixedThreadPool(this.pMaxThreads);
        }
        this.pm.beginTask("Performing interpolation...", rows);
        final double[] eval = new double[1];
        for (int r = 0; r < rows; ++r) {
            final int row = r;
            if (doMultiThread) {
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        OmsSurfaceInterpolator.this.processing(cols, OmsSurfaceInterpolator.this.coordinatesSpatialTree, interpolatedIter, eval, row);
                    }
                };
                fixedThreadPool.execute(runner);
                continue;
            }
            this.processing(cols, this.coordinatesSpatialTree, interpolatedIter, eval, row);
        }
        if (doMultiThread) {
            try {
                fixedThreadPool.shutdown();
                fixedThreadPool.awaitTermination(30L, TimeUnit.DAYS);
                fixedThreadPool.shutdownNow();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.pm.done();
        this.outRaster = CoverageUtilities.buildCoverage("interpolatedraster", interpolatedWR, (HashMap<String, Double>)regionMap, this.inGrid.getCoordinateReferenceSystem());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processing(int cols, STRtree tree, WritableRandomIter interpolatedIter, double[] eval, int row) {
        try {
            for (int c = 0; c < cols; ++c) {
                DirectPosition gridToWorld = this.gridGeometry.gridToWorld(new GridCoordinates2D(c, row));
                boolean doProcess = true;
                if (this.inMask != null) {
                    this.inMask.evaluate(gridToWorld, eval);
                    if (HMConstants.isNovalue(eval[0])) {
                        doProcess = false;
                    }
                }
                if (!doProcess) continue;
                Coordinate currentCoord = new Coordinate();
                double[] coord = gridToWorld.getCoordinate();
                currentCoord.x = coord[0];
                currentCoord.y = coord[1];
                Envelope env = new Envelope(currentCoord.x - this.pBuffer, currentCoord.x + this.pBuffer, currentCoord.y - this.pBuffer, currentCoord.y + this.pBuffer);
                List result = tree.query(env);
                if (result.size() < 4) continue;
                double value = this.interpolator.getValue(result.toArray(new Coordinate[0]), currentCoord);
                WritableRandomIter writableRandomIter = interpolatedIter;
                synchronized (writableRandomIter) {
                    interpolatedIter.setSample(c, row, 0, value);
                    continue;
                }
            }
            this.pm.worked(1);
        }
        catch (TransformException e) {
            e.printStackTrace();
        }
    }
}

