/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.interpolation2d.core;

import org.hortonmachine.gears.modules.r.interpolation2d.core.ISurfaceInterpolator;
import org.locationtech.jts.geom.Coordinate;

public class IDWInterpolator
implements ISurfaceInterpolator {
    private final double buffer;

    public IDWInterpolator(double buffer) {
        this.buffer = buffer;
    }

    @Override
    public double getValue(Coordinate[] controlPoints, Coordinate interpolated) {
        if (controlPoints.length == 0) {
            return -9999.0;
        }
        double sumdValue = 0.0;
        double sumweight = 0.0;
        for (Coordinate coordinate : controlPoints) {
            double distance = coordinate.distance(interpolated);
            if (distance > this.buffer) continue;
            if (distance < 1.0E-5) {
                distance = 1.0E-5;
            }
            double weight = 1.0 / Math.pow(distance, 2.0);
            sumdValue += coordinate.z * weight;
            sumweight += weight;
        }
        double value = sumdValue / sumweight;
        return value;
    }

    @Override
    public double getBuffer() {
        return this.buffer;
    }
}

