/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.labeler;

import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;

@Description(value="Connected components labeling operation")
@Author(name="Simon Horne, Andrea Antonello", contact="http://homepages.inf.ed.ac.uk/rbf/HIPR2/, www.hydrologis.com")
@Keywords(value="Labeling, Raster")
@Label(value="Raster Processing")
@Name(value="omslabeler")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsLabeler
extends HMModel {
    @Description(value="The map to label.")
    @In
    public GridCoverage2D inMap = null;
    @Description(value="The resulting map.")
    @Out
    public GridCoverage2D outMap = null;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outMap == null, this.doReset)) {
            return;
        }
        RenderedImage renderedImage = this.inMap.getRenderedImage();
        int width = renderedImage.getWidth();
        int height = renderedImage.getHeight();
        int[] data = new int[width * height];
        RandomIter iter = RandomIterFactory.create((RenderedImage)renderedImage, null);
        int index = 0;
        for (int r = 0; r < height; ++r) {
            for (int c = 0; c < width; ++c) {
                double value = iter.getSampleDouble(c, r, 0);
                data[index] = HMConstants.isNovalue(value) ? 0 : 1;
                ++index;
            }
        }
        int[] labelsArray = this.doLabel(data, width, height);
        WritableRaster dataWR = CoverageUtilities.createWritableRasterFromArray(width, height, labelsArray);
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inMap);
        this.outMap = CoverageUtilities.buildCoverage("labeled", dataWR, (HashMap<String, Double>)regionMap, this.inMap.getCoordinateReferenceSystem());
    }

    private int[] doLabel(int[] data, int width, int height) {
        int i;
        int count;
        int i2;
        int nextlabel = 1;
        int[] nbs = new int[4];
        int[] nbls = new int[4];
        int d_w = width;
        int d_h = height;
        int[] dest_1d = new int[d_w * d_h];
        int[] labels = new int[d_w * d_h / 2];
        int result = 0;
        for (int i3 = 0; i3 < labels.length; ++i3) {
            labels[i3] = i3;
        }
        for (i2 = 0; i2 < data.length; ++i2) {
            int src1rgb = data[i2] & 0xFF;
            if (src1rgb == 0) {
                result = 0;
            } else {
                nbs[0] = this.getNeighbours(data, i2, -1, 0, d_w, d_h);
                nbs[1] = this.getNeighbours(data, i2, 0, -1, d_w, d_h);
                nbs[2] = this.getNeighbours(data, i2, -1, -1, d_w, d_h);
                nbs[3] = this.getNeighbours(data, i2, 1, -1, d_w, d_h);
                nbls[0] = this.getNeighbourd(dest_1d, i2, -1, 0, d_w, d_h);
                nbls[1] = this.getNeighbourd(dest_1d, i2, 0, -1, d_w, d_h);
                nbls[2] = this.getNeighbourd(dest_1d, i2, -1, -1, d_w, d_h);
                nbls[3] = this.getNeighbourd(dest_1d, i2, 1, -1, d_w, d_h);
                if (nbs[0] == nbs[1] && nbs[1] == nbs[2] && nbs[2] == nbs[3] && nbs[0] == 0) {
                    result = nextlabel++;
                } else {
                    int j;
                    count = 0;
                    int found = -1;
                    for (j = 0; j < 4; ++j) {
                        if (nbs[j] == 0) continue;
                        ++count;
                        found = j;
                    }
                    if (count == 1) {
                        result = nbls[found];
                    } else {
                        result = nbls[found];
                        for (j = 0; j < 4; ++j) {
                            if (nbls[j] == 0 || nbls[j] == result) continue;
                            this.associate(nbls[j], result, labels);
                        }
                    }
                }
            }
            dest_1d[i2] = result;
        }
        for (i2 = labels.length - 1; i2 > 0; --i2) {
            labels[i2] = this.reduce(i2, labels);
        }
        int[] condensed = new int[nextlabel];
        count = 0;
        for (int i4 = 0; i4 < nextlabel; ++i4) {
            if (i4 != labels[i4]) continue;
            condensed[i4] = count++;
        }
        int numberOfLabels = count - 1;
        int[] labelColors = new int[numberOfLabels + 1];
        for (i = 0; i < labelColors.length; ++i) {
            labelColors[i] = i;
        }
        for (i = 0; i < data.length; ++i) {
            result = condensed[labels[dest_1d[i]]];
            dest_1d[i] = labelColors[result];
        }
        return dest_1d;
    }

    private int getNeighbours(int[] src1d, int i, int ox, int oy, int d_w, int d_h) {
        int x = i % d_w + ox;
        int y = i / d_w + oy;
        int result = x < 0 || x >= d_w || y < 0 || y >= d_h ? 0 : src1d[y * d_w + x] & 0xFF;
        return result;
    }

    private int getNeighbourd(int[] src1d, int i, int ox, int oy, int d_w, int d_h) {
        int x = i % d_w + ox;
        int y = i / d_w + oy;
        int result = x < 0 || x >= d_w || y < 0 || y >= d_h ? 0 : src1d[y * d_w + x];
        return result;
    }

    private void associate(int a, int b, int[] labels) {
        if (a > b) {
            this.associate(b, a, labels);
            return;
        }
        if (a == b || labels[b] == a) {
            return;
        }
        if (labels[b] == b) {
            labels[b] = a;
        } else {
            this.associate(labels[b], a, labels);
            if (labels[b] > a) {
                labels[b] = a;
            }
        }
    }

    private int reduce(int a, int[] labels) {
        if (labels[a] == a) {
            return a;
        }
        return this.reduce(labels[a], labels);
    }
}

