/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.linesrasterizer;

import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.List;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.DirectPosition2D;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.exceptions.ModelsRuntimeException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.features.FeatureMate;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.gears.utils.geometry.EGeometryType;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.hortonmachine.gears.utils.math.NumericsUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Module to convert vector lines to raster.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector, Lines")
@Label(value="Raster Processing")
@Name(value="rasterizelines")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsLinesRasterizer
extends HMModel {
    @Description(value="The lines vector.")
    @In
    public SimpleFeatureCollection inVector = null;
    @Description(value="The optional field of the vector to take the category from.")
    @In
    public String fCat;
    @Description(value="The category to use if no field was set.")
    @In
    public double pCat = 1.0;
    @Description(value="The north bound of the region to consider")
    @UI(value="process_north")
    @In
    public Double pNorth = null;
    @Description(value="The south bound of the region to consider")
    @UI(value="process_south")
    @In
    public Double pSouth = null;
    @Description(value="The west bound of the region to consider")
    @UI(value="process_west")
    @In
    public Double pWest = null;
    @Description(value="The east bound of the region to consider")
    @UI(value="process_east")
    @In
    public Double pEast = null;
    @Description(value="The rows of the region to consider")
    @UI(value="process_rows")
    @In
    public Integer pRows = null;
    @Description(value="The cols of the region to consider")
    @UI(value="process_cols")
    @In
    public Integer pCols = null;
    @Description(value="The output raster.")
    @Out
    public GridCoverage2D outRaster;

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inVector);
        if (this.pNorth == null || this.pSouth == null || this.pWest == null || this.pEast == null || this.pRows == null || this.pCols == null) {
            throw new ModelsIllegalargumentException("It is necessary to supply all the information about the processing region. Did you set the boundaries and rows/cols?", this, this.pm);
        }
        SimpleFeatureType schema = (SimpleFeatureType)this.inVector.getSchema();
        CoordinateReferenceSystem crs = schema.getCoordinateReferenceSystem();
        GridGeometry2D inGrid = CoverageUtilities.gridGeometryFromRegionValues(this.pNorth, this.pSouth, this.pEast, this.pWest, this.pCols, this.pRows, crs);
        if (!EGeometryType.isLine(schema.getGeometryDescriptor())) {
            throw new ModelsRuntimeException("The module works only with line vectors.", this);
        }
        RegionMap regionMap = CoverageUtilities.gridGeometry2RegionParamsMap(inGrid);
        double n = regionMap.getNorth();
        double s = regionMap.getSouth();
        double e = regionMap.getEast();
        double w = regionMap.getWest();
        double xRes = regionMap.getXres();
        double yRes = regionMap.getYres();
        double step = Math.min(xRes, yRes);
        WritableRaster outWR = CoverageUtilities.createWritableRaster(regionMap.getCols(), regionMap.getRows(), null, null, -9999.0);
        WritableRandomIter outIter = RandomIterFactory.createWritable((WritableRaster)outWR, null);
        List<FeatureMate> matesList = FeatureUtilities.featureCollectionToMatesList(this.inVector);
        this.pm.beginTask("Rasterizing lines...", matesList.size());
        String fCatChecked = null;
        for (FeatureMate featureMate : matesList) {
            Geometry geometry = featureMate.getGeometry();
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                double cat;
                Geometry geometryN = geometry.getGeometryN(i);
                List<Coordinate> lineCoordinatesAtStep = GeometryUtilities.getCoordinatesAtInterval((LineString)geometryN, step, true, -1.0, -1.0);
                if (this.fCat == null) {
                    cat = this.pCat;
                } else {
                    if (fCatChecked == null && (fCatChecked = FeatureUtilities.findAttributeName(featureMate.getFeature().getFeatureType(), this.fCat)) == null) {
                        throw new ModelsIllegalargumentException("Could not find an attribute named: " + this.fCat, this, this.pm);
                    }
                    cat = featureMate.getAttribute(this.fCat, Double.class);
                }
                for (Coordinate lineCoordinate : lineCoordinatesAtStep) {
                    if (!NumericsUtilities.isBetween(lineCoordinate.x, w, e) || !NumericsUtilities.isBetween(lineCoordinate.y, s, n)) continue;
                    GridCoordinates2D onGrid = inGrid.worldToGrid((DirectPosition)new DirectPosition2D(lineCoordinate.x, lineCoordinate.y));
                    outIter.setSample(onGrid.x, onGrid.y, 0, cat);
                }
            }
            this.pm.worked(1);
        }
        this.pm.done();
        this.outRaster = CoverageUtilities.buildCoverage("pointsraster", outWR, (HashMap<String, Double>)regionMap, ((SimpleFeatureType)this.inVector.getSchema()).getCoordinateReferenceSystem());
    }
}

