/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.mapcalc;

import it.geosolutions.jaiext.jiffle.Jiffle;
import it.geosolutions.jaiext.jiffle.runtime.AffineCoordinateTransform;
import it.geosolutions.jaiext.jiffle.runtime.CoordinateTransform;
import it.geosolutions.jaiext.jiffle.runtime.JiffleDirectRuntime;
import it.geosolutions.jaiext.jiffle.runtime.JiffleProgressListener;
import it.geosolutions.jaiext.jiffle.runtime.NullProgressListener;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.util.HashMap;
import java.util.List;
import javax.media.jai.TiledImage;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.jaitools.imageutils.ImageUtils;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Module for doing raster map algebra.")
@Documentation(value="OmsMapcalc.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="OmsMapcalc, Raster, OmsCutOut")
@Label(value="Raster Processing")
@Name(value="omsmapcalc")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsMapcalc
extends HMModel {
    @Description(value="The maps that are used in the calculation.")
    @In
    public List<GridCoverage2D> inRasters;
    @Description(value="The function to process.")
    @UI(value="multiline10,mapcalc")
    @In
    public String pFunction;
    @Description(value="The resulting map picked from the inserted function.")
    @Out
    public GridCoverage2D outRaster = null;
    private HashMap<String, Double> regionParameters = null;
    private CoordinateReferenceSystem crs;
    private Rectangle2D worldBounds;
    private long updateInterval;
    private long totalCount = 100L;

    @Execute
    public void process() throws Exception {
        int nRows;
        if (!this.concatOr(this.outRaster == null, this.doReset)) {
            return;
        }
        String script = this.pFunction;
        script = script.trim();
        Jiffle jiffle = new Jiffle();
        jiffle.setScript(script);
        jiffle.compile();
        JiffleDirectRuntime jiffleRuntime = jiffle.getRuntimeInstance();
        CoordinateTransform jiffleCRS = null;
        for (GridCoverage2D mapGC : this.inRasters) {
            if (this.regionParameters == null) {
                this.regionParameters = CoverageUtilities.getRegionParamsFromGridCoverage(mapGC);
                this.crs = mapGC.getCoordinateReferenceSystem();
                this.worldBounds = mapGC.getEnvelope2D().getBounds2D();
                Rectangle gridBounds = mapGC.getGridGeometry().getGridRange2D().getBounds();
                jiffleCRS = OmsMapcalc.getTransform(this.worldBounds, gridBounds);
                double xRes = this.regionParameters.get("XRES");
                double yRes = this.regionParameters.get("YRES");
                jiffleRuntime.setWorldByResolution(this.worldBounds, xRes, yRes);
            }
            RenderedImage renderedImage = mapGC.getRenderedImage();
            String name = mapGC.getName().toString();
            jiffleRuntime.setSourceImage(name, renderedImage, jiffleCRS);
        }
        if (this.regionParameters == null) {
            throw new ModelsIllegalargumentException("No map has been supplied.", this.getClass().getSimpleName(), this.pm);
        }
        int nCols = this.regionParameters.get("COLS").intValue();
        long pixelsNum = (long)nCols * (long)(nRows = this.regionParameters.get("ROWS").intValue());
        if (pixelsNum < this.totalCount) {
            this.totalCount = pixelsNum;
        }
        this.updateInterval = pixelsNum / this.totalCount;
        String destName = jiffleRuntime.getDestinationVarNames()[0];
        TiledImage destImg = ImageUtils.createConstantImage((int)nCols, (int)nRows, (Number)0.0);
        jiffleRuntime.setDestinationImage(destName, (WritableRenderedImage)destImg, jiffleCRS);
        jiffleRuntime.evaluateAll((JiffleProgressListener)new NullProgressListener());
        this.outRaster = CoverageUtilities.buildCoverage(destName, (RenderedImage)destImg, this.regionParameters, this.crs);
    }

    private static CoordinateTransform getTransform(Rectangle2D worldBounds, Rectangle imageBounds) {
        if (worldBounds == null || worldBounds.isEmpty()) {
            throw new IllegalArgumentException("worldBounds must not be null or empty");
        }
        if (imageBounds == null || imageBounds.isEmpty()) {
            throw new IllegalArgumentException("imageBounds must not be null or empty");
        }
        double xscale = (imageBounds.getMaxX() - imageBounds.getMinX()) / (worldBounds.getMaxX() - worldBounds.getMinX());
        double xoff = imageBounds.getMinX() - xscale * worldBounds.getMinX();
        double yscale = (imageBounds.getMaxY() - imageBounds.getMinY()) / (worldBounds.getMaxY() - worldBounds.getMinY());
        double yoff = imageBounds.getMinY() - yscale * worldBounds.getMinY();
        return new AffineCoordinateTransform(new AffineTransform(xscale, 0.0, 0.0, yscale, xoff, yoff));
    }
}

