/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.morpher;

import java.awt.image.WritableRaster;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.GridNode;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;
import org.hortonmachine.gears.modules.r.morpher.MorpherHelp;
import org.hortonmachine.gears.modules.r.morpher.Thin;
import org.hortonmachine.gears.modules.utils.BinaryFast;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;

@Description(value="Mophologic binary operations")
@Author(name="Simon Horne, Andrea Antonello", contact="http://homepages.inf.ed.ac.uk/rbf/HIPR2/, www.hydrologis.com")
@Keywords(value="Dilation, Erosion, Skeletonize, Open, Close, Raster")
@Label(value="Raster Processing")
@Name(value="omsmorpher")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsMorpher
extends HMModel {
    @Description(value="The map to morph.")
    @In
    public GridCoverage2D inMap = null;
    @Description(value="A kernel to use instead of the default.")
    @In
    public int[] pKernel = null;
    @Description(value="Process in binary mode.")
    @In
    public boolean doBinary = true;
    @Description(value="The operation type to perform (dilate, erode, skeletonize(1,2,2var,3), prune, open, close, lineendings, linejunctions)")
    @UI(value="combo:dilate,erode,skeletonize1,skeletonize2,skeletonize2var,skeletonize3,prune,open,close,lineendings,linejunctions")
    @In
    public String pMode = "dilate";
    @Description(value="Number of iterations (used in case of pruning).")
    @In
    public int pIterations = 3;
    @Description(value="The resulting map.")
    @Out
    public GridCoverage2D outMap = null;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outMap == null, this.doReset)) {
            return;
        }
        if (this.pKernel == null) {
            this.pKernel = MorpherHelp.DEFAULT3X3KERNEL;
        }
        double inNovalue = HMConstants.getNovalue(this.inMap);
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inMap);
        WritableRaster inWR = CoverageUtilities.renderedImage2WritableRaster(this.inMap.getRenderedImage(), false);
        WritableRaster[] wrHolder = new WritableRaster[1];
        this.outMap = CoverageUtilities.createCoverageFromTemplate(this.inMap, -9999.0, wrHolder);
        WritableRaster outWR = wrHolder[0];
        if (this.pMode.equals("skeletonize1")) {
            OmsMorpher.skeletonize(inWR, regionMap, outWR, MorpherHelp.SKELETON1_KERNEL);
        } else if (this.pMode.equals("skeletonize2")) {
            OmsMorpher.skeletonize(inWR, regionMap, outWR, MorpherHelp.SKELETON2_KERNEL);
        } else if (this.pMode.equals("skeletonize2var")) {
            OmsMorpher.skeletonize(inWR, regionMap, outWR, MorpherHelp.SKELETON2VARIANT_KERNEL);
        } else if (this.pMode.equals("skeletonize3")) {
            OmsMorpher.skeletonize(inWR, regionMap, outWR, MorpherHelp.SKELETON3_KERNEL);
        } else if (this.pMode.equals("lineendings")) {
            OmsMorpher.lineendings(inWR, regionMap, outWR, MorpherHelp.LINEEND_KERNEL);
        } else if (this.pMode.equals("linejunctions")) {
            OmsMorpher.lineendings(inWR, regionMap, outWR, MorpherHelp.LINEJUNCTIONS_KERNEL);
        } else if (this.pMode.equals("prune")) {
            if (this.pIterations == 0) {
                throw new ModelsIllegalargumentException("Number of iterations has to be > 0.", this, this.pm);
            }
            OmsMorpher.prune(inWR, regionMap, outWR, MorpherHelp.DEFAULT_PRUNE_KERNEL, this.pIterations);
        } else if (this.pMode.equals("dilate")) {
            OmsMorpher.dilate(inWR, inNovalue, regionMap, outWR, this.pKernel, this.doBinary, this.pm);
        } else if (this.pMode.equals("erode")) {
            OmsMorpher.erode(inWR, inNovalue, regionMap, outWR, this.pKernel, this.pm);
        } else if (this.pMode.equals("open")) {
            OmsMorpher.open(inWR, inNovalue, regionMap, outWR, this.pKernel, this.doBinary, this.pm);
        } else if (this.pMode.equals("close")) {
            OmsMorpher.close(inWR, inNovalue, regionMap, outWR, this.pKernel, this.doBinary, this.pm);
        } else {
            throw new ModelsIllegalargumentException("Could not recognize mode.", this, this.pm);
        }
    }

    public static void dilate(WritableRaster inWR, double inNovalue, RegionMap regionMap, WritableRaster outWR, int[] kernelArray, boolean binary, IHMProgressMonitor pm) {
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        double xres = regionMap.getXres();
        double yres = regionMap.getYres();
        WritableRandomIter inIter = RandomIterFactory.createWritable((WritableRaster)inWR, null);
        WritableRandomIter outIter = RandomIterFactory.createWritable((WritableRaster)outWR, null);
        int[][] kernel = MorpherHelp.getSquareKernelMatrix(kernelArray);
        pm.beginTask("Perform dilation...", cols);
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                GridNode node = new GridNode((RandomIter)inIter, cols, rows, xres, yres, c, r, inNovalue);
                if (!node.isValid()) {
                    double[][] nodeNeighbours = node.getWindow(kernel.length, false);
                    boolean set = false;
                    boolean doBreak = false;
                    double max = Double.NEGATIVE_INFINITY;
                    for (int kr = 0; kr < kernel.length; ++kr) {
                        for (int kc = 0; kc < kernel[0].length; ++kc) {
                            if (kernel[kr][kc] != 1 || HMConstants.isNovalue(nodeNeighbours[kr][kc]) || !(nodeNeighbours[kr][kc] > max)) continue;
                            max = nodeNeighbours[kr][kc];
                            set = true;
                            if (binary) break;
                        }
                        if (doBreak) break;
                    }
                    if (set) {
                        node.setDoubleValueInMap(outIter, max);
                        continue;
                    }
                    node.setDoubleValueInMap(outIter, -9999.0);
                    continue;
                }
                node.setDoubleValueInMap(outIter, node.elevation);
            }
            pm.worked(1);
        }
        pm.done();
    }

    public static void erode(WritableRaster inWR, double inNovalue, RegionMap regionMap, WritableRaster outWR, int[] kernelArray, IHMProgressMonitor pm) {
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        double xres = regionMap.getXres();
        double yres = regionMap.getYres();
        WritableRandomIter inIter = RandomIterFactory.createWritable((WritableRaster)inWR, null);
        WritableRandomIter outIter = RandomIterFactory.createWritable((WritableRaster)outWR, null);
        int[][] kernel = MorpherHelp.getSquareKernelMatrix(kernelArray);
        pm.beginTask("Perform erosion...", cols);
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                GridNode node = new GridNode((RandomIter)inIter, cols, rows, xres, yres, c, r, inNovalue);
                if (!node.isValid()) continue;
                double[][] nodeNeighbours = node.getWindow(kernel.length, false);
                boolean set = false;
                double min = Double.POSITIVE_INFINITY;
                for (int kr = 0; kr < kernel.length; ++kr) {
                    for (int kc = 0; kc < kernel[0].length; ++kc) {
                        if (kernel[kr][kc] != 1) continue;
                        if (HMConstants.isNovalue(nodeNeighbours[kr][kc])) {
                            min = -9999.0;
                            set = true;
                            break;
                        }
                        if (!(nodeNeighbours[kr][kc] < min)) continue;
                        min = nodeNeighbours[kr][kc];
                        set = true;
                    }
                    if (HMConstants.isNovalue(min)) break;
                }
                if (set) {
                    node.setDoubleValueInMap(outIter, min);
                    continue;
                }
                node.setDoubleValueInMap(outIter, node.elevation);
            }
            pm.worked(1);
        }
        pm.done();
    }

    public static void open(WritableRaster inWR, double inNovalue, RegionMap regionMap, WritableRaster outWR, int[] kernelArray, boolean binary, IHMProgressMonitor pm) {
        OmsMorpher.erode(inWR, inNovalue, regionMap, outWR, kernelArray, pm);
        inWR.setDataElements(0, 0, outWR);
        OmsMorpher.clearRaster(regionMap, outWR);
        OmsMorpher.dilate(inWR, inNovalue, regionMap, outWR, kernelArray, binary, pm);
    }

    public static void close(WritableRaster inWR, double inNovalue, RegionMap regionMap, WritableRaster outWR, int[] kernelArray, boolean binary, IHMProgressMonitor pm) {
        OmsMorpher.dilate(inWR, inNovalue, regionMap, outWR, kernelArray, binary, pm);
        inWR.setDataElements(0, 0, outWR);
        OmsMorpher.clearRaster(regionMap, outWR);
        OmsMorpher.erode(inWR, inNovalue, regionMap, outWR, kernelArray, pm);
    }

    public static void skeletonize(WritableRaster inWR, RegionMap regionMap, WritableRaster outWR, int[][] kernels) {
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        WritableRandomIter inIter = RandomIterFactory.createWritable((WritableRaster)inWR, null);
        WritableRandomIter outIter = RandomIterFactory.createWritable((WritableRaster)outWR, null);
        BinaryFast binaryData = OmsMorpher.toBinaryFast(cols, rows, inIter);
        new Thin().processSkeleton(binaryData, kernels);
        OmsMorpher.fromBinaryFast(cols, rows, outIter, binaryData);
    }

    public static void prune(WritableRaster inWR, RegionMap regionMap, WritableRaster outWR, int[][] kernels, int iterations) {
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        WritableRandomIter inIter = RandomIterFactory.createWritable((WritableRaster)inWR, null);
        WritableRandomIter outIter = RandomIterFactory.createWritable((WritableRaster)outWR, null);
        BinaryFast binaryData = OmsMorpher.toBinaryFast(cols, rows, inIter);
        new Thin().processPruning(binaryData, iterations, kernels);
        OmsMorpher.fromBinaryFast(cols, rows, outIter, binaryData);
    }

    public static void lineendings(WritableRaster inWR, RegionMap regionMap, WritableRaster outWR, int[][] kernels) {
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        WritableRandomIter inIter = RandomIterFactory.createWritable((WritableRaster)inWR, null);
        WritableRandomIter outIter = RandomIterFactory.createWritable((WritableRaster)outWR, null);
        BinaryFast binaryData = OmsMorpher.toBinaryFast(cols, rows, inIter);
        new Thin().processLineendings(binaryData, kernels);
        int[] values = binaryData.getValues();
        int index = 0;
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                double origValue;
                double value = values[index];
                if (value == 0.0) {
                    value = -9999.0;
                }
                if (!HMConstants.isNovalue(origValue = inIter.getSampleDouble(x, y, 0)) && HMConstants.isNovalue(value)) {
                    outIter.setSample(x, y, 0, 1);
                }
                ++index;
            }
        }
    }

    private static void clearRaster(RegionMap regionMap, WritableRaster outWR) {
        for (int r = 0; r < regionMap.getRows(); ++r) {
            for (int c = 0; c < regionMap.getCols(); ++c) {
                outWR.setSample(c, r, 0, -9999.0);
            }
        }
    }

    public static void fromBinaryFast(int cols, int rows, WritableRandomIter outIter, BinaryFast binaryData) {
        int[] values = binaryData.getValues();
        int index = 0;
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                double value = values[index];
                if (value == 0.0) {
                    value = -9999.0;
                }
                outIter.setSample(x, y, 0, value);
                ++index;
            }
        }
    }

    public static BinaryFast toBinaryFast(int cols, int rows, WritableRandomIter inIter) {
        int[][] data = new int[cols][rows];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                double value = inIter.getSampleDouble(c, r, 0);
                data[c][r] = 0;
                if (HMConstants.isNovalue(value)) continue;
                data[c][r] = 1;
            }
        }
        BinaryFast binaryData = new BinaryFast(data);
        return binaryData;
    }
}

