/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.morpher;

import java.awt.Point;
import java.util.HashSet;
import java.util.Iterator;
import org.hortonmachine.gears.modules.utils.BinaryFast;

public class Thin {
    private BinaryFast thinBinaryRep(BinaryFast b, int[] kernel) {
        HashSet<Point> inputHashSet = new HashSet<Point>();
        int[][] pixels = b.getPixels();
        if (this.kernelNo0s(kernel)) {
            for (int j = 0; j < b.getHeight(); ++j) {
                for (int i = 0; i < b.getWidth(); ++i) {
                    if (pixels[i][j] != 1) continue;
                    inputHashSet.add(new Point(i, j));
                }
            }
        } else {
            Iterator<Point> it = b.getForegroundEdgePixels().iterator();
            while (it.hasNext()) {
                inputHashSet.add(it.next());
            }
        }
        HashSet<Point> result = this.hitMissHashSet(b, inputHashSet, kernel);
        Iterator<Point> it = result.iterator();
        while (it.hasNext()) {
            Point p = new Point(it.next());
            b.removePixel(p);
            b.getForegroundEdgePixels().remove(p);
            b.getBackgroundEdgePixels().add(p);
            for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    if (p.x + j < 0 || p.y + k <= 0 || p.x + j >= b.getWidth() || p.y + k >= b.getHeight() || pixels[p.x + j][p.y + k] != 1) continue;
                    Point p2 = new Point(p.x + j, p.y + k);
                    b.getForegroundEdgePixels().add(p2);
                }
            }
        }
        return b;
    }

    public void processSkeleton(BinaryFast binary, int[][] kernel) {
        int oldForeEdge = 0;
        int oldBackEdge = 0;
        while (binary.getForegroundEdgePixels().size() != oldForeEdge || binary.getBackgroundEdgePixels().size() != oldBackEdge) {
            oldForeEdge = binary.getForegroundEdgePixels().size();
            oldBackEdge = binary.getBackgroundEdgePixels().size();
            for (int i = 0; i < kernel.length; ++i) {
                binary = this.thinBinaryRep(binary, kernel[i]);
                binary.generateBackgroundEdgeFromForegroundEdge();
            }
        }
    }

    public void processPruning(BinaryFast binary, int iterations, int[][] kernels) {
        for (int j = 0; j < iterations; ++j) {
            for (int i = 0; i < kernels.length; ++i) {
                binary = this.thinBinaryRep(binary, kernels[i]);
                binary.generateBackgroundEdgeFromForegroundEdge();
            }
        }
    }

    public void processLineendings(BinaryFast binary, int[][] kernels) {
        for (int i = 0; i < kernels.length; ++i) {
            binary = this.thinBinaryRep(binary, kernels[i]);
            binary.generateBackgroundEdgeFromForegroundEdge();
        }
    }

    private boolean kernelMatch(Point p, int[][] pixels, int w, int h, int[] kernel) {
        int matched = 0;
        for (int j = -1; j < 2; ++j) {
            for (int i = -1; i < 2; ++i) {
                if (kernel[(j + 1) * 3 + (i + 1)] == 2) {
                    ++matched;
                    continue;
                }
                if (p.x + i < 0 || p.x + i >= w || p.y + j < 0 || p.y + j >= h || (pixels[p.x + i][p.y + j] != 1 || kernel[(j + 1) * 3 + (i + 1)] != 1) && (pixels[p.x + i][p.y + j] != 0 || kernel[(j + 1) * 3 + (i + 1)] != 0)) continue;
                ++matched;
            }
        }
        return matched == 9;
    }

    private HashSet<Point> hitMissHashSet(BinaryFast b, HashSet<Point> input, int[] kernel) {
        HashSet<Point> output = new HashSet<Point>();
        for (Point p : input) {
            if (!this.kernelMatch(p, b.getPixels(), b.getWidth(), b.getHeight(), kernel)) continue;
            output.add(p);
        }
        return output;
    }

    private boolean kernelNo0s(int[] kernel) {
        for (int i = 0; i < kernel.length; ++i) {
            if (kernel[i] != 0) continue;
            return false;
        }
        return true;
    }
}

