/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.mosaic;

import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.Envelope2D;
import org.hortonmachine.gears.io.rasterreader.OmsRasterReader;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.CrsUtilities;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Module for raster patching.")
@Documentation(value="OmsMosaic.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="OmsMosaic, Raster")
@Label(value="Raster Processing")
@Name(value="mosaic")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsMosaic
extends HMModel {
    @Description(value="The list of maps that have to be patched.")
    @In
    public List<File> inFiles;
    @Description(value="The interpolation type to use")
    @UI(value="combo:nearest neightbour,bilinear,bicubic")
    @In
    public String pInterpolation = "nearest neightbour";
    @Description(value="The patched map.")
    @Out
    public GridCoverage2D outRaster = null;
    private CoordinateReferenceSystem crs;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outRaster == null, this.doReset)) {
            return;
        }
        if (this.inFiles == null) {
            throw new ModelsIllegalargumentException("No input data have been provided.", this, this.pm);
        }
        if (this.inFiles != null && this.inFiles.size() < 2) {
            throw new ModelsIllegalargumentException("The patching module needs at least two maps to be patched.", this, this.pm);
        }
        GridGeometry2D referenceGridGeometry = null;
        double n = Double.MIN_VALUE;
        double s = Double.MAX_VALUE;
        double e = Double.MIN_VALUE;
        double w = Double.MAX_VALUE;
        int np = Integer.MIN_VALUE;
        int sp = Integer.MAX_VALUE;
        int ep = Integer.MIN_VALUE;
        int wp = Integer.MAX_VALUE;
        this.pm.beginTask("Calculating final bounds...", this.inFiles.size());
        for (File coverageFile : this.inFiles) {
            GridCoverage2D coverage = OmsRasterReader.readRaster(coverageFile.getAbsolutePath());
            if (referenceGridGeometry == null) {
                this.crs = coverage.getCoordinateReferenceSystem();
                referenceGridGeometry = coverage.getGridGeometry();
                this.pm.message("Using crs: " + CrsUtilities.getCodeFromCrs(this.crs));
            }
            Envelope2D worldEnv = coverage.getEnvelope2D();
            GridEnvelope2D pixelEnv = referenceGridGeometry.worldToGrid(worldEnv);
            int minPX = (int)pixelEnv.getMinX();
            int minPY = (int)pixelEnv.getMinY();
            int maxPX = (int)pixelEnv.getMaxX();
            int maxPY = (int)pixelEnv.getMaxY();
            if (minPX < wp) {
                wp = minPX;
            }
            if (minPY < sp) {
                sp = minPY;
            }
            if (maxPX > ep) {
                ep = maxPX;
            }
            if (maxPY > np) {
                np = maxPY;
            }
            double minWX = worldEnv.getMinX();
            double minWY = worldEnv.getMinY();
            double maxWX = worldEnv.getMaxX();
            double maxWY = worldEnv.getMaxY();
            if (minWX < w) {
                w = minWX;
            }
            if (minWY < s) {
                s = minWY;
            }
            if (maxWX > e) {
                e = maxWX;
            }
            if (maxWY > n) {
                n = maxWY;
            }
            this.pm.worked(1);
        }
        this.pm.done();
        int endWidth = ep - wp;
        int endHeight = np - sp;
        this.pm.message(MessageFormat.format("Output raster will have {0} cols and {1} rows.", endWidth, endHeight));
        WritableRaster outputWR = CoverageUtilities.createWritableRaster(endWidth, endHeight, null, null, -9999.0);
        WritableRandomIter outputIter = RandomIterFactory.createWritable((WritableRaster)outputWR, null);
        int offestX = Math.abs(wp);
        int offestY = Math.abs(sp);
        int index = 1;
        for (File coverageFile : this.inFiles) {
            GridCoverage2D coverage = OmsRasterReader.readRaster(coverageFile.getAbsolutePath());
            RenderedImage renderedImage = coverage.getRenderedImage();
            RandomIter randomIter = RandomIterFactory.create((RenderedImage)renderedImage, null);
            Envelope2D env = coverage.getEnvelope2D();
            GridEnvelope2D repEnv = referenceGridGeometry.worldToGrid(env);
            GridGeometry2D tmpGG = coverage.getGridGeometry();
            GridEnvelope2D tmpEnv = tmpGG.worldToGrid(env);
            int startX = (int)(repEnv.getMinX() + (double)offestX);
            int startY = (int)(repEnv.getMinY() + (double)offestY);
            double tmpW = tmpEnv.getWidth();
            double tmpH = tmpEnv.getHeight();
            this.pm.beginTask("Patch map " + index++, (int)tmpW);
            int y = 0;
            while ((double)y < tmpH) {
                int x = 0;
                while ((double)x < tmpW) {
                    double value = randomIter.getSampleDouble(x, y, 0);
                    outputIter.setSample(x + startX, y + startY, 0, value);
                    ++x;
                }
                this.pm.worked(1);
                ++y;
            }
            this.pm.done();
            randomIter.done();
        }
        HashMap<String, Double> envelopeParams = new HashMap<String, Double>();
        envelopeParams.put("NORTH", n);
        envelopeParams.put("SOUTH", s);
        envelopeParams.put("WEST", w);
        envelopeParams.put("EAST", e);
        this.outRaster = CoverageUtilities.buildCoverage("patch", outputWR, envelopeParams, this.crs);
    }
}

