/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.mosaic;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.hortonmachine.gears.io.rasterwriter.OmsRasterWriter;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.mosaic.OmsMosaic;

@Description(value="Module for patching max 12 rasters.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="OmsMosaic, Raster")
@Label(value="Raster Processing")
@Name(value="mosaic12")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsMosaic12
extends HMModel {
    @Description(value="The Map N.1 to be patched")
    @UI(value="infile_raster")
    @In
    public String inMap1;
    @Description(value="The Map N.2 to be patched")
    @UI(value="infile_raster")
    @In
    public String inMap2;
    @Description(value="The optional Map N.3 to be patched")
    @UI(value="infile_raster")
    @In
    public String inMap3;
    @Description(value="The optional Map N.4 to be patched")
    @UI(value="infile_raster")
    @In
    public String inMap4;
    @Description(value="The optional Map N.5 to be patched")
    @UI(value="infile_raster")
    @In
    public String inMap5;
    @Description(value="The optional Map N.6 to be patched")
    @UI(value="infile_raster")
    @In
    public String inMap6;
    @Description(value="The optional Map N.7 to be patched")
    @UI(value="infile_raster")
    @In
    public String inMap7;
    @Description(value="The optional Map N.8 to be patched")
    @UI(value="infile_raster")
    @In
    public String inMap8;
    @Description(value="The optional Map N.9 to be patched")
    @UI(value="infile_raster")
    @In
    public String inMap9;
    @Description(value="The optional Map N.10 to be patched")
    @UI(value="infile_raster")
    @In
    public String inMap10;
    @Description(value="The optional Map N.11 to be patched")
    @UI(value="infile_raster")
    @In
    public String inMap11;
    @Description(value="The optional Map N.12 to be patched")
    @UI(value="infile_raster")
    @In
    public String inMap12;
    @Description(value="The interpolation type to use")
    @UI(value="combo:nearest neightbour,bilinear,bicubic")
    @In
    public String pInterpolation = "nearest neightbour";
    @Description(value="The patched map.")
    @UI(value="outfile")
    @In
    public String outMap = null;
    public GridCoverage2D outRaster;
    public boolean testmode = false;

    @Execute
    public void process() throws Exception {
        if (!this.testmode) {
            this.checkNull(this.outMap);
        }
        ArrayList<File> filesList = new ArrayList<File>();
        this.checkMap(filesList, this.inMap1);
        this.checkMap(filesList, this.inMap2);
        this.checkMap(filesList, this.inMap3);
        this.checkMap(filesList, this.inMap4);
        this.checkMap(filesList, this.inMap5);
        this.checkMap(filesList, this.inMap6);
        this.checkMap(filesList, this.inMap7);
        this.checkMap(filesList, this.inMap8);
        this.checkMap(filesList, this.inMap9);
        this.checkMap(filesList, this.inMap10);
        this.checkMap(filesList, this.inMap11);
        this.checkMap(filesList, this.inMap12);
        if (filesList.size() < 2) {
            throw new ModelsIllegalargumentException("The patching module needs at least two maps to be patched.", this, this.pm);
        }
        OmsMosaic mosaic = new OmsMosaic();
        mosaic.inFiles = filesList;
        mosaic.pm = this.pm;
        mosaic.process();
        this.outRaster = mosaic.outRaster;
        if (!this.testmode) {
            OmsRasterWriter.writeRaster(this.outMap, this.outRaster);
        }
    }

    private void checkMap(List<File> filesList, String inMap) {
        File tmp;
        if (inMap != null && (tmp = new File(inMap)).exists()) {
            filesList.add(tmp);
        }
    }
}

