/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.modules.r.pointsrasterizer;

import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.List;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.DirectPosition2D;
import org.hortonmachine.gears.libs.exceptions.ModelsRuntimeException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.features.FeatureMate;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.gears.utils.geometry.EGeometryType;
import org.hortonmachine.gears.utils.math.NumericsUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.DirectPosition;

@Description(value="Module to convert vector points to raster. Currently this does simply put the point in the nearest cell, without check.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Raster, Vector, Points")
@Label(value="Raster Processing")
@Name(value="rasterizepoints")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsPointsRasterizer
extends HMModel {
    @Description(value="The points vector.")
    @In
    public SimpleFeatureCollection inVector = null;
    @Description(value="The grid on which to place the values.")
    @In
    public GridGeometry2D inGrid;
    @Description(value="The field of the vector to take the category from.")
    @In
    public String fCat;
    @Description(value="The output raster.")
    @Out
    public GridCoverage2D outRaster;

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inGrid, this.inVector);
        SimpleFeatureType schema = (SimpleFeatureType)this.inVector.getSchema();
        if (!EGeometryType.isPoint(schema.getGeometryDescriptor())) {
            throw new ModelsRuntimeException("The module works only with point vectors.", this);
        }
        RegionMap regionMap = CoverageUtilities.gridGeometry2RegionParamsMap(this.inGrid);
        double n = regionMap.getNorth();
        double s = regionMap.getSouth();
        double e = regionMap.getEast();
        double w = regionMap.getWest();
        WritableRaster outWR = CoverageUtilities.createWritableRaster(regionMap.getCols(), regionMap.getRows(), null, null, -9999.0);
        WritableRandomIter outIter = RandomIterFactory.createWritable((WritableRaster)outWR, null);
        List<FeatureMate> matesList = FeatureUtilities.featureCollectionToMatesList(this.inVector);
        double value = 0.0;
        this.pm.beginTask("Rasterizing points...", matesList.size());
        for (FeatureMate featureMate : matesList) {
            Coordinate[] coordinates;
            Double cat;
            Geometry geometry = featureMate.getGeometry();
            if (this.fCat == null && (cat = featureMate.getAttribute(this.fCat, Double.class)) != null) {
                value = cat;
            }
            for (Coordinate coordinate : coordinates = geometry.getCoordinates()) {
                if (!NumericsUtilities.isBetween(coordinate.x, w, e) || !NumericsUtilities.isBetween(coordinate.y, s, n)) continue;
                GridCoordinates2D onGrid = this.inGrid.worldToGrid((DirectPosition)new DirectPosition2D(coordinate.x, coordinate.y));
                outIter.setSample(onGrid.x, onGrid.y, 0, value);
            }
            this.pm.worked(1);
        }
        this.pm.done();
        this.outRaster = CoverageUtilities.buildCoverage("pointsraster", outWR, (HashMap<String, Double>)regionMap, ((SimpleFeatureType)this.inVector.getSchema()).getCoordinateReferenceSystem());
    }
}

